/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.component.Ordered;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.core.OrderComparator;

public class ComponentUtils {
    private static final Logger LOG = Logger.getLogger(ComponentUtils.class);

    public static <T extends Component> T copy(T component) {
        return ComponentUtils.copy(component, null);
    }

    public static <T extends Component> T copy(T component, String idSuffix) {
        Component copy = (Component)component.copy();
        if (StringUtils.isNotBlank((String)idSuffix)) {
            ComponentUtils.updateIdsWithSuffixNested(copy, idSuffix);
        }
        return (T)copy;
    }

    protected static <T> T getNewInstance(T object) {
        T copy = null;
        try {
            copy = (T)object.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create new instance of class: " + object.getClass());
        }
        return copy;
    }

    public static <T extends Field> void bindAndIdFieldList(List<T> fields, String addBindingPrefix, String idSuffix) {
        ComponentUtils.updateIdsWithSuffixNested(fields, idSuffix);
        ComponentUtils.prefixBindingPath(fields, addBindingPrefix);
    }

    public static <T extends Field> List<T> copyFieldList(List<T> fields, String addBindingPrefix, String idSuffix) {
        List<T> copiedFieldList = ComponentUtils.copyFieldList(fields, idSuffix);
        ComponentUtils.prefixBindingPath(copiedFieldList, addBindingPrefix);
        return copiedFieldList;
    }

    public static <T extends Field> List<T> copyFieldList(List<T> fields, String idSuffix) {
        if (fields == null || fields.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Field> copiedFieldList = new ArrayList<Field>(fields.size());
        for (Field field : fields) {
            Field copiedField = ComponentUtils.copy(field, idSuffix);
            copiedFieldList.add(copiedField);
        }
        return copiedFieldList;
    }

    public static <T extends Component> T copyComponent(T component, String addBindingPrefix, String idSuffix) {
        T copy = ComponentUtils.copy(component, idSuffix);
        ComponentUtils.prefixBindingPathNested(copy, addBindingPrefix);
        return copy;
    }

    public static <T extends Component> List<T> copyComponentList(List<T> components, String idSuffix) {
        if (components == null || components.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Component> copiedComponentList = new ArrayList<Component>(components.size());
        for (Component field : components) {
            Component copiedComponent = ComponentUtils.copy(field, idSuffix);
            copiedComponentList.add(copiedComponent);
        }
        return copiedComponentList;
    }

    public static <T extends Component> List<T> getComponentsOfType(List<? extends Component> items, Class<T> componentType) {
        if (items == null || items.isEmpty()) {
            return Collections.emptyList();
        }
        List typeComponents = Collections.emptyList();
        for (Component component : items) {
            if (!componentType.isInstance(component)) continue;
            if (typeComponents.isEmpty()) {
                typeComponents = new ArrayList(items.size());
            }
            typeComponents.add(componentType.cast(component));
        }
        return typeComponents;
    }

    public static <T extends Component> List<T> getComponentsOfTypeDeep(List<? extends Component> items, Class<T> componentType) {
        if (items == null) {
            return Collections.emptyList();
        }
        List components = Collections.emptyList();
        LinkedList<? extends Component> componentQueue = new LinkedList<Component>();
        componentQueue.addAll(items);
        while (!componentQueue.isEmpty()) {
            Component currentComponent = (Component)componentQueue.poll();
            if (currentComponent == null) continue;
            if (componentType.isInstance(currentComponent)) {
                if (components.isEmpty()) {
                    components = new ArrayList();
                }
                components.add(componentType.cast(currentComponent));
            }
            componentQueue.addAll(currentComponent.getComponentsForLifecycle());
        }
        return components;
    }

    public static <T extends Component> List<T> getComponentsOfTypeDeep(Component component, Class<T> componentType) {
        return ComponentUtils.getComponentsOfTypeDeep(Collections.singletonList(component), componentType);
    }

    public static <T extends Component> List<T> getComponentsOfTypeShallow(Component component, Class<T> componentType) {
        if (component == null) {
            return Collections.emptyList();
        }
        List<T> typeComponents = ComponentUtils.getNestedComponentsOfTypeShallow(component, componentType);
        if (componentType.isInstance(component)) {
            if (typeComponents.isEmpty()) {
                typeComponents = Collections.singletonList(componentType.cast(component));
            } else {
                typeComponents.add(0, componentType.cast(component));
            }
        }
        return typeComponents;
    }

    public static <T extends Component> List<T> getNestedComponentsOfTypeShallow(Component component, Class<T> componentType) {
        if (component == null) {
            return Collections.emptyList();
        }
        List typeComponents = Collections.emptyList();
        List<Component> nestedComponents = component.getComponentsForLifecycle();
        for (Component nested : nestedComponents) {
            if (!componentType.isInstance(nested)) continue;
            if (typeComponents.isEmpty()) {
                typeComponents = new ArrayList();
            }
            typeComponents.add(componentType.cast(nested));
        }
        return typeComponents;
    }

    public static List<Component> getAllNestedComponents(Component component) {
        if (component == null) {
            return Collections.emptyList();
        }
        List<Component> components = Collections.emptyList();
        LinkedList<Component> componentQueue = new LinkedList<Component>();
        componentQueue.offer(component);
        while (!componentQueue.isEmpty()) {
            Component currentComponent = (Component)componentQueue.poll();
            if (currentComponent == null) continue;
            if (currentComponent != component) {
                if (components.isEmpty()) {
                    components = new ArrayList<Component>();
                }
                components.add(currentComponent);
            }
            componentQueue.addAll(currentComponent.getComponentsForLifecycle());
        }
        return components;
    }

    public static Component findComponentInList(List<Component> components, String componentId) {
        for (Component component : components) {
            if (component == null || !StringUtils.equals((String)component.getId(), (String)componentId)) continue;
            return component;
        }
        return null;
    }

    public static Component findNestedComponentById(Component parent, String nestedId) {
        if (parent == null) {
            return null;
        }
        LinkedList<Component> componentQueue = new LinkedList<Component>();
        componentQueue.offer(parent);
        while (!componentQueue.isEmpty()) {
            Component child = (Component)componentQueue.poll();
            if (child == null) continue;
            if (child != parent && StringUtils.equals((String)nestedId, (String)child.getId())) {
                return child;
            }
            componentQueue.addAll(child.getComponentsForLifecycle());
        }
        return null;
    }

    public static void prefixBindingPath(List<? extends Field> fields, String addBindingPrefix) {
        for (Field field : fields) {
            if (field instanceof DataBinding) {
                ComponentUtils.prefixBindingPath((DataBinding)((Object)field), addBindingPrefix);
                continue;
            }
            if (!(field instanceof FieldGroup) || ((FieldGroup)field).getItems() == null) continue;
            List<Field> groupFields = ComponentUtils.getComponentsOfTypeDeep(((FieldGroup)field).getItems(), Field.class);
            ComponentUtils.prefixBindingPath(groupFields, addBindingPrefix);
        }
    }

    public static void prefixBindingPathNested(Component component, String addBindingPrefix) {
        if (component instanceof DataBinding) {
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)("setting nested binding prefix '" + addBindingPrefix + "' on " + component));
            }
            ComponentUtils.prefixBindingPath((DataBinding)((Object)component), addBindingPrefix);
        }
        for (Component nested : component.getComponentsForLifecycle()) {
            if (nested == null) continue;
            ComponentUtils.prefixBindingPathNested(nested, addBindingPrefix);
        }
    }

    public static void prefixBindingPath(DataBinding field, String addBindingPrefix) {
        String bindingPrefix = addBindingPrefix;
        if (StringUtils.isNotBlank((String)field.getBindingInfo().getBindByNamePrefix())) {
            bindingPrefix = bindingPrefix + "." + field.getBindingInfo().getBindByNamePrefix();
        }
        field.getBindingInfo().setBindByNamePrefix(bindingPrefix);
    }

    public static void updateIdsWithSuffixNested(List<? extends Component> components, String idSuffix) {
        for (Component component : components) {
            ComponentUtils.updateIdsWithSuffixNested(component, idSuffix);
        }
    }

    public static void updateIdsWithSuffixNested(Component component, String idSuffix) {
        ComponentUtils.updateIdWithSuffix(component, idSuffix);
        ComponentUtils.updateChildIdsWithSuffixNested(component, idSuffix);
    }

    public static void updateChildIdsWithSuffixNested(Component component, String idSuffix) {
        for (Component nested : component.getComponentsForLifecycle()) {
            if (nested == null) continue;
            ComponentUtils.updateIdsWithSuffixNested(nested, idSuffix);
        }
        List<Component> propertyReplacerComponents = component.getPropertyReplacerComponents();
        if (propertyReplacerComponents != null) {
            for (Component nested : propertyReplacerComponents) {
                if (nested == null) continue;
                ComponentUtils.updateIdsWithSuffixNested(nested, idSuffix);
            }
        }
    }

    public static void clearIds(Component component) {
        component.setId(null);
        if (Container.class.isAssignableFrom(component.getClass())) {
            LayoutManager layoutManager = ((Container)component).getLayoutManager();
            layoutManager.setId(null);
        }
        for (Component nested : component.getComponentsForLifecycle()) {
            if (nested == null) continue;
            ComponentUtils.clearIds(nested);
        }
        List<Component> propertyReplacerComponents = component.getPropertyReplacerComponents();
        if (propertyReplacerComponents != null) {
            for (Component nested : propertyReplacerComponents) {
                if (nested == null) continue;
                ComponentUtils.clearIds(nested);
            }
        }
    }

    public static void clearIds(List<? extends Component> components) {
        for (Component component : components) {
            if (component == null) continue;
            ComponentUtils.clearIds(component);
        }
    }

    public static void updateIdWithSuffix(Component component, String idSuffix) {
        LayoutManager manager;
        if (component != null && !StringUtils.isEmpty((String)idSuffix)) {
            component.setId(component.getId() + idSuffix);
        }
        if (component instanceof Container && (manager = ((Container)component).getLayoutManager()) != null) {
            manager.setId(manager.getId() + idSuffix);
        }
    }

    public static void setComponentsPropertyDeep(List<? extends Component> components, String propertyPath, Object propertyValue) {
        for (Component component : components) {
            ComponentUtils.setComponentPropertyDeep(component, propertyPath, propertyValue);
        }
    }

    public static void setComponentPropertyDeep(Component component, String propertyPath, Object propertyValue) {
        ObjectPropertyUtils.setPropertyValue(component, propertyPath, propertyValue, true);
        for (Component nested : component.getComponentsForLifecycle()) {
            if (nested == null) continue;
            ComponentUtils.setComponentPropertyDeep(nested, propertyPath, propertyValue);
        }
    }

    public static List<String> getComponentPropertyNames(Class<? extends Component> componentClass) {
        ArrayList<String> componentProperties = new ArrayList<String>();
        PropertyDescriptor[] properties = BeanUtils.getPropertyDescriptors(componentClass);
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor descriptor = properties[i];
            if (descriptor.getReadMethod() == null) continue;
            componentProperties.add(descriptor.getName());
        }
        return componentProperties;
    }

    public static void setComponentPropertyFinal(Component component, String propertyName, Object propertyValue) {
        if (component == null) {
            return;
        }
        ObjectPropertyUtils.setPropertyValue(component, propertyName, propertyValue);
        if (component.getPropertyExpressions() != null && component.getPropertyExpressions().containsKey(propertyName)) {
            component.getPropertyExpressions().remove(propertyName);
        }
    }

    public static void pushObjectToContext(List<? extends Component> components, String contextName, Object contextValue) {
        if (components == null || components.isEmpty()) {
            return;
        }
        LinkedList<? extends Component> componentQueue = new LinkedList<Component>();
        componentQueue.addAll(components);
        while (!componentQueue.isEmpty()) {
            LayoutManager layoutManager;
            Component currentComponent = (Component)componentQueue.poll();
            if (currentComponent == null) continue;
            currentComponent.pushObjectToContext(contextName, contextValue);
            if (currentComponent instanceof Container && (layoutManager = ((Container)currentComponent).getLayoutManager()) != null) {
                layoutManager.pushObjectToContext(contextName, contextValue);
            }
            componentQueue.addAll(currentComponent.getComponentsForLifecycle());
        }
    }

    public static void pushObjectToContext(Component component, String contextName, Object contextValue) {
        if (component == null) {
            return;
        }
        ComponentUtils.pushObjectToContext(Collections.singletonList(component), contextName, contextValue);
    }

    public static void pushAllToContext(List<? extends Component> components, Map<String, Object> sourceContext) {
        if (components == null || components.isEmpty()) {
            return;
        }
        LinkedList<? extends Component> componentQueue = new LinkedList<Component>();
        componentQueue.addAll(components);
        while (!componentQueue.isEmpty()) {
            LayoutManager layoutManager;
            Component currentComponent = (Component)componentQueue.poll();
            if (currentComponent == null) continue;
            currentComponent.pushAllToContext(sourceContext);
            if (currentComponent instanceof Container && (layoutManager = ((Container)currentComponent).getLayoutManager()) != null) {
                layoutManager.pushAllToContext(sourceContext);
            }
            componentQueue.addAll(currentComponent.getComponentsForLifecycle());
        }
    }

    public static void pushAllToContext(Component component, Map<String, Object> sourceContext) {
        if (component == null) {
            return;
        }
        ComponentUtils.pushAllToContext(Collections.singletonList(component), sourceContext);
    }

    public static void updateContextsForLine(List<? extends Component> components, Object collectionLine, int lineIndex, String lineSuffix) {
        for (Component component : components) {
            ComponentUtils.updateContextForLine(component, collectionLine, lineIndex, lineSuffix);
        }
    }

    public static void updateContextForLine(Component component, Object collectionLine, int lineIndex, String lineSuffix) {
        HashMap<String, Object> toUpdate = new HashMap<String, Object>(4);
        toUpdate.put("line", collectionLine);
        toUpdate.put("index", lineIndex);
        toUpdate.put("lineSuffix", lineSuffix);
        boolean isAddLine = lineIndex == -1;
        toUpdate.put("isAddLine", isAddLine);
        ComponentUtils.pushAllToContext(component, toUpdate);
    }

    public static List<? extends Ordered> sort(List<? extends Ordered> items, int defaultOrderSequence) {
        int order;
        Ordered component;
        int i;
        if (items == null) {
            return null;
        }
        ArrayList<Ordered> orderedItems = new ArrayList<Ordered>(items.size());
        HashSet<Integer> foundOrders = new HashSet<Integer>();
        for (i = items.size() - 1; i >= 0; --i) {
            component = items.get(i);
            order = component.getOrder();
            if (order == 0) {
                orderedItems.add(component);
                continue;
            }
            if (foundOrders.contains(order)) continue;
            orderedItems.add(component);
            foundOrders.add(order);
        }
        for (i = 0; i < items.size(); ++i) {
            component = items.get(i);
            order = component.getOrder();
            if (order != 0) continue;
            ++defaultOrderSequence;
            while (foundOrders.contains(defaultOrderSequence)) {
                ++defaultOrderSequence;
            }
            component.setOrder(defaultOrderSequence);
        }
        Collections.sort(orderedItems, new OrderComparator());
        return orderedItems;
    }

    public static List<InputField> getAllInputFieldsWithinContainer(Container container) {
        ArrayList<InputField> inputFields = new ArrayList<InputField>();
        for (Component c : container.getComponentsForLifecycle()) {
            if (c instanceof InputField) {
                inputFields.add((InputField)c);
                continue;
            }
            if (c instanceof Container) {
                inputFields.addAll(ComponentUtils.getAllInputFieldsWithinContainer((Container)c));
                continue;
            }
            if (!(c instanceof FieldGroup)) continue;
            Group cb = ((FieldGroup)c).getGroup();
            inputFields.addAll(ComponentUtils.getAllInputFieldsWithinContainer(cb));
        }
        return inputFields;
    }

    public static boolean containsPropertyExpression(Component component, String propertyName, boolean collectionMatch) {
        boolean hasExpression = false;
        Map<String, String> propertyExpressions = component.getPropertyExpressions();
        if (collectionMatch) {
            for (String expressionPropertyName : propertyExpressions.keySet()) {
                if (!expressionPropertyName.startsWith(propertyName)) continue;
                hasExpression = true;
            }
        } else if (propertyExpressions.containsKey(propertyName)) {
            hasExpression = true;
        }
        return hasExpression;
    }

    public static void adjustNestedLevelsForTableCollections(Container container, int currentLevel) {
        if (container != null && container instanceof CollectionGroup && container.getLayoutManager() != null && container.getLayoutManager() instanceof TableLayoutManager && ((TableLayoutManager)container.getLayoutManager()).getRichTable() != null && ((TableLayoutManager)container.getLayoutManager()).getRichTable().isRender() && ((TableLayoutManager)container.getLayoutManager()).getRichTable().isForceLocalJsonData()) {
            ((TableLayoutManager)container.getLayoutManager()).getRichTable().setNestedLevel(currentLevel);
            ++currentLevel;
        }
        if (container != null) {
            List<Container> subContainers = ComponentUtils.getNestedComponentsOfTypeShallow(container, Container.class);
            for (Container subContainer : subContainers) {
                ComponentUtils.adjustNestedLevelsForTableCollections(subContainer, currentLevel);
            }
            List<FieldGroup> subFieldGroups = ComponentUtils.getNestedComponentsOfTypeShallow(container, FieldGroup.class);
            for (FieldGroup fieldGroup : subFieldGroups) {
                if (fieldGroup == null) continue;
                ComponentUtils.adjustNestedLevelsForTableCollections(fieldGroup.getGroup(), currentLevel);
            }
        }
    }
}

