/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.service.DataObjectMetaDataService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ExpressionFunctions {
    public static boolean isAssignableFrom(Class<?> assignableClass, Class<?> objectClass) {
        return assignableClass.isAssignableFrom(objectClass);
    }

    public static boolean empty(Object value) {
        return value == null || StringUtils.isBlank((String)value.toString());
    }

    public static boolean emptyList(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static boolean listContains(List<?> list, Object[] values) {
        if (list != null && values != null && values.length > 0 && !list.isEmpty()) {
            if (list.get(0) instanceof String && !(values[0] instanceof String)) {
                String[] stringValues = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    stringValues[i] = values[i].toString();
                }
                return list.containsAll(Arrays.asList(stringValues));
            }
            if (list.get(0) instanceof Date && values[0] instanceof String) {
                return false;
            }
            if (!(list.get(0) instanceof String) && values[0] instanceof String) {
                ArrayList<String> stringList = new ArrayList<String>();
                for (String string : list) {
                    stringList.add(string.toString());
                }
                return stringList.containsAll(Arrays.asList(values));
            }
            return list.containsAll(Arrays.asList(values));
        }
        return false;
    }

    public static String getName(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        return clazz.getName();
    }

    public static String getParm(String namespaceCode, String componentCode, String parameterName) {
        return CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString(namespaceCode, componentCode, parameterName);
    }

    public static Boolean getParmInd(String namespaceCode, String componentCode, String parameterName) {
        return CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean(namespaceCode, componentCode, parameterName);
    }

    public static boolean hasPerm(String namespaceCode, String permissionName) {
        Person user = GlobalVariables.getUserSession().getPerson();
        return KimApiServiceLocator.getPermissionService().hasPermission(user.getPrincipalId(), namespaceCode, permissionName);
    }

    public static boolean hasPermDtls(String namespaceCode, String permissionName, Map<String, String> permissionDetails, Map<String, String> roleQualifiers) {
        Person user = GlobalVariables.getUserSession().getPerson();
        return KimApiServiceLocator.getPermissionService().isAuthorized(user.getPrincipalId(), namespaceCode, permissionName, roleQualifiers);
    }

    public static boolean hasPermTmpl(String namespaceCode, String templateName, Map<String, String> permissionDetails, Map<String, String> roleQualifiers) {
        Person user = GlobalVariables.getUserSession().getPerson();
        return KimApiServiceLocator.getPermissionService().isAuthorizedByTemplate(user.getPrincipalId(), namespaceCode, templateName, permissionDetails, roleQualifiers);
    }

    public static Long sequence(String sequenceName) {
        return KRADServiceLocator.getSequenceAccessorService().getNextAvailableSequenceNumber(sequenceName);
    }

    public static String getDataObjectKey(String dataObjectClassName) {
        if (StringUtils.isBlank((String)dataObjectClassName)) {
            throw new RuntimeException("getDataObjectKey SpringEL function failed because the class name was blank");
        }
        Class<?> dataObjectClass = null;
        try {
            dataObjectClass = Class.forName(dataObjectClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("getDataObjectKey SpringEL function failed when trying to find class " + dataObjectClassName, e);
        }
        DataObjectMetaDataService dataObjectMetaDataService = KRADServiceLocatorWeb.getDataObjectMetaDataService();
        List<String> pkPropertyNames = dataObjectMetaDataService.listPrimaryKeyFieldNames(dataObjectClass);
        if (pkPropertyNames != null && !pkPropertyNames.isEmpty()) {
            return pkPropertyNames.get(0);
        }
        KualiModuleService kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        ModuleService moduleService = kualiModuleService.getResponsibleModuleService(dataObjectClass);
        List<List<String>> altKeys = null;
        if (moduleService != null) {
            altKeys = moduleService.listAlternatePrimaryKeyFieldNames(dataObjectClass);
        }
        if (altKeys != null && !altKeys.isEmpty()) {
            for (List<String> list : altKeys) {
                if (list == null || list.isEmpty()) continue;
                return list.get(0);
            }
        }
        return null;
    }
}

