/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.security.GeneralSecurityException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.web.form.UifFormBase;

public class LookupInquiryUtils {
    private static final Logger LOG = Logger.getLogger(LookupInquiryUtils.class);

    public static String retrieveLookupParameterValue(UifFormBase form, HttpServletRequest request, Class<?> lookupObjectClass, String propertyName, String propertyValueName) {
        String parameterValue = "";
        if (StringUtils.startsWith((String)propertyValueName, (String)"'") && StringUtils.endsWith((String)propertyValueName, (String)"'")) {
            parameterValue = StringUtils.removeStart((String)propertyValueName, (String)"'");
            parameterValue = StringUtils.removeEnd((String)propertyValueName, (String)"'");
        } else if (parameterValue.startsWith("literal=")) {
            parameterValue = StringUtils.removeStart((String)parameterValue, (String)"literal=");
        } else if (request.getParameterMap().containsKey(propertyValueName)) {
            parameterValue = request.getParameter(propertyValueName);
        } else {
            Object value = ObjectPropertyUtils.getPropertyValue(form, propertyValueName);
            if (value != null) {
                if (value instanceof String) {
                    parameterValue = (String)value;
                }
                Formatter formatter = Formatter.getFormatter(value.getClass());
                parameterValue = (String)formatter.format(value);
            }
        }
        if (parameterValue != null && lookupObjectClass != null && KRADServiceLocatorWeb.getDataObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(lookupObjectClass, propertyName)) {
            try {
                if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                    parameterValue = CoreApiServiceLocator.getEncryptionService().encrypt((Object)parameterValue) + "(&^#&)";
                }
            }
            catch (GeneralSecurityException e) {
                LOG.error((Object)("Unable to encrypt value for property name: " + propertyName));
                throw new RuntimeException(e);
            }
        }
        return parameterValue;
    }

    public static String getBaseLookupUrl() {
        return CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("krad.lookup.url");
    }

    public static String getLinkTitleText(String prependText, Class<?> element, Map<String, String> keyValueMap) {
        StringBuffer titleText = new StringBuffer(prependText);
        for (String key : keyValueMap.keySet()) {
            String fieldVal = keyValueMap.get(key).toString();
            titleText.append(" " + KRADServiceLocatorWeb.getDataDictionaryService().getAttributeLabel(element, key) + "=" + fieldVal.toString());
        }
        return titleText.toString();
    }
}

