/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.beans.PropertyDescriptor;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.datadictionary.parse.StringListConverter;
import org.kuali.rice.krad.datadictionary.parse.StringMapConverter;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;

public class ObjectPropertyUtils {
    private static final Logger LOG = Logger.getLogger(ObjectPropertyUtils.class);

    public static void copyPropertiesToObject(Map<String, String> properties, Object object) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            ObjectPropertyUtils.setPropertyValue(object, property.getKey(), property.getValue());
        }
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Object object) {
        return ObjectPropertyUtils.wrapObject(object).getPropertyDescriptors();
    }

    public static Class<?> getPropertyType(Class<?> object, String propertyPath) {
        return new BeanWrapperImpl(object).getPropertyType(propertyPath);
    }

    public static Class<?> getPropertyType(Object object, String propertyPath) {
        return ObjectPropertyUtils.wrapObject(object).getPropertyType(propertyPath);
    }

    public static <T> T getPropertyValue(Object object, String propertyPath) {
        Object result = null;
        try {
            result = ObjectPropertyUtils.wrapObject(object).getPropertyValue(propertyPath);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error getting property '" + propertyPath + "' from " + object, e);
        }
        return (T)result;
    }

    public static void initializeProperty(Object object, String propertyPath) {
        Class<?> propertyType = ObjectPropertyUtils.getPropertyType(object, propertyPath);
        try {
            ObjectPropertyUtils.setPropertyValue(object, propertyPath, propertyType.newInstance());
        }
        catch (InstantiationException e) {
            ObjectPropertyUtils.setPropertyValue(object, propertyPath, null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to set new instance for property: " + propertyPath, e);
        }
    }

    public static void setPropertyValue(Object object, String propertyPath, Object propertyValue) {
        ObjectPropertyUtils.wrapObject(object).setPropertyValue(propertyPath, propertyValue);
    }

    public static void setPropertyValue(Object object, String propertyPath, Object propertyValue, boolean ignoreUnknown) {
        block3: {
            try {
                ObjectPropertyUtils.wrapObject(object).setPropertyValue(propertyPath, propertyValue);
            }
            catch (BeansException e) {
                if (!ignoreUnknown) {
                    throw new RuntimeException(e);
                }
                if (!LOG.isTraceEnabled()) break block3;
                LOG.trace((Object)("Ignoring exception thrown during setting of property '" + propertyPath + "': " + e.getLocalizedMessage()));
            }
        }
    }

    public static boolean isReadableProperty(Object object, String propertyPath) {
        return ObjectPropertyUtils.wrapObject(object).isReadableProperty(propertyPath);
    }

    public static boolean isWritableProperty(Object object, String propertyPath) {
        return ObjectPropertyUtils.wrapObject(object).isWritableProperty(propertyPath);
    }

    public static BeanWrapper wrapObject(Object object) {
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(object);
        beanWrapper.setAutoGrowNestedPaths(true);
        GenericConversionService conversionService = new GenericConversionService();
        conversionService.addConverter((GenericConverter)new StringMapConverter());
        conversionService.addConverter((GenericConverter)new StringListConverter());
        beanWrapper.setConversionService((ConversionService)conversionService);
        return beanWrapper;
    }
}

