/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.util.BreadcrumbItem;
import org.kuali.rice.krad.uif.util.BreadcrumbOptions;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.web.form.UifFormBase;

@BeanTag(name="pageBreadcrumbOptions-bean", parent="Uif-PageBreadcrumbOptions")
public class PageBreadcrumbOptions
extends BreadcrumbOptions {
    private static final long serialVersionUID = -5666730356781875858L;
    private boolean renderViewBreadcrumb;
    private boolean renderHomewardPathBreadcrumbs;
    private boolean renderPreViewBreadcrumbs;
    private boolean renderPrePageBreadcrumbs;
    private boolean renderParentLocations;

    @Override
    public void setupBreadcrumbs(View view, Object model) {
        BreadcrumbOptions viewBreadcrumbOptions = view.getBreadcrumbOptions();
        if (this.getHomewardPathBreadcrumbs() == null && viewBreadcrumbOptions != null && viewBreadcrumbOptions.getHomewardPathBreadcrumbs() != null) {
            this.setHomewardPathBreadcrumbs(viewBreadcrumbOptions.getHomewardPathBreadcrumbs());
            for (BreadcrumbItem item : this.getHomewardPathBreadcrumbs()) {
                view.assignComponentIds(item);
            }
        }
        if (this.getPrePageBreadcrumbs() == null && viewBreadcrumbOptions != null && viewBreadcrumbOptions.getPrePageBreadcrumbs() != null) {
            this.setPrePageBreadcrumbs(viewBreadcrumbOptions.getPrePageBreadcrumbs());
            for (BreadcrumbItem item : this.getPrePageBreadcrumbs()) {
                view.assignComponentIds(item);
            }
        }
        if (this.getPreViewBreadcrumbs() == null && viewBreadcrumbOptions != null && viewBreadcrumbOptions.getPreViewBreadcrumbs() != null) {
            this.setPreViewBreadcrumbs(viewBreadcrumbOptions.getPreViewBreadcrumbs());
            for (BreadcrumbItem item : this.getPreViewBreadcrumbs()) {
                view.assignComponentIds(item);
            }
        }
        if (this.getBreadcrumbOverrides() == null && viewBreadcrumbOptions != null && viewBreadcrumbOptions.getBreadcrumbOverrides() != null) {
            this.setBreadcrumbOverrides(viewBreadcrumbOptions.getBreadcrumbOverrides());
            for (BreadcrumbItem item : this.getBreadcrumbOverrides()) {
                view.assignComponentIds(item);
            }
        }
    }

    @Override
    public void finalizeBreadcrumbs(View view, Object model, Container parent, BreadcrumbItem breadcrumbItem) {
        if (StringUtils.isBlank((String)breadcrumbItem.getLabel()) && parent.getHeader() != null && StringUtils.isNotBlank((String)parent.getHeader().getHeaderText())) {
            breadcrumbItem.setLabel(parent.getHeader().getHeaderText());
        }
        if (StringUtils.isBlank((String)breadcrumbItem.getLabel())) {
            breadcrumbItem.setRender(false);
        }
        if (breadcrumbItem.getUrl().getControllerMapping() == null && breadcrumbItem.getUrl().getViewId() == null && model instanceof UifFormBase && breadcrumbItem.getUrl().getRequestParameters() == null && ((UifFormBase)model).getInitialRequestParameters() != null) {
            Map<String, String> requestParameters = ((UifFormBase)model).getInitialRequestParameters();
            requestParameters.remove("ajaxReturnType");
            requestParameters.remove("ajaxRequest");
            requestParameters.remove("pageId");
            breadcrumbItem.getUrl().setRequestParameters(requestParameters);
        }
        if (breadcrumbItem.getUrl().getFormKey() == null && model instanceof UifFormBase && ((UifFormBase)model).getFormKey() != null) {
            breadcrumbItem.getUrl().setFormKey(((UifFormBase)model).getFormKey());
        }
        if (breadcrumbItem.getUrl().getControllerMapping() == null && model instanceof UifFormBase) {
            breadcrumbItem.getUrl().setControllerMapping(((UifFormBase)model).getControllerMapping());
        }
        if (breadcrumbItem.getUrl().getViewId() == null) {
            breadcrumbItem.getUrl().setViewId(view.getId());
        }
        if (breadcrumbItem.getUrl().getPageId() == null) {
            breadcrumbItem.getUrl().setPageId(parent.getId());
        }
    }

    @BeanTagAttribute(name="renderViewBreadcrumb")
    public boolean isRenderViewBreadcrumb() {
        return this.renderViewBreadcrumb;
    }

    public void setRenderViewBreadcrumb(boolean renderViewBreadcrumb) {
        this.renderViewBreadcrumb = renderViewBreadcrumb;
    }

    @BeanTagAttribute(name="renderHomewardPathBreadcrumbs")
    public boolean isRenderHomewardPathBreadcrumbs() {
        return this.renderHomewardPathBreadcrumbs;
    }

    public void setRenderHomewardPathBreadcrumbs(boolean renderHomewardPathBreadcrumbs) {
        this.renderHomewardPathBreadcrumbs = renderHomewardPathBreadcrumbs;
    }

    @BeanTagAttribute(name="renderPreViewBreadcrumbs")
    public boolean isRenderPreViewBreadcrumbs() {
        return this.renderPreViewBreadcrumbs;
    }

    public void setRenderPreViewBreadcrumbs(boolean renderPreViewBreadcrumbs) {
        this.renderPreViewBreadcrumbs = renderPreViewBreadcrumbs;
    }

    @BeanTagAttribute(name="renderPrePageBreadcrumbs")
    public boolean isRenderPrePageBreadcrumbs() {
        return this.renderPrePageBreadcrumbs;
    }

    public void setRenderPrePageBreadcrumbs(boolean renderPrePageBreadcrumbs) {
        this.renderPrePageBreadcrumbs = renderPrePageBreadcrumbs;
    }

    @BeanTagAttribute(name="renderParentLocations")
    public boolean isRenderParentLocations() {
        return this.renderParentLocations;
    }

    public void setRenderParentLocations(boolean renderParentLocations) {
        this.renderParentLocations = renderParentLocations;
    }

    @Override
    protected <T> void copyProperties(T breadcrumbOptions) {
        super.copyProperties(breadcrumbOptions);
        PageBreadcrumbOptions breadcrumbOptionsCopy = (PageBreadcrumbOptions)breadcrumbOptions;
        breadcrumbOptionsCopy.setRenderViewBreadcrumb(this.renderViewBreadcrumb);
        breadcrumbOptionsCopy.setRenderHomewardPathBreadcrumbs(this.renderHomewardPathBreadcrumbs);
        breadcrumbOptionsCopy.setRenderPreViewBreadcrumbs(this.renderPreViewBreadcrumbs);
        breadcrumbOptionsCopy.setRenderPrePageBreadcrumbs(this.renderPrePageBreadcrumbs);
        breadcrumbOptionsCopy.setRenderParentLocations(this.renderParentLocations);
    }
}

