/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class ProcessLogger {
    private static final Logger LOG = Logger.getLogger(ProcessLogger.class);
    private static final ThreadLocal<Map<String, ProcessStatus>> TL_STAT = new ThreadLocal();
    private static final String[] SIZE_INTERVALS = new String[]{"k", "M", "G", "T", "E"};

    public static String intervalToString(long millis) {
        long days;
        DecimalFormat df = new DecimalFormat("000");
        StringBuilder sb = new StringBuilder();
        sb.append('.');
        sb.append(df.format(millis % 1000L));
        df.applyPattern("00");
        long sec = millis / 1000L;
        sb.insert(0, df.format(sec % 60L));
        long min = sec / 60L;
        sb.insert(0, ':');
        sb.insert(0, df.format(min % 60L));
        long hours = min / 60L;
        if (hours > 0L) {
            sb.insert(0, ':');
            sb.insert(0, df.format(hours % 24L));
        }
        if ((days = hours / 24L) > 0L) {
            sb.insert(0, " days, ");
            sb.insert(0, days);
        }
        return sb.toString();
    }

    public static String sizeToString(long bytes) {
        DecimalFormat df = new DecimalFormat("000");
        StringBuilder sb = new StringBuilder();
        int i = -1;
        int mod = 0;
        if (bytes < 0L) {
            sb.append('-');
            bytes = Math.abs(bytes);
        }
        while (bytes / 1024L > 0L && i < SIZE_INTERVALS.length) {
            ++i;
            mod = (int)(bytes % 1024L);
            bytes /= 1024L;
        }
        sb.append(bytes);
        if (mod > 0) {
            sb.append('.');
            sb.append(df.format(mod * 1000 / 1024));
        }
        if (i >= 0) {
            sb.append(SIZE_INTERVALS[i]);
        }
        return sb.toString();
    }

    public static String memoryToString(long free, long tot, long max) {
        StringBuilder sb = new StringBuilder();
        sb.append(ProcessLogger.sizeToString(free));
        sb.append('/');
        sb.append(ProcessLogger.sizeToString(tot));
        sb.append('/');
        sb.append(ProcessLogger.sizeToString(max));
        sb.append(" - ");
        sb.append(free * 100L / tot);
        sb.append("% free");
        return sb.toString();
    }

    public static <T> T safeFollow(String name, String processDescription, Callable<T> callableProcess) {
        try {
            return ProcessLogger.follow(name, processDescription, null, callableProcess);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException("Error in followed process " + name + " - " + processDescription, e);
        }
    }

    public static <T> T safeFollow(String name, String processDescription, Boolean verbose, Callable<T> callableProcess) {
        try {
            return ProcessLogger.follow(name, processDescription, verbose, callableProcess);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException("Error in followed process " + name + " - " + processDescription, e);
        }
    }

    public static <T> T follow(String name, String processDescription, Callable<T> callableProcess) throws Exception {
        return ProcessLogger.follow(name, processDescription, null, callableProcess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T follow(String name, String processDescription, Boolean verbose, Callable<T> callableProcess) throws Exception {
        if (!LOG.isInfoEnabled()) {
            return callableProcess.call();
        }
        assert (TL_STAT.get() == null || TL_STAT.get().get(name) == null);
        if (TL_STAT.get() == null) {
            TL_STAT.set(new HashMap());
        }
        ProcessStatus processStatus = new ProcessStatus();
        if (verbose != null) {
            processStatus.verbose = verbose;
        }
        try {
            int i;
            TL_STAT.get().put(name, processStatus);
            processStatus.traceBuffer.append("KRAD Process Trace (");
            processStatus.traceBuffer.append(name);
            processStatus.traceBuffer.append("): ");
            processStatus.traceBuffer.append(processDescription);
            StackTraceElement[] st = Thread.currentThread().getStackTrace();
            String cn = st[2].getClassName();
            int iod = cn.lastIndexOf(46);
            String pn = "";
            if (iod != -1) {
                pn = cn.substring(0, iod);
            }
            for (i = 2; i < st.length - 1 && (st[i].getClassName().startsWith("sun.") || st[i].getClassName().startsWith("java.") || st[i].getClassName().startsWith(ProcessLogger.class.getPackage().getName()) || st[i].getClassName().startsWith(pn)); ++i) {
                if (ProcessLogger.class.getName().equals(st[i].getClassName())) continue;
                processStatus.traceBuffer.append("\n  at ").append(st[i]);
            }
            processStatus.traceBuffer.append("\n  at ").append(st[i]);
            processStatus.traceBuffer.append("\nInitial Memory Usage: ");
            processStatus.traceBuffer.append(ProcessLogger.memoryToString(processStatus.startFree, processStatus.startTot, processStatus.startMax));
            if (LOG.isInfoEnabled() && processStatus.verbose) {
                LOG.debug((Object)("Processing Started\n" + processStatus.traceBuffer.toString()));
            }
            T t = callableProcess.call();
            return t;
        }
        finally {
            if (TL_STAT.get() != null) {
                TL_STAT.get().remove(name);
                if (TL_STAT.get().isEmpty()) {
                    TL_STAT.remove();
                }
            }
            processStatus.elapse();
            processStatus.traceBuffer.append('\n');
            String message = "Processing Complete";
            processStatus.traceBuffer.append(message);
            for (int i = message.length(); i < 40; ++i) {
                processStatus.traceBuffer.append('.');
            }
            processStatus.traceBuffer.append(ProcessLogger.intervalToString(processStatus.diffTime));
            processStatus.traceBuffer.append(' ');
            processStatus.traceBuffer.append(ProcessLogger.intervalToString(processStatus.lastTime - processStatus.startTime));
            processStatus.traceBuffer.append(' ');
            processStatus.traceBuffer.append(ProcessLogger.sizeToString(processStatus.lastFree));
            processStatus.traceBuffer.append(' ');
            processStatus.traceBuffer.append(ProcessLogger.sizeToString(processStatus.diffFree));
            if (!processStatus.ntraceCount.isEmpty()) {
                processStatus.traceBuffer.append("\nMonitors:");
                for (Map.Entry ce : processStatus.ntraceCount.entrySet()) {
                    processStatus.traceBuffer.append("\n  ");
                    StringBuilder sb = new StringBuilder((String)ce.getKey());
                    int iocc = sb.indexOf("::");
                    if (iocc == -1) {
                        sb.append(":" + ce.getValue());
                    } else {
                        sb.insert(iocc + 1, ce.getValue());
                    }
                    processStatus.traceBuffer.append((CharSequence)sb);
                }
            }
            if (!processStatus.counters.isEmpty()) {
                processStatus.traceBuffer.append("\nCounters:");
                for (ProcessCounter pc : processStatus.counters.values()) {
                    processStatus.traceBuffer.append("\n  ");
                    processStatus.traceBuffer.append(pc.name);
                    processStatus.traceBuffer.append(": ");
                    processStatus.traceBuffer.append(pc.count);
                    processStatus.traceBuffer.append(" (");
                    processStatus.traceBuffer.append(ProcessLogger.intervalToString(pc.min));
                    processStatus.traceBuffer.append("/");
                    processStatus.traceBuffer.append(ProcessLogger.intervalToString(pc.max));
                    processStatus.traceBuffer.append("/");
                    processStatus.traceBuffer.append(ProcessLogger.intervalToString(pc.avg));
                    processStatus.traceBuffer.append(")");
                    if (pc.longest == null || "".equals(pc.longest)) continue;
                    processStatus.traceBuffer.append("\n    longest : ");
                    processStatus.traceBuffer.append(pc.longest);
                }
            }
            processStatus.traceBuffer.append("\nElapsed Time: ");
            processStatus.traceBuffer.append(ProcessLogger.intervalToString(processStatus.lastTime - processStatus.startTime));
            processStatus.traceBuffer.append("\nMemory Usage: ");
            processStatus.traceBuffer.append(ProcessLogger.memoryToString(processStatus.lastFree, processStatus.lastTot, processStatus.lastMax));
            processStatus.traceBuffer.append("\nMemory Delta: ");
            processStatus.traceBuffer.append(ProcessLogger.memoryToString(processStatus.lastFree - processStatus.startFree, processStatus.lastTot, processStatus.lastMax));
            processStatus.traceBuffer.append(" - tot delta: ");
            processStatus.traceBuffer.append(ProcessLogger.sizeToString(processStatus.lastTot - processStatus.startTot));
            String rpt = processStatus.traceBuffer.toString();
            LOG.info((Object)rpt);
        }
    }

    public static boolean isTraceActive() {
        return TL_STAT.get() != null && !TL_STAT.get().isEmpty();
    }

    public static boolean isTraceActive(String name) {
        return TL_STAT.get() != null && TL_STAT.get().containsKey(name);
    }

    public static boolean isVerbose(String name) {
        ProcessStatus processStatus = TL_STAT.get() == null ? null : TL_STAT.get().get(name);
        return processStatus != null && processStatus.verbose;
    }

    public static void setVerbose(String name, boolean verbose) {
        ProcessStatus ps;
        ProcessStatus processStatus = ps = TL_STAT.get() == null ? null : TL_STAT.get().get(name);
        if (ps != null) {
            ps.verbose = verbose;
        }
    }

    public static void trace(String message) {
        if (TL_STAT.get() != null) {
            for (String k : TL_STAT.get().keySet()) {
                ProcessLogger.trace(k, message);
            }
        }
    }

    public static void trace(String name, String message) {
        ProcessStatus processStatus;
        ProcessStatus processStatus2 = processStatus = TL_STAT.get() == null ? null : TL_STAT.get().get(name);
        if (processStatus != null) {
            processStatus.elapse();
            if (LOG.isDebugEnabled() && processStatus.verbose) {
                LOG.debug((Object)(message + " (" + name + ")\nElapsed Time: " + ProcessLogger.intervalToString(processStatus.diffTime) + "\nMemory Usage: " + ProcessLogger.memoryToString(processStatus.lastFree, processStatus.lastTot, processStatus.lastMax) + "\nMemory Delta: " + ProcessLogger.memoryToString(processStatus.diffFree, processStatus.lastTot, processStatus.lastMax) + " - tot delta: " + ProcessLogger.sizeToString(processStatus.diffTot)));
            }
            if (LOG.isInfoEnabled() && (processStatus.verbose || processStatus.diffTime > 0L)) {
                processStatus.traceBuffer.append('\n');
                if (message.length() < 40) {
                    processStatus.traceBuffer.append(message);
                    for (int i = message.length(); i < 40; ++i) {
                        processStatus.traceBuffer.append('.');
                    }
                } else {
                    processStatus.traceBuffer.append(message.substring(0, 40));
                }
                processStatus.traceBuffer.append(ProcessLogger.intervalToString(processStatus.diffTime));
                processStatus.traceBuffer.append(' ');
                processStatus.traceBuffer.append(ProcessLogger.intervalToString(processStatus.lastTime - processStatus.startTime));
                processStatus.traceBuffer.append(' ');
                processStatus.traceBuffer.append(ProcessLogger.sizeToString(processStatus.lastFree));
                processStatus.traceBuffer.append(' ');
                processStatus.traceBuffer.append(ProcessLogger.sizeToString(processStatus.diffFree));
            }
        }
    }

    public static long ntrace(String prefix, String suffix, long interval) {
        long rv = 0L;
        if (TL_STAT.get() != null) {
            for (String k : TL_STAT.get().keySet()) {
                rv = Math.max(rv, ProcessLogger.ntrace(k, prefix, suffix, interval));
            }
        }
        return rv;
    }

    public static long ntrace(String name, String prefix, String suffix, long interval) {
        ProcessStatus processStatus = TL_STAT.get() == null ? null : TL_STAT.get().get(name);
        String nTraceCountKey = prefix + suffix;
        Long nTraceCount = (Long)processStatus.ntraceCount.get(nTraceCountKey);
        if (nTraceCount == null) {
            nTraceCount = 0L;
        }
        nTraceCount = nTraceCount + 1L;
        processStatus.ntraceCount.put(nTraceCountKey, nTraceCount);
        if (nTraceCount % interval == 0L) {
            ProcessLogger.trace(prefix + nTraceCount + suffix);
        }
        return nTraceCount;
    }

    public static void countBegin(String name) {
        if (TL_STAT.get() != null) {
            for (String k : TL_STAT.get().keySet()) {
                ProcessLogger.countBegin(k, name);
            }
        }
    }

    public static void countBegin(String traceName, String name) {
        ProcessStatus ps;
        ProcessStatus processStatus = ps = TL_STAT.get() == null ? null : TL_STAT.get().get(traceName);
        if (ps != null) {
            ps.countBegin(name);
        }
    }

    public static void countEnd(String name, String detail) {
        if (TL_STAT.get() != null) {
            for (String k : TL_STAT.get().keySet()) {
                ProcessLogger.countEnd(k, name, detail);
            }
        }
    }

    public static void countEnd(String traceName, String name, String detail) {
        ProcessStatus processStatus;
        ProcessStatus processStatus2 = processStatus = TL_STAT.get() == null ? null : TL_STAT.get().get(traceName);
        if (processStatus != null) {
            processStatus.countEnd(name, detail);
        }
    }

    public static void addExtra(String traceName, Object message) {
        ProcessStatus processStatus;
        ProcessStatus processStatus2 = processStatus = TL_STAT.get() == null ? null : TL_STAT.get().get(traceName);
        if (processStatus == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Information Message Reported at ");
        sb.append(new Date());
        sb.append(":\n");
        sb.append(message);
        LOG.info((Object)sb.toString());
        processStatus.extra.append((CharSequence)sb);
        processStatus.extra.append("\n\n");
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    private static class ProcessStatus {
        private final long startTime;
        private final long startFree;
        private final long startTot;
        private final long startMax;
        private long lastTime;
        private long lastFree;
        private long lastTot;
        private long lastMax;
        private long diffTime;
        private long diffFree;
        private long diffTot;
        private Map<String, ProcessCounter> counters = new LinkedHashMap<String, ProcessCounter>();
        private Map<String, Long> ntraceCount = new TreeMap<String, Long>();
        private boolean verbose = ProcessLogger.access$000().isDebugEnabled();
        private StringBuilder traceBuffer = new StringBuilder();
        private StringBuilder extra = new StringBuilder();

        private ProcessStatus() {
            this.startTime = System.currentTimeMillis();
            this.startFree = Runtime.getRuntime().freeMemory();
            this.startTot = Runtime.getRuntime().totalMemory();
            this.startMax = Runtime.getRuntime().maxMemory();
            this.lastTime = this.startTime;
            this.lastFree = this.startFree;
            this.lastTot = this.startTot;
            this.lastMax = this.startMax;
        }

        private void elapse() {
            long nTime = System.currentTimeMillis();
            long nFree = Runtime.getRuntime().freeMemory();
            long nTot = Runtime.getRuntime().totalMemory();
            long nMax = Runtime.getRuntime().maxMemory();
            this.diffTime = nTime - this.lastTime;
            this.diffFree = nFree - this.lastFree;
            this.diffTot = nTot - this.lastTot;
            this.lastTime = nTime;
            this.lastFree = nFree;
            this.lastTot = nTot;
            this.lastMax = nMax;
        }

        private void countBegin(String name) {
            ProcessCounter pc = this.counters.get(name);
            if (pc == null) {
                pc = new ProcessCounter(name);
                this.counters.put(name, pc);
            }
            pc.start.push(new Long(System.currentTimeMillis()));
        }

        private ProcessCounter countEnd(String name, String detail) {
            ProcessCounter pc = this.counters.get(name);
            if (pc == null || pc.start.isEmpty()) {
                return null;
            }
            long start = (Long)pc.start.pop();
            long elapsed = System.currentTimeMillis() - start;
            if (elapsed < pc.min || pc.count == 0L) {
                pc.min = elapsed;
            }
            if (elapsed > pc.max) {
                pc.max = elapsed;
                pc.longest = detail;
            }
            pc.count++;
            pc.avg = (pc.avg * (pc.count - 1L) + elapsed) / pc.count;
            return pc;
        }
    }

    private static class ProcessCounter {
        private final String name;
        private Deque<Long> start = new LinkedList<Long>();
        private long count;
        private long min;
        private long max;
        private long avg;
        private String longest;

        private ProcessCounter(String name) {
            this.name = name;
        }
    }
}

