/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBeanBase;
import org.kuali.rice.krad.util.KRADUtils;

@BeanTag(name="url-bean", parent="Uif-Url")
public class UrlInfo
extends UifDictionaryBeanBase
implements Serializable {
    private static final long serialVersionUID = 3195177614468120958L;
    private String href;
    private String originalHref;
    private String baseUrl;
    private String controllerMapping;
    private String viewType;
    private String viewId;
    private String pageId;
    private String formKey;
    private String methodToCall;
    private Map<String, String> requestParameters;

    public UrlInfo() {
    }

    public UrlInfo(String href) {
        this.href = href;
        this.originalHref = href;
    }

    public UrlInfo(String baseUrl, String controllerMapping, String viewId, String methodToCall) {
        this.baseUrl = baseUrl;
        this.controllerMapping = controllerMapping;
        this.viewId = viewId;
        this.methodToCall = methodToCall;
    }

    protected String generateUrl() {
        String generatedUrl = "";
        if (StringUtils.isBlank((String)this.baseUrl)) {
            return generatedUrl;
        }
        generatedUrl = this.baseUrl;
        if (StringUtils.isNotBlank((String)this.controllerMapping) && !this.controllerMapping.startsWith("/")) {
            generatedUrl = generatedUrl + "/" + this.controllerMapping;
        } else if (StringUtils.isNotBlank((String)this.controllerMapping)) {
            generatedUrl = generatedUrl + this.controllerMapping;
        }
        HashMap<String, String> allRequestParameters = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)this.methodToCall)) {
            allRequestParameters.put("methodToCall", this.methodToCall);
        }
        if (StringUtils.isNotBlank((String)this.viewId)) {
            allRequestParameters.put("viewId", this.viewId);
        }
        if (StringUtils.isNotBlank((String)this.pageId)) {
            allRequestParameters.put("pageId", this.pageId);
        }
        if (StringUtils.isNotBlank((String)this.formKey)) {
            allRequestParameters.put("formKey", this.formKey);
        }
        if (this.requestParameters != null) {
            allRequestParameters.putAll(this.requestParameters);
        }
        generatedUrl = generatedUrl + KRADUtils.getRequestStringFromMap(allRequestParameters);
        return generatedUrl;
    }

    @BeanTagAttribute(name="href")
    public String getHref() {
        if (StringUtils.isBlank((String)this.href)) {
            this.href = this.generateUrl();
        }
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
        this.originalHref = href;
    }

    @BeanTagAttribute(name="baseUrl")
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @BeanTagAttribute(name="controllerMapping")
    public String getControllerMapping() {
        return this.controllerMapping;
    }

    public void setControllerMapping(String controllerMapping) {
        this.controllerMapping = controllerMapping;
    }

    @BeanTagAttribute(name="viewType")
    public String getViewType() {
        return this.viewType;
    }

    public void setViewType(String viewType) {
        this.viewType = viewType;
    }

    @BeanTagAttribute(name="viewId")
    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    @BeanTagAttribute(name="pageId")
    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    @BeanTagAttribute(name="formKey")
    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    @BeanTagAttribute(name="methodToCall")
    public String getMethodToCall() {
        return this.methodToCall;
    }

    public void setMethodToCall(String methodToCall) {
        this.methodToCall = methodToCall;
    }

    @BeanTagAttribute(name="requestParameters", type=BeanTagAttribute.AttributeType.MAPVALUE)
    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public void setRequestParameters(Map<String, String> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public String getOriginalHref() {
        return this.originalHref;
    }

    public String toString() {
        return this.getHref();
    }

    public void setOriginalHref(String originalHref) {
        this.originalHref = originalHref;
    }

    @Override
    protected <T> void copyProperties(T dictionaryBaseBean) {
        super.copyProperties(dictionaryBaseBean);
        UrlInfo urlInfoCopy = (UrlInfo)dictionaryBaseBean;
        urlInfoCopy.setHref(this.href);
        urlInfoCopy.setOriginalHref(this.originalHref);
        urlInfoCopy.setBaseUrl(this.baseUrl);
        urlInfoCopy.setControllerMapping(this.controllerMapping);
        urlInfoCopy.setViewType(this.viewType);
        urlInfoCopy.setViewId(this.viewId);
        urlInfoCopy.setPageId(this.pageId);
        urlInfoCopy.setFormKey(this.formKey);
        urlInfoCopy.setMethodToCall(this.methodToCall);
        if (this.requestParameters != null) {
            HashMap requestParametersCopy = Maps.newHashMapWithExpectedSize((int)this.requestParameters.size());
            for (Map.Entry<String, String> requestParameter : this.requestParameters.entrySet()) {
                requestParametersCopy.put(requestParameter.getKey().toString(), requestParameter.getValue().toString());
            }
            urlInfoCopy.setRequestParameters(requestParametersCopy);
        }
    }
}

