/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DialogManager
implements Serializable {
    private static final long serialVersionUID = 4627667603510159528L;
    private static final String TRUE_VALUES = "/true/yes/y/on/1/";
    private static final String FALSE_VALUES = "/false/no/n/off/0/";
    private String currentDialogId;
    private Map<String, DialogInfo> dialogs = new HashMap<String, DialogInfo>();

    public boolean hasDialogBeenDisplayed(String dialogId) {
        if (this.dialogs.containsKey(dialogId)) {
            return this.dialogs.get(dialogId).asked;
        }
        return false;
    }

    public boolean hasDialogBeenAnswered(String dialogId) {
        if (this.dialogs.containsKey(dialogId)) {
            return this.dialogs.get(dialogId).answered;
        }
        return false;
    }

    public String getDialogAnswer(String dialogId) {
        if (this.hasDialogBeenAnswered(dialogId)) {
            return this.dialogs.get(dialogId).answer;
        }
        return null;
    }

    public void setDialogAnswer(String dialogId, String answer) {
        DialogInfo dialogInfo = this.dialogs.get(dialogId);
        if (dialogInfo != null) {
            dialogInfo.answer = answer;
            dialogInfo.answered = true;
            this.dialogs.put(dialogId, dialogInfo);
        }
    }

    public String getDialogExplanation(String dialogId) {
        return this.dialogs.get(dialogId).explanation;
    }

    public void setDialogExplanation(String dialogId, String explanation) {
        DialogInfo dialogInfo = this.dialogs.get(dialogId);
        if (dialogInfo != null) {
            dialogInfo.explanation = explanation;
            this.dialogs.put(dialogId, dialogInfo);
        }
    }

    public boolean wasDialogAnswerAffirmative(String dialogId) {
        String answer = this.getDialogAnswer(dialogId);
        if (answer != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("/").append(answer.toLowerCase()).append("/");
            String input = builder.toString();
            if (TRUE_VALUES.contains(builder.toString())) {
                return true;
            }
        }
        return false;
    }

    public String getDialogReturnMethod(String dialogId) {
        if (this.hasDialogBeenAnswered(dialogId)) {
            return this.dialogs.get(dialogId).returnMethod;
        }
        return null;
    }

    public void setDialogReturnMethod(String dialogId, String returnMethod) {
        DialogInfo dialogInfo = this.dialogs.get(dialogId);
        dialogInfo.returnMethod = returnMethod;
        this.dialogs.put(dialogId, dialogInfo);
    }

    public void addDialog(String dialogId, String returnMethod) {
        DialogInfo dialogInfo = new DialogInfo(dialogId, returnMethod);
        dialogInfo.asked = true;
        this.dialogs.put(dialogId, dialogInfo);
        this.setCurrentDialogId(dialogId);
    }

    public void removeDialog(String dialogId) {
        if (this.dialogs.containsKey(dialogId)) {
            this.dialogs.remove(dialogId);
        }
    }

    public void removeAllDialogs() {
        this.dialogs.clear();
    }

    public void resetDialogStatus(String dialogId) {
        String returnMethod = this.getDialogReturnMethod(dialogId);
        this.dialogs.put(dialogId, new DialogInfo(dialogId, returnMethod));
    }

    public Map<String, DialogInfo> getDialogs() {
        return this.dialogs;
    }

    public void setDialogs(Map<String, DialogInfo> dialogs) {
        this.dialogs = dialogs;
    }

    public String getCurrentDialogId() {
        return this.currentDialogId;
    }

    public void setCurrentDialogId(String currentDialogId) {
        this.currentDialogId = currentDialogId;
    }

    private static class DialogInfo
    implements Serializable {
        private static final long serialVersionUID = 2779403853894669510L;
        private String dialogId;
        private boolean asked;
        private boolean answered;
        private String answer;
        private String explanation;
        private String returnMethod;

        public DialogInfo(String dialogId, String returnMethod) {
            this.dialogId = dialogId;
            this.asked = false;
            this.answered = false;
            this.answer = null;
            this.explanation = null;
            this.returnMethod = returnMethod;
        }
    }
}

