/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.RequestParameter;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.TextAreaControl;
import org.kuali.rice.krad.uif.control.TextControl;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.field.LookupInputField;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.FormView;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.web.form.LookupForm;

@BeanTag(name="lookupView-bean", parent="Uif-LookupView")
public class LookupView
extends FormView {
    private static final long serialVersionUID = 716926008488403616L;
    private Class<?> dataObjectClassName;
    private Group criteriaGroup;
    private CollectionGroup resultsGroup;
    private List<Component> criteriaFields;
    private List<Component> resultFields;
    private List<String> defaultSortAttributeNames;
    protected boolean defaultSortAscending = true;
    @RequestParameter
    private boolean hideReturnLinks = false;
    @RequestParameter
    private boolean suppressActions = false;
    @RequestParameter
    private boolean showMaintenanceLinks = false;
    @RequestParameter
    private boolean multipleValuesSelect = false;
    @RequestParameter
    private boolean renderLookupCriteria = true;
    @RequestParameter
    private boolean renderSearchButtons = true;
    @RequestParameter
    private boolean renderHeader = true;
    @RequestParameter
    private String returnTarget;
    @RequestParameter
    private boolean returnByScript;
    private boolean triggerOnChange;
    private Integer resultSetLimit = null;
    private Integer multipleValuesSelectResultSetLimit = null;
    private String maintenanceUrlMapping;
    private FieldGroup rangeFieldGroupPrototype;
    private Message rangedToMessage;
    private boolean autoAddActiveCriteria;
    private List<String> additionalSecurePropertyNames;

    public LookupView() {
        this.setViewTypeName(UifConstants.ViewType.LOOKUP);
        this.setApplyDirtyCheck(false);
        this.setTriggerOnChange(false);
        this.setAutoAddActiveCriteria(true);
        this.additionalSecurePropertyNames = new ArrayList<String>();
    }

    @Override
    public void performInitialization(View view, Object model) {
        boolean isInactivatableClass = Inactivatable.class.isAssignableFrom(this.dataObjectClassName);
        if (this.autoAddActiveCriteria && isInactivatableClass) {
            this.autoAddActiveCriteria();
        }
        this.initializeGroups();
        view.assignComponentIds(this.getCriteriaGroup());
        view.assignComponentIds(this.getResultsGroup());
        if (this.getItems().isEmpty()) {
            this.setItems(Arrays.asList(this.getCriteriaGroup(), this.getResultsGroup()));
        }
        super.performInitialization(view, model);
        if (this.multipleValuesSelect) {
            this.hideReturnLinks = true;
        }
        this.getObjectPathToConcreteClassMapping().put("lookupCriteria", this.getDataObjectClassName());
        if (StringUtils.isNotBlank((String)this.getDefaultBindingObjectPath())) {
            this.getObjectPathToConcreteClassMapping().put(this.getDefaultBindingObjectPath(), this.getDataObjectClassName());
        }
    }

    private void autoAddActiveCriteria() {
        boolean hasActiveCriteria = false;
        for (Component field : this.getCriteriaFields()) {
            if (!((InputField)field).getPropertyName().equals("active")) continue;
            hasActiveCriteria = true;
        }
        if (!hasActiveCriteria) {
            AttributeDefinition attributeDefinition = KRADServiceLocatorWeb.getDataDictionaryService().getAttributeDefinition(this.dataObjectClassName.getName(), "active");
            LookupInputField activeField = new LookupInputField();
            if (attributeDefinition == null) {
                activeField = (LookupInputField)ComponentFactory.getNewComponentInstance("Uif-LookupActiveInputField");
            } else {
                activeField = (LookupInputField)ComponentFactory.getNewComponentInstance("Uif-LookupCriteriaInputField");
                activeField.setPropertyName("active");
                activeField.copyFromAttributeDefinition(this, attributeDefinition);
            }
            this.getCriteriaFields().add(activeField);
        }
    }

    protected void initializeGroups() {
        if (this.renderLookupCriteria && this.getCriteriaGroup() != null && this.getCriteriaGroup().getItems().isEmpty()) {
            this.getCriteriaGroup().setItems(this.getCriteriaFields());
        }
        if (this.getResultsGroup() != null) {
            if (this.getResultsGroup().getItems().isEmpty() && this.getResultFields() != null) {
                this.getResultsGroup().setItems(this.getResultFields());
            }
            if (this.getResultsGroup().getCollectionObjectClass() == null) {
                this.getResultsGroup().setCollectionObjectClass(this.getDataObjectClassName());
            }
        }
    }

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        LookupForm lookupForm = (LookupForm)model;
        if (!this.renderSearchButtons) {
            this.criteriaGroup.getFooter().setRender(false);
        }
        if (!this.renderLookupCriteria) {
            this.criteriaGroup.setRender(false);
        }
        if (!this.renderHeader) {
            this.getHeader().setRender(false);
        }
        this.setupLookupCriteriaFields(view, model);
        Group actionGroup = this.criteriaGroup.getFooter();
        Action searchButton = this.findSearchButton(actionGroup.getItems());
        if (searchButton != null) {
            String searchButtonId = searchButton.getId();
            for (Component component : this.criteriaGroup.getItems()) {
                this.addTriggerScripts(searchButtonId, component);
            }
        }
        super.performApplyModel(view, model, parent);
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        List<InputField> fields = ComponentUtils.getComponentsOfTypeDeep(this.criteriaGroup, InputField.class);
        for (InputField field : fields) {
            field.setForceSessionPersistence(true);
        }
    }

    private void addTriggerScripts(String searchButtonId, Component criteriaField) {
        if (criteriaField instanceof LookupInputField) {
            criteriaField.setOnKeyPressScript("if(e.which == 13) { e.preventDefault();jQuery('#" + searchButtonId + "' ).click();}");
            if (this.isTriggerOnChange() || ((LookupInputField)criteriaField).isTriggerOnChange()) {
                criteriaField.setOnChangeScript("jQuery('#" + searchButtonId + "' ).click();");
            }
        }
    }

    private Action findSearchButton(List<? extends Component> componentList) {
        List<Action> actionList = ComponentUtils.getComponentsOfType(componentList, Action.class);
        for (Action action : actionList) {
            String methodToCall = action.getMethodToCall();
            if (methodToCall == null || !methodToCall.equals("search")) continue;
            return action;
        }
        return null;
    }

    private void setupLookupCriteriaFields(View view, Object model) {
        HashMap<Integer, FieldGroup> dateRangeFieldMap = new HashMap<Integer, FieldGroup>();
        ExpressionEvaluator expressionEvaluator = view.getViewHelperService().getExpressionEvaluator();
        int rangeIndex = 0;
        for (Component component : this.criteriaGroup.getItems()) {
            Control control = ((InputField)component).getControl();
            if (control instanceof TextControl) {
                ((TextControl)control).setMaxLength(null);
            } else if (control instanceof TextAreaControl) {
                ((TextAreaControl)control).setMaxLength(null);
            }
            if (((LookupInputField)component).isRanged()) {
                FieldGroup rangeFieldGroup = ComponentUtils.copy(this.rangeFieldGroupPrototype, component.getId());
                rangeFieldGroup.setLabel(((LookupInputField)component).getLabel());
                expressionEvaluator.evaluatePropertyExpression(view, component.getContext(), component, "required", true);
                rangeFieldGroup.setRequired(component.getRequired());
                ((LookupInputField)component).getFieldLabel().setRequiredMessage(new Message());
                expressionEvaluator.evaluatePropertyExpression(view, component.getContext(), component, "render", true);
                rangeFieldGroup.setRender(component.isRender());
                ArrayList<Component> fieldGroupItems = new ArrayList<Component>();
                LookupInputField fromDate = (LookupInputField)ComponentUtils.copy(component, "From");
                fromDate.getBindingInfo().setBindingName("rangeLowerBoundKeyPrefix_" + fromDate.getPropertyName());
                fromDate.setPropertyName("rangeLowerBoundKeyPrefix_" + fromDate.getPropertyName());
                fromDate.setLabel("");
                fromDate.getFieldLabel().setRenderColon(false);
                ((LookupInputField)component).getFieldLabel().setRender(false);
                fieldGroupItems.add(fromDate);
                fieldGroupItems.add(this.rangedToMessage);
                fieldGroupItems.add(component);
                rangeFieldGroup.setItems(fieldGroupItems);
                dateRangeFieldMap.put(rangeIndex, rangeFieldGroup);
            }
            ++rangeIndex;
        }
        List<? extends Component> itemList = this.criteriaGroup.getItems();
        for (Integer index : dateRangeFieldMap.keySet()) {
            itemList.set(index, (Component)dateRangeFieldMap.get(index));
        }
        this.criteriaGroup.setItems(itemList);
    }

    @Override
    public List<Component> getComponentPrototypes() {
        List<Component> components = super.getComponentPrototypes();
        components.add(this.rangeFieldGroupPrototype);
        components.add(this.rangedToMessage);
        return components;
    }

    public void applyConditionalLogicForFieldDisplay() {
    }

    @BeanTagAttribute(name="dataObjectClassName")
    public Class<?> getDataObjectClassName() {
        return this.dataObjectClassName;
    }

    public void setDataObjectClassName(Class<?> dataObjectClassName) {
        this.dataObjectClassName = dataObjectClassName;
    }

    @BeanTagAttribute(name="hideReturnLinks")
    public boolean isHideReturnLinks() {
        return this.hideReturnLinks;
    }

    public void setHideReturnLinks(boolean hideReturnLinks) {
        this.hideReturnLinks = hideReturnLinks;
    }

    @BeanTagAttribute(name="isSuppressActions")
    public boolean isSuppressActions() {
        return this.suppressActions;
    }

    public void setSuppressActions(boolean suppressActions) {
        this.suppressActions = suppressActions;
    }

    @BeanTagAttribute(name="showMaintenanceLinks")
    public boolean isShowMaintenanceLinks() {
        return this.showMaintenanceLinks;
    }

    public void setShowMaintenanceLinks(boolean showMaintenanceLinks) {
        this.showMaintenanceLinks = showMaintenanceLinks;
    }

    @BeanTagAttribute(name="multipleValueSelect")
    public boolean isMultipleValuesSelect() {
        return this.multipleValuesSelect;
    }

    public void setMultipleValuesSelect(boolean multipleValuesSelect) {
        this.multipleValuesSelect = multipleValuesSelect;
    }

    @BeanTagAttribute(name="criteriaGroup", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Group getCriteriaGroup() {
        return this.criteriaGroup;
    }

    public void setCriteriaGroup(Group criteriaGroup) {
        this.criteriaGroup = criteriaGroup;
    }

    @BeanTagAttribute(name="resultsGroup", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public CollectionGroup getResultsGroup() {
        return this.resultsGroup;
    }

    public void setResultsGroup(CollectionGroup resultsGroup) {
        this.resultsGroup = resultsGroup;
    }

    @BeanTagAttribute(name="criteriaFields", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<Component> getCriteriaFields() {
        return this.criteriaFields;
    }

    public void setCriteriaFields(List<Component> criteriaFields) {
        this.criteriaFields = criteriaFields;
    }

    @BeanTagAttribute(name="resultFields", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<Component> getResultFields() {
        return this.resultFields;
    }

    public void setResultFields(List<Component> resultFields) {
        this.resultFields = resultFields;
    }

    @BeanTagAttribute(name="defaultSortAttributeNames", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getDefaultSortAttributeNames() {
        return this.defaultSortAttributeNames;
    }

    public void setDefaultSortAttributeNames(List<String> defaultSortAttributeNames) {
        this.defaultSortAttributeNames = defaultSortAttributeNames;
    }

    @BeanTagAttribute(name="defaultSortAscending")
    public boolean isDefaultSortAscending() {
        return this.defaultSortAscending;
    }

    public void setDefaultSortAscending(boolean defaultSortAscending) {
        this.defaultSortAscending = defaultSortAscending;
    }

    @BeanTagAttribute(name="resultSetLimit")
    public Integer getResultSetLimit() {
        return this.resultSetLimit;
    }

    public void setResultSetLimit(Integer resultSetLimit) {
        this.resultSetLimit = resultSetLimit;
    }

    public boolean hasResultSetLimit() {
        return this.resultSetLimit != null;
    }

    @BeanTagAttribute(name="multipleValuesSelectResultSetLimit")
    public Integer getMultipleValuesSelectResultSetLimit() {
        return this.multipleValuesSelectResultSetLimit;
    }

    public void setMultipleValuesSelectResultSetLimit(Integer multipleValuesSelectResultSetLimit) {
        this.multipleValuesSelectResultSetLimit = multipleValuesSelectResultSetLimit;
    }

    public boolean hasMultipleValuesSelectResultSetLimit() {
        return this.multipleValuesSelectResultSetLimit != null;
    }

    public void setReturnTarget(String returnTarget) {
        this.returnTarget = returnTarget;
    }

    @BeanTagAttribute(name="returnTarget")
    public String getReturnTarget() {
        return this.returnTarget;
    }

    @BeanTagAttribute(name="returnByScript")
    public boolean isReturnByScript() {
        return this.returnByScript;
    }

    public void setReturnByScript(boolean returnByScript) {
        this.returnByScript = returnByScript;
    }

    @BeanTagAttribute(name="maintenanceUrlMapping")
    public String getMaintenanceUrlMapping() {
        return this.maintenanceUrlMapping;
    }

    public void setMaintenanceUrlMapping(String maintenanceUrlMapping) {
        this.maintenanceUrlMapping = maintenanceUrlMapping;
    }

    public boolean isRenderSearchButtons() {
        return this.renderSearchButtons;
    }

    public void setRenderSearchButtons(boolean renderSearchButtons) {
        this.renderSearchButtons = renderSearchButtons;
    }

    public boolean isRenderLookupCriteria() {
        return this.renderLookupCriteria;
    }

    public void setRenderLookupCriteria(boolean renderLookupCriteria) {
        this.renderLookupCriteria = renderLookupCriteria;
    }

    public boolean isRenderHeader() {
        return this.renderHeader;
    }

    @Override
    public void setRenderHeader(boolean renderHeader) {
        this.renderHeader = renderHeader;
    }

    public boolean isTriggerOnChange() {
        return this.triggerOnChange;
    }

    public void setTriggerOnChange(boolean triggerOnChange) {
        this.triggerOnChange = triggerOnChange;
    }

    public FieldGroup getRangeFieldGroupPrototype() {
        return this.rangeFieldGroupPrototype;
    }

    public void setRangeFieldGroupPrototype(FieldGroup rangeFieldGroupPrototype) {
        this.rangeFieldGroupPrototype = rangeFieldGroupPrototype;
    }

    public boolean isAutoAddActiveCriteria() {
        return this.autoAddActiveCriteria;
    }

    public void setAutoAddActiveCriteria(boolean autoAddActiveCriteria) {
        this.autoAddActiveCriteria = autoAddActiveCriteria;
    }

    @BeanTagAttribute(name="additionalSecurePropertyNames", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getAdditionalSecurePropertyNames() {
        return this.additionalSecurePropertyNames;
    }

    public void setAdditionalSecurePropertyNames(List<String> additionalSecurePropertyNames) {
        this.additionalSecurePropertyNames = additionalSecurePropertyNames;
    }

    public Message getRangedToMessage() {
        return this.rangedToMessage;
    }

    public void setRangedToMessage(Message rangedToMessage) {
        this.rangedToMessage = rangedToMessage;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        LookupView lookupViewCopy = (LookupView)component;
        if (this.dataObjectClassName != null) {
            lookupViewCopy.setDataObjectClassName(this.getDataObjectClassName());
        }
        if (this.criteriaGroup != null) {
            lookupViewCopy.setCriteriaGroup((Group)this.getCriteriaGroup().copy());
        }
        if (this.resultsGroup != null) {
            lookupViewCopy.setResultsGroup((CollectionGroup)this.getResultsGroup().copy());
        }
        if (this.criteriaFields != null) {
            ArrayList criteriaFieldsCopy = Lists.newArrayListWithExpectedSize((int)this.criteriaFields.size());
            for (Component criteriaField : this.criteriaFields) {
                criteriaFieldsCopy.add((Component)criteriaField.copy());
            }
            lookupViewCopy.setCriteriaFields(criteriaFieldsCopy);
        }
        if (this.resultFields != null) {
            ArrayList resultFieldsCopy = Lists.newArrayListWithExpectedSize((int)this.resultFields.size());
            for (Component resultField : this.resultFields) {
                resultFieldsCopy.add((Component)resultField.copy());
            }
            lookupViewCopy.setResultFields(resultFieldsCopy);
        }
        if (this.defaultSortAttributeNames != null) {
            lookupViewCopy.setDefaultSortAttributeNames(new ArrayList<String>(this.defaultSortAttributeNames));
        }
        lookupViewCopy.setDefaultSortAscending(this.isDefaultSortAscending());
        lookupViewCopy.setHideReturnLinks(this.hideReturnLinks);
        lookupViewCopy.setSuppressActions(this.suppressActions);
        lookupViewCopy.setShowMaintenanceLinks(this.showMaintenanceLinks);
        lookupViewCopy.setMaintenanceUrlMapping(this.maintenanceUrlMapping);
        lookupViewCopy.setMultipleValuesSelect(this.multipleValuesSelect);
        lookupViewCopy.setRenderLookupCriteria(this.renderLookupCriteria);
        lookupViewCopy.setRenderSearchButtons(this.renderSearchButtons);
        lookupViewCopy.setRenderHeader(this.renderHeader);
        lookupViewCopy.setResultSetLimit(this.resultSetLimit);
        lookupViewCopy.setReturnTarget(this.returnTarget);
        lookupViewCopy.setTriggerOnChange(this.triggerOnChange);
        lookupViewCopy.setResultSetLimit(this.resultSetLimit);
        lookupViewCopy.setMultipleValuesSelectResultSetLimit(this.multipleValuesSelectResultSetLimit);
        lookupViewCopy.setMaintenanceUrlMapping(this.maintenanceUrlMapping);
        if (this.rangeFieldGroupPrototype != null) {
            lookupViewCopy.setRangeFieldGroupPrototype((FieldGroup)this.rangeFieldGroupPrototype.copy());
        }
        if (this.rangedToMessage != null) {
            lookupViewCopy.setRangedToMessage((Message)this.rangedToMessage.copy());
        }
        lookupViewCopy.setAutoAddActiveCriteria(this.autoAddActiveCriteria);
        if (this.additionalSecurePropertyNames != null) {
            lookupViewCopy.setAdditionalSecurePropertyNames(this.additionalSecurePropertyNames);
        }
    }
}

