/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import java.beans.PropertyEditor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ViewCleaner;
import org.kuali.rice.krad.uif.view.View;

public class ViewIndex
implements Serializable {
    private static final long serialVersionUID = 4700818801272201371L;
    protected Map<String, Component> index = new HashMap<String, Component>();
    protected Map<String, DataField> dataFieldIndex = new HashMap<String, DataField>();
    protected Set<String> idsToHoldInIndex = new HashSet<String>();
    protected Map<String, CollectionGroup> collectionsIndex = new HashMap<String, CollectionGroup>();
    protected Map<String, Component> initialComponentStates = new HashMap<String, Component>();
    protected Set<String> idsToHoldInitialState = new HashSet<String>();
    protected Map<String, PropertyEditor> fieldPropertyEditors = new HashMap<String, PropertyEditor>();
    protected Map<String, PropertyEditor> secureFieldPropertyEditors = new HashMap<String, PropertyEditor>();
    protected Map<String, Integer> idSequenceSnapshot = new HashMap<String, Integer>();
    protected Map<String, Map<String, String>> componentExpressionGraphs = new HashMap<String, Map<String, String>>();
    protected Map<String, Map<String, Object>> postContext = new HashMap<String, Map<String, Object>>();

    protected void index(View view) {
        this.index = new HashMap<String, Component>();
        this.dataFieldIndex = new HashMap<String, DataField>();
        this.collectionsIndex = new HashMap<String, CollectionGroup>();
        this.fieldPropertyEditors = new HashMap<String, PropertyEditor>();
        this.secureFieldPropertyEditors = new HashMap<String, PropertyEditor>();
        this.indexComponent(view);
    }

    public void indexComponent(Component component) {
        if (component == null) {
            return;
        }
        this.index.put(component.getId(), component);
        if (component instanceof DataField) {
            DataField field = (DataField)component;
            this.dataFieldIndex.put(field.getBindingInfo().getBindingPath(), field);
            if (component.isRender()) {
                if (field.hasSecureValue()) {
                    this.secureFieldPropertyEditors.put(field.getBindingInfo().getBindingPath(), field.getPropertyEditor());
                } else {
                    this.fieldPropertyEditors.put(field.getBindingInfo().getBindingPath(), field.getPropertyEditor());
                }
            }
        } else if (component instanceof CollectionGroup) {
            CollectionGroup collectionGroup = (CollectionGroup)component;
            this.collectionsIndex.put(collectionGroup.getBindingInfo().getBindingPath(), collectionGroup);
        }
        for (Component nestedComponent : component.getComponentsForLifecycle()) {
            this.indexComponent(nestedComponent);
        }
    }

    public void clearIndexesAfterRender() {
        for (Component component : this.index.values()) {
            InputField inputField;
            if (component == null || component.isDisableSessionPersistence()) continue;
            if (component.isForceSessionPersistence() || this.canBeRefreshed(component)) {
                this.idsToHoldInitialState.add(component.getBaseId());
                this.idsToHoldInIndex.add(component.getId());
                continue;
            }
            if (component instanceof CollectionGroup) {
                this.idsToHoldInitialState.add(component.getBaseId());
                this.idsToHoldInIndex.add(component.getId());
                continue;
            }
            if (!(component instanceof InputField) || (inputField = (InputField)component).getAttributeQuery() == null && (inputField.getSuggest() == null || !inputField.getSuggest().isRender())) continue;
            this.idsToHoldInIndex.add(component.getId());
        }
        HashMap<String, Component> holdInitialComponentStates = new HashMap<String, Component>();
        for (String factoryId : this.initialComponentStates.keySet()) {
            if (!this.idsToHoldInitialState.contains(factoryId)) continue;
            holdInitialComponentStates.put(factoryId, this.initialComponentStates.get(factoryId));
        }
        this.initialComponentStates = holdInitialComponentStates;
        HashMap<String, Component> holdComponentStates = new HashMap<String, Component>();
        for (String id : this.index.keySet()) {
            if (!this.idsToHoldInIndex.contains(id)) continue;
            Component component = this.index.get(id);
            if (component.getRefreshExpressionGraph() != null && !component.getRefreshExpressionGraph().isEmpty()) {
                this.componentExpressionGraphs.put(component.getBaseId(), component.getRefreshExpressionGraph());
            }
            ViewCleaner.cleanComponent(component, this);
            holdComponentStates.put(id, component);
        }
        this.index = holdComponentStates;
        for (CollectionGroup collectionGroup : this.collectionsIndex.values()) {
            ViewCleaner.cleanComponent(collectionGroup, this);
        }
        this.dataFieldIndex = new HashMap<String, DataField>();
    }

    protected boolean canBeRefreshed(Component component) {
        boolean canBeRefreshed = false;
        boolean hasRefreshCondition = StringUtils.isNotBlank((String)component.getProgressiveRender()) || StringUtils.isNotBlank((String)component.getConditionalRefresh()) || component.getRefreshTimer() > 0 || component.getRefreshWhenChangedPropertyNames() != null && !component.getRefreshWhenChangedPropertyNames().isEmpty();
        canBeRefreshed = hasRefreshCondition || component.isRefreshedByAction() || component.isDisclosedByAction();
        return canBeRefreshed;
    }

    public boolean isIdForRefreshComponent(String componentId) {
        return this.idsToHoldInIndex.contains(componentId);
    }

    public Component getComponentById(String id) {
        return this.index.get(id);
    }

    public DataField getDataFieldByPath(String propertyPath) {
        return this.dataFieldIndex.get(propertyPath);
    }

    public DataField getDataFieldByPropertyName(String propertyName) {
        DataField dataField = null;
        for (DataField field : this.dataFieldIndex.values()) {
            if (!StringUtils.equals((String)propertyName, (String)field.getPropertyName())) continue;
            dataField = field;
            break;
        }
        return dataField;
    }

    public Map<String, DataField> getDataFieldIndex() {
        return this.dataFieldIndex;
    }

    public Map<String, CollectionGroup> getCollectionsIndex() {
        return this.collectionsIndex;
    }

    public CollectionGroup getCollectionGroupByPath(String collectionPath) {
        return this.collectionsIndex.get(collectionPath);
    }

    public Map<String, Component> getInitialComponentStates() {
        return this.initialComponentStates;
    }

    public void addInitialComponentStateIfNeeded(Component component) {
        if (StringUtils.isBlank((String)component.getBaseId())) {
            component.setBaseId(component.getId());
            this.initialComponentStates.put(component.getBaseId(), ComponentUtils.copy(component));
        }
    }

    public void setInitialComponentStates(Map<String, Component> initialComponentStates) {
        this.initialComponentStates = initialComponentStates;
    }

    public Map<String, PropertyEditor> getFieldPropertyEditors() {
        return this.fieldPropertyEditors;
    }

    public Map<String, PropertyEditor> getSecureFieldPropertyEditors() {
        return this.secureFieldPropertyEditors;
    }

    public Map<String, Integer> getIdSequenceSnapshot() {
        return this.idSequenceSnapshot;
    }

    public void addSequenceValueToSnapshot(String componentId, int sequenceVal) {
        if (!this.idSequenceSnapshot.containsKey(componentId)) {
            this.idSequenceSnapshot.put(componentId, sequenceVal);
        }
    }

    public Map<String, Map<String, String>> getComponentExpressionGraphs() {
        return this.componentExpressionGraphs;
    }

    public Map<String, Map<String, Object>> getPostContext() {
        return this.postContext;
    }

    public void addPostContextEntry(String componentId, String entryKey, Object entryValue) {
        Map<Object, Object> componentContext = null;
        if (this.postContext.containsKey(componentId)) {
            componentContext = this.postContext.get(componentId);
        } else {
            componentContext = new HashMap();
            this.postContext.put(componentId, componentContext);
        }
        componentContext.put(entryKey, entryValue);
    }

    public Object getPostContextEntry(String componentId, String entryKey) {
        Object entryValue = null;
        Map<String, Object> componentContext = null;
        if (this.postContext.containsKey(componentId)) {
            componentContext = this.postContext.get(componentId);
            entryValue = componentContext.get(entryKey);
        }
        return entryValue;
    }

    public ViewIndex copy() {
        ViewIndex viewIndexCopy = new ViewIndex();
        if (this.index != null) {
            HashMap<String, Component> indexCopy = new HashMap<String, Component>();
            for (Map.Entry<String, Component> entry : this.index.entrySet()) {
                indexCopy.put(entry.getKey(), (Component)entry.getValue().copy());
            }
            viewIndexCopy.index = indexCopy;
        }
        if (this.dataFieldIndex != null) {
            HashMap<String, DataField> dataFieldIndexCopy = new HashMap<String, DataField>();
            for (Map.Entry<String, Component> entry : this.dataFieldIndex.entrySet()) {
                dataFieldIndexCopy.put(entry.getKey(), (DataField)((DataField)entry.getValue()).copy());
            }
            viewIndexCopy.dataFieldIndex = dataFieldIndexCopy;
        }
        if (this.collectionsIndex != null) {
            HashMap<String, CollectionGroup> collectionsIndexCopy = new HashMap<String, CollectionGroup>();
            for (Map.Entry<String, Component> entry : this.collectionsIndex.entrySet()) {
                collectionsIndexCopy.put(entry.getKey(), (CollectionGroup)((CollectionGroup)entry.getValue()).copy());
            }
            viewIndexCopy.collectionsIndex = collectionsIndexCopy;
        }
        if (this.initialComponentStates != null) {
            HashMap<String, Component> initialComponentStatesCopy = new HashMap<String, Component>();
            for (Map.Entry<String, Component> entry : this.initialComponentStates.entrySet()) {
                initialComponentStatesCopy.put(entry.getKey(), (Component)entry.getValue().copy());
            }
            viewIndexCopy.initialComponentStates = initialComponentStatesCopy;
        }
        if (this.fieldPropertyEditors != null) {
            viewIndexCopy.fieldPropertyEditors = new HashMap<String, PropertyEditor>(this.fieldPropertyEditors);
        }
        if (this.secureFieldPropertyEditors != null) {
            viewIndexCopy.secureFieldPropertyEditors = new HashMap<String, PropertyEditor>(this.secureFieldPropertyEditors);
        }
        if (this.idSequenceSnapshot != null) {
            viewIndexCopy.idSequenceSnapshot = new HashMap<String, Integer>(this.idSequenceSnapshot);
        }
        if (this.componentExpressionGraphs != null) {
            viewIndexCopy.componentExpressionGraphs = new HashMap<String, Map<String, String>>(this.componentExpressionGraphs);
        }
        if (this.postContext != null) {
            viewIndexCopy.postContext = new HashMap<String, Map<String, Object>>(this.postContext);
        }
        return viewIndexCopy;
    }
}

