/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBeanBase;

@BeanTags(value={@BeanTag(name="viewTheme-bean", parent="Uif-ViewTheme"), @BeanTag(name="kbootTheme-bean", parent="Uif-KbootTheme")})
public class ViewTheme
extends UifDictionaryBeanBase
implements Serializable {
    private static final long serialVersionUID = 7063256242857896580L;
    private static final Logger LOG = Logger.getLogger(ViewTheme.class);
    private String name;
    private String directory;
    private String imageDirectory;
    private String minVersionSuffix;
    private boolean includeMinFiles = true;
    private String minCssFile;
    private String minScriptFile;
    private List<String> minCssSourceFiles = new ArrayList<String>();
    private List<String> minScriptSourceFiles = new ArrayList<String>();
    private List<String> cssFiles = new ArrayList<String>();
    private List<String> scriptFiles = new ArrayList<String>();
    private boolean usesThemeBuilder = true;

    public void configureThemeDefaults() {
        if (this.inDevMode()) {
            if (this.usesThemeBuilder) {
                this.setMinFileLists();
            }
            this.cssFiles.addAll(0, this.minCssSourceFiles);
            this.scriptFiles.addAll(0, this.minScriptSourceFiles);
        } else if (this.includeMinFiles) {
            if (StringUtils.isBlank((String)this.minVersionSuffix)) {
                this.minVersionSuffix = this.getConfigurationService().getPropertyValueAsString("application.version");
            }
            String themeDirectory = this.getThemeDirectory();
            if (StringUtils.isBlank((String)this.minCssFile)) {
                String minCssFileName = this.name + "." + this.minVersionSuffix + ".min" + ".css";
                this.minCssFile = themeDirectory + "/" + "stylesheets" + "/" + minCssFileName;
            }
            if (StringUtils.isBlank((String)this.minScriptFile)) {
                String minScriptFileName = this.name + "." + this.minVersionSuffix + ".min" + ".js";
                this.minScriptFile = themeDirectory + "/" + "scripts" + "/" + minScriptFileName;
            }
            this.cssFiles.add(0, this.minCssFile);
            this.scriptFiles.add(0, this.minScriptFile);
        }
    }

    public String getThemeDirectory() {
        String themeDirectory = "";
        if (StringUtils.isNotBlank((String)this.directory)) {
            if (this.directory.startsWith("/")) {
                this.directory = this.directory.substring(1);
            }
            themeDirectory = this.directory;
        } else {
            themeDirectory = "/themes".substring(1) + "/" + this.name;
        }
        return themeDirectory;
    }

    protected void setMinFileLists() {
        String[] jsFiles;
        Properties themeProperties = null;
        try {
            themeProperties = this.getThemeProperties();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to retrieve theme properties for theme: " + this.name);
        }
        if (themeProperties == null) {
            LOG.warn((Object)("No theme properties file found for theme with name: " + this.name));
            return;
        }
        String[] cssFiles = this.getPropertyValue(themeProperties, "themeCssFiles");
        if (cssFiles != null) {
            for (String cssFile : cssFiles) {
                this.minCssSourceFiles.add(cssFile);
            }
        }
        if ((jsFiles = this.getPropertyValue(themeProperties, "themeJsFiles")) != null) {
            for (String jsFile : jsFiles) {
                this.minScriptSourceFiles.add(jsFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getThemeProperties() throws IOException {
        Properties themeProperties = null;
        String appUrl = this.getConfigurationService().getPropertyValueAsString("application.url");
        String propertiesUrlPath = appUrl + "/" + this.getThemeDirectory() + "/" + "theme-derived.properties";
        InputStream inputStream = null;
        try {
            URL propertiesUrl = new URL(propertiesUrlPath);
            inputStream = propertiesUrl.openStream();
            themeProperties = new Properties();
            themeProperties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return themeProperties;
    }

    protected String[] getPropertyValue(Properties properties, String key) {
        String propertyValueString;
        String[] propertyValueArray = null;
        if (properties.containsKey(key) && (propertyValueString = properties.getProperty(key)) != null) {
            propertyValueArray = propertyValueString.split(",");
        }
        return propertyValueArray;
    }

    protected boolean inDevMode() {
        return this.getConfigurationService().getPropertyValueAsBoolean("rice.krad.dev.mode");
    }

    @BeanTagAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @BeanTagAttribute(name="directory")
    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @BeanTagAttribute(name="imageDirectory")
    public String getImageDirectory() {
        if (StringUtils.isBlank((String)this.imageDirectory)) {
            String appUrl = this.getConfigurationService().getPropertyValueAsString("application.url");
            this.imageDirectory = appUrl + "/" + this.getThemeDirectory() + "/" + "images" + "/";
        }
        return this.imageDirectory;
    }

    public void setImageDirectory(String imageDirectory) {
        this.imageDirectory = imageDirectory;
    }

    @BeanTagAttribute(name="minVersionSuffix")
    public String getMinVersionSuffix() {
        return this.minVersionSuffix;
    }

    public void setMinVersionSuffix(String minVersionSuffix) {
        this.minVersionSuffix = minVersionSuffix;
    }

    public boolean isIncludeMinFiles() {
        return this.includeMinFiles;
    }

    public void setIncludeMinFiles(boolean includeMinFiles) {
        this.includeMinFiles = includeMinFiles;
    }

    @BeanTagAttribute(name="minCssFile")
    public String getMinCssFile() {
        return this.minCssFile;
    }

    public void setMinCssFile(String minCssFile) {
        this.minCssFile = minCssFile;
    }

    @BeanTagAttribute(name="minScriptFile")
    public String getMinScriptFile() {
        return this.minScriptFile;
    }

    public void setMinScriptFile(String minScriptFile) {
        this.minScriptFile = minScriptFile;
    }

    @BeanTagAttribute(name="minCssSourceFiles", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getMinCssSourceFiles() {
        return this.minCssSourceFiles;
    }

    public void setMinCssSourceFiles(List<String> minCssSourceFiles) {
        this.minCssSourceFiles = minCssSourceFiles;
    }

    @BeanTagAttribute(name="minScriptSourceFiles", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getMinScriptSourceFiles() {
        return this.minScriptSourceFiles;
    }

    public void setMinScriptSourceFiles(List<String> minScriptSourceFiles) {
        this.minScriptSourceFiles = minScriptSourceFiles;
    }

    @BeanTagAttribute(name="cssFiles", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getCssFiles() {
        return this.cssFiles;
    }

    public void setCssFiles(List<String> cssFiles) {
        this.cssFiles = cssFiles;
    }

    @BeanTagAttribute(name="scriptFiles", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getScriptFiles() {
        return this.scriptFiles;
    }

    public void setScriptFiles(List<String> scriptFiles) {
        this.scriptFiles = scriptFiles;
    }

    @BeanTagAttribute(name="usesThemeBuilder")
    public boolean isUsesThemeBuilder() {
        return this.usesThemeBuilder;
    }

    public void setUsesThemeBuilder(boolean usesThemeBuilder) {
        this.usesThemeBuilder = usesThemeBuilder;
    }

    public ConfigurationService getConfigurationService() {
        return CoreApiServiceLocator.getKualiConfigurationService();
    }

    @Override
    public <T> T copy() {
        T copiedClass = null;
        try {
            copiedClass = (T)this.getClass().newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
        this.copyProperties(copiedClass);
        return copiedClass;
    }

    @Override
    protected <T> void copyProperties(T viewTheme) {
        super.copyProperties(viewTheme);
        ViewTheme viewThemeCopy = (ViewTheme)viewTheme;
        viewThemeCopy.setName(this.name);
        viewThemeCopy.setDirectory(this.directory);
        viewThemeCopy.setImageDirectory(this.imageDirectory);
        viewThemeCopy.setMinVersionSuffix(this.minVersionSuffix);
        viewThemeCopy.setIncludeMinFiles(this.includeMinFiles);
        viewThemeCopy.setMinCssFile(this.minCssFile);
        viewThemeCopy.setMinScriptFile(this.minScriptFile);
        if (this.minCssSourceFiles != null) {
            viewThemeCopy.setMinCssSourceFiles(new ArrayList<String>(this.minCssSourceFiles));
        }
        if (this.minScriptSourceFiles != null) {
            viewThemeCopy.setMinScriptSourceFiles(new ArrayList<String>(this.minScriptSourceFiles));
        }
        if (this.cssFiles != null) {
            viewThemeCopy.setCssFiles(new ArrayList<String>(this.cssFiles));
        }
        if (this.scriptFiles != null) {
            viewThemeCopy.setScriptFiles(new ArrayList<String>(this.scriptFiles));
        }
        viewThemeCopy.setUsesThemeBuilder(this.usesThemeBuilder);
    }
}

