/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.widget;

import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.WidgetBase;

public class Pager
extends WidgetBase {
    private String linkScript;
    private int maxNumberedLinksShown;
    private int numberOfPages;
    private int currentPage;
    private boolean renderPrevNext;
    private boolean renderFirstLast;
    protected int pagesStart;
    protected int pagesEnd;

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (this.numberOfPages == 0 || this.numberOfPages == 1) {
            this.setRender(false);
        }
        if (this.maxNumberedLinksShown >= this.numberOfPages) {
            this.pagesStart = 1;
            this.pagesEnd = this.numberOfPages;
        } else {
            int beforeAfterShown = (int)Math.floor((double)this.maxNumberedLinksShown / 2.0);
            this.pagesStart = this.currentPage - beforeAfterShown;
            this.pagesEnd = this.currentPage + beforeAfterShown;
            if (this.pagesEnd - this.pagesStart == this.maxNumberedLinksShown) {
                --this.pagesEnd;
            }
            if (this.pagesEnd > this.numberOfPages) {
                this.pagesEnd = this.numberOfPages;
                this.pagesStart = this.numberOfPages - this.maxNumberedLinksShown + 1;
            }
            if (this.pagesStart < 1) {
                this.pagesStart = 1;
                if (this.maxNumberedLinksShown < this.numberOfPages) {
                    this.pagesEnd = this.maxNumberedLinksShown;
                }
            }
        }
        this.linkScript = "e.preventDefault();" + this.linkScript;
    }

    public String getLinkScript() {
        return this.linkScript;
    }

    public void setLinkScript(String linkScript) {
        this.linkScript = linkScript;
    }

    public int getMaxNumberedLinksShown() {
        return this.maxNumberedLinksShown;
    }

    public void setMaxNumberedLinksShown(int maxNumberedLinksShown) {
        this.maxNumberedLinksShown = maxNumberedLinksShown;
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setNumberOfPages(int numberOfPages) {
        this.numberOfPages = numberOfPages;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public boolean isRenderFirstLast() {
        return this.renderFirstLast;
    }

    public void setRenderFirstLast(boolean renderFirstLast) {
        this.renderFirstLast = renderFirstLast;
    }

    public boolean isRenderPrevNext() {
        return this.renderPrevNext;
    }

    public void setRenderPrevNext(boolean renderPrevNext) {
        this.renderPrevNext = renderPrevNext;
    }

    public int getPagesStart() {
        return this.pagesStart;
    }

    public int getPagesEnd() {
        return this.pagesEnd;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        Pager pagerCopy = (Pager)component;
        pagerCopy.setLinkScript(this.getLinkScript());
        pagerCopy.setMaxNumberedLinksShown(this.getMaxNumberedLinksShown());
        pagerCopy.setNumberOfPages(this.getNumberOfPages());
        pagerCopy.setCurrentPage(this.getCurrentPage());
        pagerCopy.setRenderPrevNext(this.isRenderPrevNext());
        pagerCopy.setRenderFirstLast(this.isRenderFirstLast());
        pagerCopy.pagesStart = this.pagesStart;
        pagerCopy.pagesEnd = this.pagesEnd;
    }
}

