/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.widget;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.core.api.util.type.KualiPercent;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentBase;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.control.CheckboxControl;
import org.kuali.rice.krad.uif.control.CheckboxGroupControl;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.RadioGroupControl;
import org.kuali.rice.krad.uif.control.SelectControl;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.field.LinkField;
import org.kuali.rice.krad.uif.field.MessageField;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.WidgetBase;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.UifFormBase;

@BeanTags(value={@BeanTag(name="richTable-bean", parent="Uif-RichTable"), @BeanTag(name="pagedRichTable-bean", parent="Uif-PagedRichTable"), @BeanTag(name="scrollableRichTable-bean", parent="Uif-ScrollableRichTable")})
public class RichTable
extends WidgetBase {
    private static final long serialVersionUID = 4671589690877390070L;
    private String emptyTableMessage;
    private boolean disableTableSort;
    private boolean forceAoColumnDefsOverride;
    private boolean forceLocalJsonData;
    private int nestedLevel;
    private String aaData;
    private Set<String> hiddenColumns;
    private Set<String> sortableColumns;
    private List<String> cellCssClasses = new ArrayList<String>();
    private String ajaxSource;
    private boolean showSearchAndExportOptions = true;
    private boolean showSearchOption = false;
    private boolean showExportOption = false;
    private String groupingOptionsJSString = "null";

    @Override
    public void performFinalize(View view, Object model, Component component) {
        String sDomOption;
        String domOption;
        super.performFinalize(view, model, component);
        UifFormBase formBase = (UifFormBase)model;
        if (!this.isRender()) {
            return;
        }
        if (StringUtils.isNotBlank((String)this.getEmptyTableMessage()) && !this.getTemplateOptions().containsKey("oLanguage")) {
            Map<String, String> oTemplateOptions = this.getTemplateOptions();
            if (oTemplateOptions == null) {
                oTemplateOptions = new HashMap<String, String>();
                this.setTemplateOptions(oTemplateOptions);
            }
            oTemplateOptions.put("oLanguage", "{\"sEmptyTable\" : \"" + this.getEmptyTableMessage() + "\"}");
        }
        if (!this.isShowSearchAndExportOptions() && (domOption = this.getTemplateOptions().get("sDom")) instanceof String && StringUtils.isNotBlank((String)(sDomOption = domOption))) {
            if (!this.isShowExportOption()) {
                sDomOption = StringUtils.remove((String)sDomOption, (String)"T");
            }
            if (!this.isShowSearchOption()) {
                sDomOption = StringUtils.remove((String)sDomOption, (String)"f");
            }
            this.getTemplateOptions().put("sDom", sDomOption);
        }
        if ("addLine".equals(formBase.getActionEvent()) || "addBlankLine".equals(formBase.getActionEvent())) {
            this.getTemplateOptions().put("aaSorting", "[]");
        }
        if (component instanceof CollectionGroup) {
            CollectionGroup collectionGroup = (CollectionGroup)component;
            LayoutManager layoutManager = collectionGroup.getLayoutManager();
            if (layoutManager instanceof TableLayoutManager && collectionGroup.isUseServerPaging()) {
                this.addCellStyling((TableLayoutManager)layoutManager);
            }
            this.buildTableOptions(collectionGroup);
            this.setTotalOptions(collectionGroup);
        }
        if (this.isDisableTableSort()) {
            this.getTemplateOptions().put("bSort", "false");
        }
        String kradUrl = this.getConfigurationService().getPropertyValueAsString("krad.url");
        if (StringUtils.isNotBlank((String)this.ajaxSource)) {
            this.getTemplateOptions().put("sAjaxSource", this.ajaxSource);
        } else if (component instanceof CollectionGroup && ((CollectionGroup)component).isUseServerPaging()) {
            this.getTemplateOptions().put("bProcessing", "true");
            this.getTemplateOptions().put("bServerSide", "true");
            this.getTemplateOptions().put("sAjaxSource", kradUrl + ((UifFormBase)model).getControllerMapping() + "?" + "methodToCall" + "=" + "tableJsonRetrieval" + "&" + "tableId" + "=" + component.getId() + "&" + "formKey" + "=" + ((UifFormBase)model).getFormKey() + "&" + "ajaxReturnType" + "=" + UifConstants.AjaxReturnTypes.UPDATENONE.getKey() + "&" + "ajaxRequest" + "=" + "true");
            view.getViewIndex().addPostContextEntry(component.getId(), "aoColumnDefs", this.getTemplateOptions().get("aoColumnDefs"));
        }
        this.getTemplateOptions().put("sDownloadSource", kradUrl + ((UifFormBase)model).getControllerMapping() + "?" + "tableId" + "=" + component.getId() + "&" + "formKey" + "=" + ((UifFormBase)model).getFormKey() + "&" + "ajaxReturnType" + "=" + UifConstants.AjaxReturnTypes.UPDATENONE.getKey() + "&" + "ajaxRequest" + "=" + "true");
    }

    private void addCellStyling(TableLayoutManager manager) {
        if (!CollectionUtils.isEmpty(manager.getAllRowFields())) {
            for (int index = 0; index < manager.getNumberOfColumns(); ++index) {
                String cellStyleClasses = ((ComponentBase)((Object)manager.getAllRowFields().get(index))).getCellStyleClassesAsString();
                this.cellCssClasses.add(cellStyleClasses);
            }
        }
    }

    private void setTotalOptions(CollectionGroup collectionGroup) {
        List<String> totalColumns;
        LayoutManager layoutManager = collectionGroup.getLayoutManager();
        if (layoutManager instanceof TableLayoutManager && (totalColumns = ((TableLayoutManager)layoutManager).getColumnsToCalculate()).size() > 0) {
            String array = "[";
            for (String i : totalColumns) {
                array = array + i + ",";
            }
            array = StringUtils.removeEnd((String)array, (String)",");
            array = array + "]";
            Map<String, String> oTemplateOptions = this.getTemplateOptions();
            if (oTemplateOptions == null) {
                oTemplateOptions = new HashMap<String, String>();
                this.setTemplateOptions(oTemplateOptions);
            }
            oTemplateOptions.put("fnFooterCallback", "function (nRow, aaData, iStart, iEnd, aiDisplay) {initializeTotalsFooter (nRow, aaData, iStart, iEnd, aiDisplay, " + array + " )}");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void buildTableOptions(CollectionGroup collectionGroup) {
        LayoutManager layoutManager = collectionGroup.getLayoutManager();
        boolean isUseServerPaging = collectionGroup.isUseServerPaging();
        if (!collectionGroup.getSubCollections().isEmpty()) {
            this.setDisableTableSort(true);
        }
        if (!this.isDisableTableSort()) {
            String jsArray;
            String actionColOptions;
            boolean actionFieldVisible;
            if (!(!collectionGroup.isRenderAddLine() || collectionGroup.isReadOnly() || layoutManager instanceof TableLayoutManager && ((TableLayoutManager)layoutManager).isSeparateAddLine())) {
                Map<String, String> oTemplateOptions = this.getTemplateOptions();
                if (oTemplateOptions == null) {
                    oTemplateOptions = new HashMap<String, String>();
                    this.setTemplateOptions(oTemplateOptions);
                }
                oTemplateOptions.put("aiSortingSkipRows", "[0]");
            }
            StringBuilder tableToolsColumnOptions = new StringBuilder("[");
            int columnIndex = 0;
            int actionIndex = -1;
            boolean bl = actionFieldVisible = collectionGroup.isRenderLineActions() && !collectionGroup.isReadOnly();
            if (layoutManager instanceof TableLayoutManager) {
                actionIndex = ((TableLayoutManager)layoutManager).getActionColumnIndex();
            }
            if (actionIndex == 1 && actionFieldVisible) {
                String actionColOptions2 = this.constructTableColumnOptions(columnIndex, false, isUseServerPaging, null, null);
                tableToolsColumnOptions.append(actionColOptions2 + " , ");
                ++columnIndex;
            }
            if (layoutManager instanceof TableLayoutManager && ((TableLayoutManager)layoutManager).isRenderSequenceField()) {
                String mDataOption = "";
                if (collectionGroup.isUseServerPaging() || this.forceLocalJsonData) {
                    mDataOption = "\"mDataProp\" : function(row,type,newVal){ return _handleColData(row,type,'c" + columnIndex + "',newVal);}, ";
                }
                tableToolsColumnOptions.append("{\"bSortable\" : false, \"sType\" : \"numeric\", " + mDataOption + "\"" + "aTargets" + "\": [" + columnIndex + "]}, ");
                ++columnIndex;
                if (actionIndex == 2 && actionFieldVisible) {
                    actionColOptions = this.constructTableColumnOptions(columnIndex, false, isUseServerPaging, null, null);
                    tableToolsColumnOptions.append(actionColOptions + " , ");
                    ++columnIndex;
                }
            }
            if (collectionGroup.isIncludeLineSelectionField()) {
                String colOptions = this.constructTableColumnOptions(columnIndex, false, isUseServerPaging, null, null);
                tableToolsColumnOptions.append(colOptions + " , ");
                ++columnIndex;
            }
            if (!StringUtils.isEmpty((String)this.getTemplateOptions().get("aoColumns"))) {
                jsArray = this.getTemplateOptions().get("aoColumns");
                int startBrace = StringUtils.indexOf((String)jsArray, (String)"[");
                int n = StringUtils.lastIndexOf((String)jsArray, (String)"]");
                tableToolsColumnOptions.append(StringUtils.substring((String)jsArray, (int)(startBrace + 1), (int)n) + ", ");
                if (actionFieldVisible && (actionIndex == -1 || actionIndex >= columnIndex)) {
                    String actionColOptions3 = this.constructTableColumnOptions(columnIndex, false, isUseServerPaging, null, null);
                    tableToolsColumnOptions.append(actionColOptions3);
                } else {
                    tableToolsColumnOptions = new StringBuilder(StringUtils.removeEnd((String)tableToolsColumnOptions.toString(), (String)", "));
                }
                tableToolsColumnOptions.append("]");
                this.getTemplateOptions().put("aoColumns", tableToolsColumnOptions.toString());
            } else if (!StringUtils.isEmpty((String)this.getTemplateOptions().get("aoColumnDefs")) && this.forceAoColumnDefsOverride) {
                jsArray = this.getTemplateOptions().get("aoColumnDefs");
                int startBrace = StringUtils.indexOf((String)jsArray, (String)"[");
                int n = StringUtils.lastIndexOf((String)jsArray, (String)"]");
                tableToolsColumnOptions.append(StringUtils.substring((String)jsArray, (int)(startBrace + 1), (int)n) + ", ");
                if (actionFieldVisible && (actionIndex == -1 || actionIndex >= columnIndex)) {
                    String actionColOptions4 = this.constructTableColumnOptions(columnIndex, false, isUseServerPaging, null, null);
                    tableToolsColumnOptions.append(actionColOptions4);
                } else {
                    tableToolsColumnOptions = new StringBuilder(StringUtils.removeEnd((String)tableToolsColumnOptions.toString(), (String)", "));
                }
                tableToolsColumnOptions.append("]");
                this.getTemplateOptions().put("aoColumnDefs", tableToolsColumnOptions.toString());
            } else if (layoutManager instanceof TableLayoutManager) {
                List<Field> rowFields = ((TableLayoutManager)layoutManager).getFirstRowFields();
                for (Field field : rowFields) {
                    String colOptions;
                    Map<String, String> componentDataAttributes;
                    void var10_14;
                    if (actionFieldVisible && columnIndex + 1 == actionIndex) {
                        String actionColOptions5 = this.constructTableColumnOptions(columnIndex, false, isUseServerPaging, null, null);
                        tableToolsColumnOptions.append(actionColOptions5 + " , ");
                        ++columnIndex;
                    }
                    String mDataOption = "";
                    if (collectionGroup.isUseServerPaging() || this.forceLocalJsonData) {
                        mDataOption = "\"mDataProp\" : function(row,type,newVal){ return _handleColData(row,type,'c" + columnIndex + "',newVal);}, ";
                    }
                    if (field instanceof FieldGroup) {
                        Component component = ((FieldGroup)field).getItems().get(0);
                    }
                    if (var10_14 instanceof DataField) {
                        DataField field2 = (DataField)var10_14;
                        if (this.getHiddenColumns() != null && this.getHiddenColumns().contains(field2.getPropertyName())) {
                            tableToolsColumnOptions.append("{bVisible: false, " + mDataOption + "\"" + "aTargets" + "\": [" + columnIndex + "]" + "}, ");
                        } else if (this.getSortableColumns() != null && !this.getSortableColumns().isEmpty()) {
                            if (this.getSortableColumns().contains(field2.getPropertyName())) {
                                tableToolsColumnOptions.append(this.getDataFieldColumnOptions(columnIndex, collectionGroup, field2) + ", ");
                            } else {
                                tableToolsColumnOptions.append("{'bSortable': false, " + mDataOption + "\"" + "aTargets" + "\": [" + columnIndex + "]" + "}, ");
                            }
                        } else {
                            String colOptions2 = this.getDataFieldColumnOptions(columnIndex, collectionGroup, field2);
                            tableToolsColumnOptions.append(colOptions2 + " , ");
                        }
                        ++columnIndex;
                        continue;
                    }
                    if (var10_14 instanceof MessageField && (componentDataAttributes = var10_14.getDataAttributes()) != null && "RowGrouping".equals(componentDataAttributes.get("role"))) {
                        tableToolsColumnOptions.append("{bVisible: false, " + mDataOption + "\"" + "aTargets" + "\": [" + columnIndex + "]" + "}, ");
                        ++columnIndex;
                        continue;
                    }
                    if (var10_14 instanceof LinkField) {
                        colOptions = this.constructTableColumnOptions(columnIndex, true, isUseServerPaging, String.class, "dom-text");
                        tableToolsColumnOptions.append(colOptions + " , ");
                        ++columnIndex;
                        continue;
                    }
                    colOptions = this.constructTableColumnOptions(columnIndex, false, isUseServerPaging, null, null);
                    tableToolsColumnOptions.append(colOptions + " , ");
                    ++columnIndex;
                }
                if (actionFieldVisible && (actionIndex == -1 || actionIndex >= columnIndex)) {
                    actionColOptions = this.constructTableColumnOptions(columnIndex, false, isUseServerPaging, null, null);
                    tableToolsColumnOptions.append(actionColOptions);
                } else {
                    tableToolsColumnOptions = new StringBuilder(StringUtils.removeEnd((String)tableToolsColumnOptions.toString(), (String)", "));
                }
                if (!StringUtils.isEmpty((String)this.getTemplateOptions().get("aoColumnDefs"))) {
                    String origAoOptions = this.getTemplateOptions().get("aoColumnDefs").trim();
                    origAoOptions = StringUtils.removeStart((String)origAoOptions, (String)"[");
                    origAoOptions = StringUtils.removeEnd((String)origAoOptions, (String)"]");
                    tableToolsColumnOptions.append("," + origAoOptions);
                }
                tableToolsColumnOptions.append("]");
                this.getTemplateOptions().put("aoColumnDefs", tableToolsColumnOptions.toString());
            }
        }
    }

    protected String getDataFieldColumnOptions(int target, CollectionGroup collectionGroup, DataField field) {
        Control control;
        String sortType = null;
        sortType = !collectionGroup.isReadOnly() && field instanceof InputField && ((InputField)field).getControl() != null ? ((control = ((InputField)field).getControl()) instanceof SelectControl ? "dom-select" : (control instanceof CheckboxControl || control instanceof CheckboxGroupControl ? "dom-checkbox" : (control instanceof RadioGroupControl ? "dom-radio" : "dom-text"))) : "dom-text";
        Class<?> dataTypeClass = ObjectPropertyUtils.getPropertyType(collectionGroup.getCollectionObjectClass(), field.getPropertyName());
        boolean isSortable = true;
        if (field.isApplyMask()) {
            isSortable = false;
        }
        return this.constructTableColumnOptions(target, isSortable, collectionGroup.isUseServerPaging(), dataTypeClass, sortType);
    }

    public String constructTableColumnOptions(int target, boolean isSortable, boolean isUseServerPaging, Class<?> dataTypeClass, String sortDataType) {
        String colOptions = "null";
        String sortType = "";
        if (!isSortable || dataTypeClass == null || sortType == null) {
            colOptions = "\"bSortable\" : false, \"sType\" : \"string\"";
        } else {
            sortType = ClassUtils.isAssignable(dataTypeClass, KualiPercent.class) ? "kuali_percent" : (ClassUtils.isAssignable(dataTypeClass, KualiInteger.class) || ClassUtils.isAssignable(dataTypeClass, KualiDecimal.class) ? "kuali_currency" : (ClassUtils.isAssignable(dataTypeClass, Timestamp.class) ? "date" : (ClassUtils.isAssignable(dataTypeClass, Date.class) || ClassUtils.isAssignable(dataTypeClass, java.util.Date.class) ? "kuali_date" : (ClassUtils.isAssignable(dataTypeClass, Number.class) ? "numeric" : "string"))));
            colOptions = "\"sType\" : \"" + sortType + "\"";
            if (!isUseServerPaging && !this.forceLocalJsonData) {
                colOptions = colOptions + ", \"sSortDataType\" : \"" + sortDataType + "\"";
            }
        }
        if (target < this.cellCssClasses.size() && target >= 0) {
            colOptions = colOptions + ", \"sClass\" : \"" + this.cellCssClasses.get(target) + "\"";
        }
        if (isUseServerPaging || this.forceLocalJsonData) {
            colOptions = colOptions + ", \"mDataProp\" : function(row,type,newVal){ return _handleColData(row,type,'c" + target + "',newVal);}";
        }
        colOptions = !colOptions.equals("null") ? "{" + colOptions + ", \"" + "aTargets" + "\": [" + target + "]}" : "{" + colOptions + "}";
        return colOptions;
    }

    @BeanTagAttribute(name="emptyTableMessage")
    public String getEmptyTableMessage() {
        return this.emptyTableMessage;
    }

    public void setEmptyTableMessage(String emptyTableMessage) {
        this.emptyTableMessage = emptyTableMessage;
    }

    @BeanTagAttribute(name="disableTableSort")
    public boolean isDisableTableSort() {
        return this.disableTableSort;
    }

    public void setDisableTableSort(boolean disableTableSort) {
        this.disableTableSort = disableTableSort;
    }

    @BeanTagAttribute(name="showSearchAndExportOptions")
    public boolean isShowSearchAndExportOptions() {
        return this.showSearchAndExportOptions;
    }

    @BeanTagAttribute(name="showSearchOption")
    public boolean isShowSearchOption() {
        return this.showSearchOption;
    }

    @BeanTagAttribute(name="showExportOption")
    public boolean isShowExportOption() {
        return this.showExportOption;
    }

    public void setShowSearchAndExportOptions(boolean showSearchAndExportOptions) {
        this.showSearchAndExportOptions = showSearchAndExportOptions;
    }

    public void setShowSearchOption(boolean showSearchOption) {
        this.showSearchOption = showSearchOption;
    }

    public void setShowExportOption(boolean showExportOption) {
        this.showExportOption = showExportOption;
    }

    @BeanTagAttribute(name="hiddenColumns", type=BeanTagAttribute.AttributeType.SETVALUE)
    public Set<String> getHiddenColumns() {
        return this.hiddenColumns;
    }

    public void setHiddenColumns(Set<String> hiddenColumns) {
        this.hiddenColumns = hiddenColumns;
    }

    @BeanTagAttribute(name="sortableColumns", type=BeanTagAttribute.AttributeType.SETVALUE)
    public Set<String> getSortableColumns() {
        return this.sortableColumns;
    }

    public void setSortableColumns(Set<String> sortableColumns) {
        this.sortableColumns = sortableColumns;
    }

    @BeanTagAttribute(name="ajaxSource")
    public String getAjaxSource() {
        return this.ajaxSource;
    }

    public void setAjaxSource(String ajaxSource) {
        this.ajaxSource = ajaxSource;
    }

    public String getGroupingOptionsJSString() {
        return this.groupingOptionsJSString;
    }

    public void setGroupingOptionsJSString(String groupingOptionsJSString) {
        this.groupingOptionsJSString = groupingOptionsJSString;
    }

    public boolean isForceAoColumnDefsOverride() {
        return this.forceAoColumnDefsOverride;
    }

    public void setForceAoColumnDefsOverride(boolean forceAoColumnDefsOverride) {
        this.forceAoColumnDefsOverride = forceAoColumnDefsOverride;
    }

    public boolean isForceLocalJsonData() {
        return this.forceLocalJsonData;
    }

    public void setForceLocalJsonData(boolean forceLocalJsonData) {
        this.forceLocalJsonData = forceLocalJsonData;
    }

    public int getNestedLevel() {
        return this.nestedLevel;
    }

    public void setNestedLevel(int nestedLevel) {
        this.nestedLevel = nestedLevel;
    }

    public String getAaData() {
        return this.aaData;
    }

    public void setAaData(String aaData) {
        this.aaData = aaData;
    }

    public String getCellValue(Object model, Field field) {
        String value = KRADUtils.getSimpleFieldValue(model, field);
        value = value == null ? "null" : "@quot@" + value + "@quot@";
        return value;
    }

    public void addRowToTableData(String row) {
        String escape = "";
        for (int i = 0; i < this.nestedLevel && this.forceLocalJsonData; ++i) {
            escape = escape + "\\";
        }
        row = row.trim().replace("\"", escape + "\\u0022").replace("'", escape + "\\u0027").replace("\n", "").replace("\r", "");
        row = StringUtils.removeEnd((String)row, (String)",");
        row = row.replace("@quot@", "\"");
        row = "{" + row + "}";
        if (StringUtils.isBlank((String)this.aaData)) {
            this.aaData = "[" + row + "]";
            Map<String, String> oTemplateOptions = this.getTemplateOptions();
            if (oTemplateOptions == null) {
                oTemplateOptions = new HashMap<String, String>();
                this.setTemplateOptions(oTemplateOptions);
            }
            if (oTemplateOptions.get("bDeferRender") == null) {
                oTemplateOptions.put("bDeferRender", "true");
            }
        } else if (StringUtils.isNotBlank((String)row)) {
            this.aaData = this.aaData.substring(0, this.aaData.length() - 1) + "," + row + "]";
        }
        if (this.forceLocalJsonData) {
            Map<String, String> oTemplateOptions = this.getTemplateOptions();
            if (oTemplateOptions == null) {
                oTemplateOptions = new HashMap<String, String>();
                this.setTemplateOptions(oTemplateOptions);
            }
            this.getTemplateOptions().put("aaData", this.aaData);
        }
    }

    protected ConfigurationService getConfigurationService() {
        return CoreApiServiceLocator.getKualiConfigurationService();
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        RichTable richTableCopy = (RichTable)component;
        richTableCopy.setEmptyTableMessage(this.getEmptyTableMessage());
        richTableCopy.setDisableTableSort(this.isDisableTableSort());
        richTableCopy.setForceAoColumnDefsOverride(this.isForceAoColumnDefsOverride());
        richTableCopy.setForceLocalJsonData(this.isForceLocalJsonData());
        richTableCopy.setNestedLevel(this.getNestedLevel());
        richTableCopy.setAaData(this.getAaData());
        if (this.hiddenColumns != null) {
            richTableCopy.setHiddenColumns(new HashSet<String>(this.hiddenColumns));
        }
        if (this.sortableColumns != null) {
            richTableCopy.setSortableColumns(new HashSet<String>(this.sortableColumns));
        }
        if (this.cellCssClasses != null) {
            richTableCopy.setCssClasses(new ArrayList<String>(this.cellCssClasses));
        }
        richTableCopy.setAjaxSource(this.getAjaxSource());
        richTableCopy.setShowSearchAndExportOptions(this.isShowSearchAndExportOptions());
        richTableCopy.setShowSearchOption(this.isShowSearchOption());
        richTableCopy.setShowExportOption(this.isShowExportOption());
        richTableCopy.setGroupingOptionsJSString(this.getGroupingOptionsJSString());
    }
}

