/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.widget;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.WidgetBase;

@BeanTag(name="scrollpane-bean", parent="Uif-Scrollpane")
public class Scrollpane
extends WidgetBase {
    private static final long serialVersionUID = 3853028195825084261L;
    private String height;

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        this.buildCSSforScrollPane(parent);
    }

    private void buildCSSforScrollPane(Component parent) {
        LayoutManager layoutManager = ((Group)parent).getLayoutManager();
        if (StringUtils.isNotBlank((String)this.getHeight())) {
            if (!StringUtils.contains((String)layoutManager.getStyle(), (String)"height: ")) {
                layoutManager.appendToStyle("height: " + this.getHeight() + ";");
            }
            if (!StringUtils.contains((String)layoutManager.getStyle(), (String)"overflow: ")) {
                layoutManager.appendToStyle("overflow: auto;");
            }
        }
    }

    @BeanTagAttribute(name="height")
    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        Scrollpane scrollpaneCopy = (Scrollpane)component;
        scrollpaneCopy.setHeight(this.getHeight());
    }
}

