/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.util.Truth;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.web.format.BooleanFormatter;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.messages.MessageService;
import org.kuali.rice.krad.service.DataObjectMetaDataService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Image;
import org.kuali.rice.krad.uif.element.Link;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.ActionField;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.ImageField;
import org.kuali.rice.krad.uif.field.LinkField;
import org.kuali.rice.krad.uif.field.MessageField;
import org.kuali.rice.krad.uif.field.SpaceField;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.ViewModelUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.util.Assert;

public final class KRADUtils {
    private static KualiModuleService kualiModuleService;
    private static final KualiDecimal ONE_HUNDRED;

    private KRADUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static final String getBusinessTitleForClass(Class<? extends Object> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("The getBusinessTitleForClass method of KRADUtils requires a non-null class");
        }
        String className = clazz.getSimpleName();
        StringBuffer label = new StringBuffer(className.substring(0, 1));
        for (int i = 1; i < className.length(); ++i) {
            if (Character.isLowerCase(className.charAt(i))) {
                label.append(className.charAt(i));
                continue;
            }
            label.append(" ").append(className.charAt(i));
        }
        return label.toString().trim();
    }

    public static final List<String> getFileNameFromPath(List<String> fullFileNames) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        for (String fullFileName : fullFileNames) {
            if (StringUtils.contains((String)fullFileName, (String)"/")) {
                fileNameList.add(StringUtils.substringAfterLast((String)fullFileName, (String)"/"));
                continue;
            }
            fileNameList.add(StringUtils.substringAfterLast((String)fullFileName, (String)"\\"));
        }
        return fileNameList;
    }

    public static final String convertDecimalIntoInteger(KualiDecimal decimalNumber) {
        KualiDecimal decimalAmount = (KualiDecimal)decimalNumber.multiply((AbstractKualiDecimal)ONE_HUNDRED);
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        String formattedAmount = formatter.format(decimalAmount);
        return StringUtils.replace((String)formattedAmount, (String)",", (String)"");
    }

    public static Integer getIntegerValue(String numberStr) {
        Integer numberInt = null;
        try {
            numberInt = new Integer(numberStr);
        }
        catch (NumberFormatException nfe) {
            Double numberDbl = new Double(numberStr);
            numberInt = new Integer(numberDbl.intValue());
        }
        return numberInt;
    }

    public static Object hydrateAttributeValue(Class<?> propertyType, String attributeValue) {
        Object attributeValueObject = null;
        if (propertyType != null && attributeValue != null) {
            attributeValueObject = String.class.equals(propertyType) ? attributeValue : (Boolean.class.equals(propertyType) || Boolean.TYPE.equals(propertyType) ? Truth.strToBooleanIgnoreCase((String)attributeValue) : KRADUtils.createObject(propertyType, new Class[]{String.class}, new Object[]{attributeValue}));
        }
        return attributeValueObject;
    }

    public static Object createObject(Class<?> clazz, Class<?>[] argumentClasses, Object[] argumentValues) {
        if (clazz == null) {
            return null;
        }
        if (argumentClasses.length == 1 && argumentClasses[0] == String.class && argumentValues.length == 1 && argumentValues[0] != null) {
            if (clazz == String.class) {
                return argumentValues[0];
            }
            Method valueOfMethod = null;
            try {
                valueOfMethod = clazz.getMethod("valueOf", String.class);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (valueOfMethod != null) {
                try {
                    return valueOfMethod.invoke(null, argumentValues[0]);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(argumentClasses);
            return constructor.newInstance(argumentValues);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String joinWithQuotes(List<String> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        return "'" + StringUtils.join(list.iterator(), (String)"','") + "'";
    }

    private static KualiModuleService getKualiModuleService() {
        if (kualiModuleService == null) {
            kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return kualiModuleService;
    }

    public static String getNamespaceCode(Class<? extends Object> clazz) {
        ModuleService moduleService = KRADUtils.getKualiModuleService().getResponsibleModuleService(clazz);
        if (moduleService == null) {
            return "KUALI";
        }
        return moduleService.getModuleConfiguration().getNamespaceCode();
    }

    public static Map<String, String> getNamespaceAndComponentSimpleName(Class<? extends Object> clazz) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("namespaceCode", KRADUtils.getNamespaceCode(clazz));
        map.put("componentName", KRADUtils.getComponentSimpleName(clazz));
        return map;
    }

    public static Map<String, String> getNamespaceAndComponentFullName(Class<? extends Object> clazz) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("namespaceCode", KRADUtils.getNamespaceCode(clazz));
        map.put("componentName", KRADUtils.getComponentFullName(clazz));
        return map;
    }

    public static Map<String, String> getNamespaceAndActionClass(Class<? extends Object> clazz) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("namespaceCode", KRADUtils.getNamespaceCode(clazz));
        map.put("actionClass", clazz.getName());
        return map;
    }

    private static String getComponentSimpleName(Class<? extends Object> clazz) {
        return clazz.getSimpleName();
    }

    private static String getComponentFullName(Class<? extends Object> clazz) {
        return clazz.getName();
    }

    public static Map<String, String> convertStringParameterToMap(String parameter) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)parameter)) {
            if (StringUtils.contains((String)parameter, (String)",")) {
                String[] fieldConversions = StringUtils.split((String)parameter, (String)",");
                for (int i = 0; i < fieldConversions.length; ++i) {
                    String fieldConversionStr = fieldConversions[i];
                    if (!StringUtils.isNotBlank((String)fieldConversionStr)) continue;
                    if (StringUtils.contains((String)fieldConversionStr, (String)":")) {
                        String[] fieldConversion = StringUtils.split((String)fieldConversionStr, (String)":");
                        map.put(fieldConversion[0], fieldConversion[1]);
                        continue;
                    }
                    map.put(fieldConversionStr, fieldConversionStr);
                }
            } else if (StringUtils.contains((String)parameter, (String)":")) {
                String[] fieldConversion = StringUtils.split((String)parameter, (String)":");
                map.put(fieldConversion[0], fieldConversion[1]);
            } else {
                map.put(parameter, parameter);
            }
        }
        return map;
    }

    public static List<String> convertStringParameterToList(String parameter) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)parameter)) {
            if (StringUtils.contains((String)parameter, (String)",")) {
                String[] parameters = StringUtils.split((String)parameter, (String)",");
                List<String> arraysList = Arrays.asList(parameters);
                list.addAll(arraysList);
            } else {
                list.add(parameter);
            }
        }
        return list;
    }

    public static String translateToMapSafeKey(String key) {
        String safeKey = key;
        safeKey = StringUtils.replace((String)safeKey, (String)"[", (String)"_");
        safeKey = StringUtils.replace((String)safeKey, (String)"]", (String)"_");
        return safeKey;
    }

    public static String buildMapParameterString(Map<String, String> map) {
        String parameterString = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (StringUtils.isNotBlank((String)parameterString)) {
                parameterString = parameterString + ",";
            }
            parameterString = parameterString + entry.getKey() + ":" + entry.getValue();
        }
        return parameterString;
    }

    public static Map<String, String> getMapFromParameterString(String parameterString) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] entries = parameterString.split(",");
        for (int i = 0; i < entries.length; ++i) {
            Object[] keyValue = entries[i].split(":");
            if (keyValue.length != 2) {
                throw new RuntimeException("malformed field conversion pair: " + Arrays.toString(keyValue));
            }
            map.put(keyValue[0], keyValue[1]);
        }
        return map;
    }

    public static Boolean getRequestParameterAsBoolean(ServletRequest request, String parameterName) {
        Boolean parameterValue = null;
        String parameterValueStr = request.getParameter(parameterName);
        if (StringUtils.isNotBlank((String)parameterValueStr)) {
            parameterValue = (Boolean)new BooleanFormatter().convertFromPresentationFormat((Object)parameterValueStr);
        }
        return parameterValue;
    }

    public static Map<String, String> translateRequestParameterMap(Map<String, String[]> requestParameters) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (Map.Entry<String, String[]> parameter : requestParameters.entrySet()) {
            String parameterValue = "";
            parameterValue = parameter.getValue().length > 1 ? StringUtils.join((Object[])parameter.getValue(), (String)"|") : parameter.getValue()[0];
            parameters.put(parameter.getKey(), parameterValue);
        }
        return parameters;
    }

    public static Map<String, String> getParametersFromRequest(List<String> parameterNames, Class<?> parentObjectClass, Map<String, String> requestParameters) {
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        for (String keyPropertyName : parameterNames) {
            if (requestParameters.get(keyPropertyName) == null) continue;
            String keyValue = requestParameters.get(keyPropertyName);
            if (KRADServiceLocatorWeb.getDataObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(parentObjectClass, keyPropertyName)) {
                try {
                    keyValue = StringUtils.removeEnd((String)keyValue, (String)"(&^#&)");
                    keyValue = CoreApiServiceLocator.getEncryptionService().decrypt(keyValue);
                }
                catch (GeneralSecurityException e) {
                    throw new RuntimeException(e);
                }
            }
            parameterValues.put(keyPropertyName, keyValue);
        }
        return parameterValues;
    }

    public static Map<String, String> getPropertyKeyValuesFromDataObject(List<String> propertyNames, Object dataObject) {
        return KRADUtils.getPropertyKeyValuesFromDataObject(propertyNames, Collections.<String>emptyList(), dataObject);
    }

    public static Map<String, String> getPropertyKeyValuesFromDataObject(List<String> propertyNames, List<String> securePropertyNames, Object dataObject) {
        HashMap<String, String> propertyKeyValues = new HashMap<String, String>();
        if (dataObject == null) {
            return propertyKeyValues;
        }
        for (String propertyName : propertyNames) {
            Object propertyValue = ObjectPropertyUtils.getPropertyValue(dataObject, propertyName);
            if (propertyValue == null) {
                propertyValue = "";
            }
            if (KRADUtils.isSecure(propertyName, securePropertyNames, dataObject, propertyValue)) continue;
            propertyKeyValues.put(propertyName, propertyValue.toString());
        }
        return propertyKeyValues;
    }

    private static boolean isSecure(String propertyName, List<String> securePropertyNames, Object dataObject, Object propertyValue) {
        if (propertyValue instanceof String && KRADUtils.containsSensitiveDataPatternMatch((String)propertyValue)) {
            return true;
        }
        if (KRADUtils.containsSecurePropertyName(propertyName, securePropertyNames)) {
            return true;
        }
        return KRADServiceLocatorWeb.getDataObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(dataObject.getClass(), propertyName);
    }

    private static boolean containsSecurePropertyName(String propertyName, List<String> securePropertyNames) {
        if (securePropertyNames == null) {
            return false;
        }
        for (String securePropertyName : securePropertyNames) {
            if (!Pattern.compile("(?:\\.|^)" + Pattern.quote(securePropertyName) + "(?:\\.|\\[|$)").matcher(propertyName).find()) continue;
            return true;
        }
        return false;
    }

    public static Properties convertMapToProperties(Map<String, String> parameters) {
        Properties properties = new Properties();
        if (parameters != null) {
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                properties.put(parameter.getKey(), parameter.getValue());
            }
        }
        return properties;
    }

    public static Properties convertRequestMapToProperties(Map<String, String[]> requestParameters) {
        Properties properties = new Properties();
        if (requestParameters != null) {
            for (Map.Entry<String, String[]> parameter : requestParameters.entrySet()) {
                Object[] parameterValue = parameter.getValue();
                String parameterValueString = StringUtils.join((Object[])parameterValue, (String)",");
                properties.put(parameter.getKey(), parameterValueString);
            }
        }
        return properties;
    }

    public static boolean containsSensitiveDataPatternMatch(String fieldValue) {
        if (StringUtils.isBlank((String)fieldValue)) {
            return false;
        }
        ParameterService parameterService = CoreFrameworkServiceLocator.getParameterService();
        Collection sensitiveDataPatterns = parameterService.getParameterValuesAsString("KR-NS", "All", "SENSITIVE_DATA_PATTERNS");
        for (String pattern : sensitiveDataPatterns) {
            if (!Pattern.compile(pattern).matcher(fieldValue).find()) continue;
            return true;
        }
        return false;
    }

    public static String stripXSSPatterns(String value) {
        if (value == null) {
            return null;
        }
        value = value.replaceAll("", "");
        Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
        value = scriptPattern.matcher(value).replaceAll("");
        scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42);
        value = scriptPattern.matcher(value).replaceAll("");
        scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42);
        value = scriptPattern.matcher(value).replaceAll("");
        scriptPattern = Pattern.compile("</script>", 2);
        value = scriptPattern.matcher(value).replaceAll("");
        scriptPattern = Pattern.compile("<script(.*?)>", 42);
        value = scriptPattern.matcher(value).replaceAll("");
        scriptPattern = Pattern.compile("eval\\((.*?)\\)", 42);
        value = scriptPattern.matcher(value).replaceAll("");
        scriptPattern = Pattern.compile("expression\\((.*?)\\)", 42);
        value = scriptPattern.matcher(value).replaceAll("");
        scriptPattern = Pattern.compile("javascript:", 2);
        value = scriptPattern.matcher(value).replaceAll("");
        scriptPattern = Pattern.compile("vbscript:", 2);
        value = scriptPattern.matcher(value).replaceAll("");
        scriptPattern = Pattern.compile("onload(.*?)=", 42);
        value = scriptPattern.matcher(value).replaceAll("");
        return value;
    }

    public static final UserSession getUserSessionFromRequest(HttpServletRequest request) {
        return (UserSession)request.getSession().getAttribute("UserSession");
    }

    public static boolean isProductionEnvironment() {
        return CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("production.environment.code").equalsIgnoreCase(CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("environment"));
    }

    public static String getMessageText(ErrorMessage errorMessage, boolean processPrefixSuffix) {
        String message = "";
        if (errorMessage != null && errorMessage.getErrorKey() != null) {
            MessageService messageService = KRADServiceLocatorWeb.getMessageService();
            message = messageService.getMessageText(errorMessage.getNamespaceCode(), errorMessage.getComponentCode(), errorMessage.getErrorKey());
            if (message == null) {
                message = "Intended message with key: " + errorMessage.getErrorKey() + " not found.";
            }
            if (errorMessage.getMessageParameters() != null && StringUtils.isNotBlank((String)message)) {
                message = message.replace("'", "''");
                message = MessageFormat.format(message, errorMessage.getMessageParameters());
            }
            if (StringUtils.isNotBlank((String)errorMessage.getMessagePrefixKey()) && processPrefixSuffix) {
                String prefix = messageService.getMessageText(errorMessage.getNamespaceCode(), errorMessage.getComponentCode(), errorMessage.getMessagePrefixKey());
                if (errorMessage.getMessagePrefixParameters() != null && StringUtils.isNotBlank((String)prefix)) {
                    prefix = prefix.replace("'", "''");
                    prefix = MessageFormat.format(prefix, errorMessage.getMessagePrefixParameters());
                }
                if (StringUtils.isNotBlank((String)prefix)) {
                    message = prefix + " " + message;
                }
            }
            if (StringUtils.isNotBlank((String)errorMessage.getMessageSuffixKey()) && processPrefixSuffix) {
                String suffix = messageService.getMessageText(errorMessage.getNamespaceCode(), errorMessage.getComponentCode(), errorMessage.getMessageSuffixKey());
                if (errorMessage.getMessageSuffixParameters() != null && StringUtils.isNotBlank((String)suffix)) {
                    suffix = suffix.replace("'", "''");
                    suffix = MessageFormat.format(suffix, errorMessage.getMessageSuffixParameters());
                }
                if (StringUtils.isNotBlank((String)suffix)) {
                    message = message + " " + suffix;
                }
            }
        }
        return message;
    }

    public static String getRequestStringFromMap(Map<String, String> requestParameters) {
        String requestString = "";
        if (requestParameters.isEmpty()) {
            return requestString;
        }
        URLCodec urlCodec = new URLCodec("UTF-8");
        for (String key : requestParameters.keySet()) {
            String value = null;
            try {
                value = urlCodec.encode(requestParameters.get(key));
            }
            catch (EncoderException e) {
                throw new RuntimeException("Unable to encode parameter name or value: " + key + "=" + value, e);
            }
            if (StringUtils.isNotBlank((String)requestString)) {
                requestString = requestString + "&";
            }
            requestString = requestString + key + "=" + value;
        }
        return "?" + requestString;
    }

    public static String buildViewUrl(String baseUrl, String controllerMapping, String viewId) {
        Assert.hasLength((String)baseUrl, (String)"base url is null or empty");
        Assert.hasLength((String)controllerMapping, (String)"controller mapping is null or empty");
        Assert.hasLength((String)viewId, (String)"view id is null or empty");
        StringBuffer url = new StringBuffer();
        url.append(baseUrl);
        if (!baseUrl.endsWith("/")) {
            url.append("/");
        }
        url.append(controllerMapping);
        url.append("?");
        url.append("viewId");
        url.append("=");
        url.append(viewId);
        return url.toString();
    }

    public static void cleanRequestParameters(Properties requestParameters) {
        requestParameters.remove("sessionId");
        requestParameters.remove("ajaxRequest");
        requestParameters.remove("ajaxReturnType");
        requestParameters.remove("formKey");
        requestParameters.remove("jumpToId");
        requestParameters.remove("focusId");
    }

    public static String getFullURL(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        StringBuffer requestURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString == null) {
            return requestURL.toString();
        }
        return requestURL.append('?').append(queryString).toString();
    }

    public static String generateUniqueViewTitle(UifFormBase form, View view) {
        String title = view.getHeader().getHeaderText();
        String viewLabelPropertyName = "";
        Class<?> dataObjectClass = StringUtils.isNotBlank((String)view.getDefaultBindingObjectPath()) ? ObjectPropertyUtils.getPropertyType(form, view.getDefaultBindingObjectPath()) : view.getFormClass();
        DataObjectMetaDataService mds = KRADServiceLocatorWeb.getDataObjectMetaDataService();
        if (dataObjectClass != null) {
            viewLabelPropertyName = mds.getTitleAttribute(dataObjectClass);
        }
        String viewLabelPropertyPath = "";
        if (StringUtils.isNotBlank((String)viewLabelPropertyName)) {
            if (!viewLabelPropertyName.startsWith("#form.")) {
                if (StringUtils.isNotBlank((String)view.getDefaultBindingObjectPath())) {
                    viewLabelPropertyPath = view.getDefaultBindingObjectPath() + "." + viewLabelPropertyName;
                }
            } else {
                viewLabelPropertyPath = StringUtils.removeStart((String)viewLabelPropertyName, (String)"#form.");
            }
        } else {
            String titleAttribute;
            dataObjectClass = StringUtils.isNotBlank((String)view.getDefaultBindingObjectPath()) ? ViewModelUtils.getObjectClassForMetadata(view, form, view.getDefaultBindingObjectPath()) : view.getFormClass();
            if (dataObjectClass != null && StringUtils.isNotBlank((String)(titleAttribute = mds.getTitleAttribute(dataObjectClass)))) {
                viewLabelPropertyPath = view.getDefaultBindingObjectPath() + "." + titleAttribute;
            }
        }
        Object viewLabelPropertyValue = null;
        if (StringUtils.isNotBlank((String)viewLabelPropertyPath) && ObjectPropertyUtils.isReadableProperty(form, viewLabelPropertyPath)) {
            viewLabelPropertyValue = ObjectPropertyUtils.getPropertyValue(form, viewLabelPropertyPath);
        }
        if (viewLabelPropertyValue != null && StringUtils.isNotBlank((String)viewLabelPropertyValue.toString()) && StringUtils.isNotBlank((String)title)) {
            return title + " (" + viewLabelPropertyValue.toString() + ")";
        }
        return title;
    }

    public static String getSimpleFieldValue(Object model, Field field) {
        if (field == null) {
            return null;
        }
        String value = null;
        if (field instanceof DataField) {
            String propertyPath = ((DataField)field).getBindingInfo().getBindingPath();
            Object valueObject = null;
            if (field.isHidden()) {
                return "";
            }
            if (ObjectPropertyUtils.isReadableProperty(model, propertyPath)) {
                valueObject = ObjectPropertyUtils.getPropertyValue(model, propertyPath);
            }
            if (valueObject != null && !((DataField)field).isApplyMask()) {
                value = valueObject.toString();
            } else if (valueObject != null && ((DataField)field).isApplyMask()) {
                value = ((DataField)field).getMaskFormatter().maskValue(valueObject);
            }
        } else if (field instanceof ActionField) {
            value = ((ActionField)field).getActionLabel();
            if (StringUtils.isBlank((String)value) && ((ActionField)field).getActionImage() != null) {
                value = ((ActionField)field).getActionImage().getAltText();
            }
        } else if (field instanceof LinkField) {
            value = ((LinkField)field).getLinkText();
        } else if (field instanceof ImageField) {
            value = ((ImageField)field).getAltText();
        } else if (field instanceof MessageField && ((MessageField)field).getMessage() != null) {
            value = ((MessageField)field).getMessage().getMessageText();
        } else if (field instanceof SpaceField) {
            value = "";
        } else if (field instanceof FieldGroup && ((FieldGroup)field).getGroup() != null && ((FieldGroup)field).getGroup().getItems() != null && !((FieldGroup)field).getGroup().getItems().isEmpty()) {
            Component firstComponent = ((FieldGroup)field).getGroup().getItems().get(0);
            value = firstComponent != null && firstComponent instanceof Field ? KRADUtils.getSimpleFieldValue(model, field) : (firstComponent instanceof Action && StringUtils.isNotBlank((String)((Action)firstComponent).getActionLabel()) ? ((Action)firstComponent).getActionLabel() : (firstComponent instanceof Action && ((Action)firstComponent).getActionImage() != null ? ((Action)firstComponent).getActionImage().getAltText() : (firstComponent instanceof Link ? ((Link)firstComponent).getLinkText() : (firstComponent instanceof Image ? ((Image)firstComponent).getAltText() : (firstComponent instanceof Message ? ((Message)firstComponent).getMessageText() : null)))));
        }
        return value;
    }

    public static String convertToHTMLAttributeSafeString(String message) {
        if (StringUtils.isBlank((String)message)) {
            return message;
        }
        if (message.contains("\"")) {
            message = message.replace("\"", "&quot;");
        }
        if (message.contains("'")) {
            message = message.replace("'", "&#39;");
        }
        if (message.contains("\\")) {
            message = message.replace("\\", "&#92;");
        }
        return message;
    }

    public static String generateRowCssClassString(Map<String, String> conditionalRowCssClasses, int lineIndex, boolean isOdd, Map<String, Object> lineContext, ExpressionEvaluator expressionEvaluator) {
        String rowCss = "";
        if (conditionalRowCssClasses == null || conditionalRowCssClasses.isEmpty()) {
            return rowCss;
        }
        for (String cssRule : conditionalRowCssClasses.keySet()) {
            if (cssRule.startsWith("@{") && lineContext != null && expressionEvaluator != null) {
                String outcome = expressionEvaluator.evaluateExpressionTemplate(lineContext, cssRule);
                if (outcome == null || !Boolean.parseBoolean(outcome)) continue;
                rowCss = rowCss + " " + conditionalRowCssClasses.get(cssRule);
                continue;
            }
            if (cssRule.equals("all")) {
                rowCss = rowCss + " " + conditionalRowCssClasses.get(cssRule);
                continue;
            }
            if (cssRule.equals("even") && !isOdd) {
                rowCss = rowCss + " " + conditionalRowCssClasses.get(cssRule);
                continue;
            }
            if (cssRule.equals("odd") && isOdd) {
                rowCss = rowCss + " " + conditionalRowCssClasses.get(cssRule);
                continue;
            }
            if (!StringUtils.isNumeric((String)cssRule) || lineIndex + 1 != Integer.parseInt(cssRule)) continue;
            rowCss = rowCss + " " + conditionalRowCssClasses.get(cssRule);
        }
        rowCss = StringUtils.removeStart((String)rowCss, (String)" ");
        return rowCss;
    }

    static {
        ONE_HUNDRED = new KualiDecimal("100.00");
    }
}

