/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.bind;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.web.format.FormatException;

public class UifDateEditor
extends PropertyEditorSupport
implements Serializable {
    private static final long serialVersionUID = 8122469337264797008L;
    private transient DateTimeService dateTimeService;

    @Override
    public String getAsText() {
        if (this.getValue() == null) {
            return null;
        }
        if ("".equals(this.getValue())) {
            return null;
        }
        return this.getDateTimeService().toDateString((Date)this.getValue());
    }

    protected DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = (DateTimeService)GlobalResourceLoader.getService((String)"dateTimeService");
        }
        return this.dateTimeService;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(this.convertToObject(text));
    }

    protected Object convertToObject(String text) throws IllegalArgumentException {
        try {
            if (text == null || text.equals("")) {
                return null;
            }
            java.sql.Date result = this.getDateTimeService().convertToSqlDate(text);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(result);
            if (calendar.get(1) < 1000 && this.verbatimYear(text).length() < 4) {
                throw new FormatException("illegal year format", "error.invalidDate", text);
            }
            return result;
        }
        catch (ParseException e) {
            throw new FormatException("parsing", "error.invalidDate", text, (Throwable)e);
        }
    }

    private String verbatimYear(String date) {
        String result = "";
        int pos = date.lastIndexOf("/");
        if (pos >= 0) {
            result = date.substring(pos);
        }
        return result;
    }
}

