/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.bind;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.view.ViewIndex;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.web.bind.UifEncryptionPropertyEditorWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyValue;
import org.springframework.util.StringUtils;

public class UifViewBeanWrapper
extends BeanWrapperImpl {
    private static Logger LOG = Logger.getLogger(UifViewBeanWrapper.class);
    private ViewModel model;
    private Set<String> processedProperties;

    public UifViewBeanWrapper(ViewModel model) {
        super((Object)model);
        this.model = model;
        this.processedProperties = new HashSet<String>();
    }

    protected void registerEditorFromView(String propertyName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Attempting to find property editor for property '" + propertyName + "'"));
        }
        if (this.processedProperties.contains(propertyName)) {
            return;
        }
        ViewIndex viewIndex = null;
        if (this.model.getView() != null) {
            viewIndex = this.model.getView().getViewIndex();
        } else if (this.model.getPostedView() != null) {
            viewIndex = this.model.getPostedView().getViewIndex();
        }
        if (viewIndex == null) {
            return;
        }
        PropertyEditor propertyEditor = null;
        boolean requiresEncryption = false;
        if (viewIndex.getFieldPropertyEditors().containsKey(propertyName)) {
            propertyEditor = viewIndex.getFieldPropertyEditors().get(propertyName);
        } else if (viewIndex.getSecureFieldPropertyEditors().containsKey(propertyName)) {
            propertyEditor = viewIndex.getSecureFieldPropertyEditors().get(propertyName);
            requiresEncryption = true;
        }
        if (propertyEditor != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Registering custom editor for property path '" + propertyName + "' and property editor class '" + propertyEditor.getClass().getName() + "'"));
            }
            if (requiresEncryption) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Enabling encryption for custom editor '" + propertyName + "' and property editor class '" + propertyEditor.getClass().getName() + "'"));
                }
                this.registerCustomEditor(null, propertyName, new UifEncryptionPropertyEditorWrapper(propertyEditor));
            } else {
                this.registerCustomEditor(null, propertyName, propertyEditor);
            }
        } else if (requiresEncryption) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No custom formatter for property path '" + propertyName + "' but property does require encryption"));
            }
            this.registerCustomEditor(null, propertyName, new UifEncryptionPropertyEditorWrapper(this.findEditorForPropertyName(propertyName)));
        }
        this.processedProperties.add(propertyName);
    }

    protected PropertyEditor findEditorForPropertyName(String propertyName) {
        PropertyEditor editor;
        Class<?> clazz = this.getPropertyType(propertyName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Attempting retrieval of property editor using class '" + clazz + "' and property path '" + propertyName + "'"));
        }
        if ((editor = this.findCustomEditor(clazz, propertyName)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No custom property editor found using class '" + clazz + "' and property path '" + propertyName + "'. Attempting to find default property editor class."));
            }
            editor = this.getDefaultEditor(clazz);
        }
        return editor;
    }

    public Class<?> getPropertyType(String propertyName) throws BeansException {
        try {
            PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
            if (pd != null) {
                return pd.getPropertyType();
            }
            Object value = super.getPropertyValue(propertyName);
            if (value != null) {
                return value.getClass();
            }
            Class editorType = this.guessPropertyTypeFromEditors(propertyName);
            if (editorType != null) {
                return editorType;
            }
        }
        catch (InvalidPropertyException invalidPropertyException) {
            // empty catch block
        }
        return null;
    }

    protected BeanWrapperImpl getBeanWrapperForPropertyPath(String propertyPath) {
        BeanWrapperImpl beanWrapper = super.getBeanWrapperForPropertyPath(propertyPath);
        PropertyTokenHolder tokens = this.getPropertyNameTokens(propertyPath);
        String canonicalName = tokens.canonicalName;
        int pos = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex((String)canonicalName);
        if (pos != -1) {
            canonicalName = canonicalName.substring(0, pos);
        }
        this.copyCustomEditorsTo((PropertyEditorRegistry)beanWrapper, canonicalName);
        return beanWrapper;
    }

    public Object getPropertyValue(String propertyName) throws BeansException {
        this.registerEditorFromView(propertyName);
        Object value = null;
        try {
            value = super.getPropertyValue(propertyName);
        }
        catch (NullValueInNestedPathException nullValueInNestedPathException) {
            // empty catch block
        }
        return value;
    }

    public void setPropertyValue(PropertyValue pv) throws BeansException {
        this.registerEditorFromView(pv.getName());
        if (pv != null && pv.getValue() instanceof String) {
            String propertyValue = (String)pv.getValue();
            if (propertyValue.endsWith("(&^#&)")) {
                propertyValue = org.apache.commons.lang.StringUtils.removeEnd((String)propertyValue, (String)"(&^#&)");
            }
            if (this.isSecure(pv.getName())) {
                try {
                    if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                        pv = new PropertyValue(pv, (Object)CoreApiServiceLocator.getEncryptionService().decrypt(propertyValue));
                    }
                }
                catch (GeneralSecurityException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        super.setPropertyValue(pv);
    }

    public void setPropertyValue(String propertyName, Object value) throws BeansException {
        this.registerEditorFromView(propertyName);
        if (value instanceof String) {
            String propertyValue = (String)value;
            if (propertyValue.endsWith("(&^#&)")) {
                propertyValue = org.apache.commons.lang.StringUtils.removeEnd((String)propertyValue, (String)"(&^#&)");
            }
            if (this.isSecure(propertyName)) {
                try {
                    if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                        value = CoreApiServiceLocator.getEncryptionService().decrypt(propertyValue);
                    }
                }
                catch (GeneralSecurityException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        super.setPropertyValue(propertyName, value);
    }

    public void setWrappedInstance(Object object, String nestedPath, Object rootObject) {
        this.model = (ViewModel)object;
        super.setWrappedInstance(object, nestedPath, rootObject);
    }

    public void setWrappedInstance(Object object) {
        this.model = (ViewModel)object;
        super.setWrappedInstance(object);
    }

    private PropertyTokenHolder getPropertyNameTokens(String propertyName) {
        PropertyTokenHolder tokens = new PropertyTokenHolder();
        String actualName = null;
        ArrayList<String> keys = new ArrayList<String>(2);
        int searchIndex = 0;
        while (searchIndex != -1) {
            String key;
            int keyEnd;
            int keyStart = propertyName.indexOf("[", searchIndex);
            searchIndex = -1;
            if (keyStart == -1 || (keyEnd = propertyName.indexOf("]", keyStart + "[".length())) == -1) continue;
            if (actualName == null) {
                actualName = propertyName.substring(0, keyStart);
            }
            if ((key = propertyName.substring(keyStart + "[".length(), keyEnd)).startsWith("'") && key.endsWith("'") || key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            keys.add(key);
            searchIndex = keyEnd + "]".length();
        }
        tokens.canonicalName = tokens.actualName = actualName != null ? actualName : propertyName;
        if (!keys.isEmpty()) {
            tokens.canonicalName = tokens.canonicalName + "[" + StringUtils.collectionToDelimitedString(keys, (String)"][") + "]";
            tokens.keys = StringUtils.toStringArray(keys);
        }
        return tokens;
    }

    private boolean isSecure(String propertyName) {
        return this.isSecure(this.getWrappedClass(), propertyName);
    }

    private boolean isSecure(Class<?> wrappedClass, String propertyPath) {
        BeanWrapperImpl beanWrapper;
        if (KRADServiceLocatorWeb.getDataObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(wrappedClass, propertyPath)) {
            return true;
        }
        try {
            beanWrapper = this.getBeanWrapperForPropertyPath(propertyPath);
        }
        catch (NotReadablePropertyException nrpe) {
            LOG.debug((Object)("Bean wrapper was not found for " + propertyPath + ", but since it cannot be accessed it will not be set as secure."), (Throwable)nrpe);
            return false;
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)beanWrapper.getNestedPath())) {
            PropertyTokenHolder tokens = this.getPropertyNameTokens(propertyPath);
            String nestedPropertyPath = org.apache.commons.lang.StringUtils.removeStart((String)tokens.canonicalName, (String)beanWrapper.getNestedPath());
            return this.isSecure(beanWrapper.getWrappedClass(), nestedPropertyPath);
        }
        return false;
    }

    private static class PropertyTokenHolder {
        public String canonicalName;
        public String actualName;
        public String[] keys;

        private PropertyTokenHolder() {
        }
    }
}

