/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.controller;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.lookup.LookupUtils;
import org.kuali.rice.krad.lookup.Lookupable;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.UrlFactory;
import org.kuali.rice.krad.web.controller.UifControllerBase;
import org.kuali.rice.krad.web.form.LookupForm;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/lookup"})
public class LookupController
extends UifControllerBase {
    private static final Logger LOG = Logger.getLogger(LookupController.class);

    @Override
    protected LookupForm createInitialForm(HttpServletRequest request) {
        return new LookupForm();
    }

    @Override
    @RequestMapping(params={"methodToCall=start"})
    public ModelAndView start(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        LookupForm lookupForm = (LookupForm)form;
        Lookupable lookupable = lookupForm.getLookupable();
        if (lookupable == null) {
            LOG.error((Object)"Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        lookupable.initSuppressAction(lookupForm);
        if (request.getParameter("messageToDisplay") != null) {
            lookupable.generateErrorMessageForResults(lookupForm, request.getParameter("messageToDisplay"));
        }
        if (!lookupForm.isRedirectedLookup()) {
            Class<?> lookupObjectClass = null;
            try {
                lookupObjectClass = Class.forName(lookupForm.getDataObjectClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RiceRuntimeException("Unable to get class for name: " + lookupForm.getDataObjectClassName());
            }
            ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(lookupObjectClass);
            if (responsibleModuleService != null && responsibleModuleService.isExternalizable(lookupObjectClass)) {
                String lookupUrl = responsibleModuleService.getExternalizableDataObjectLookupUrl(lookupObjectClass, KRADUtils.convertRequestMapToProperties(request.getParameterMap()));
                Properties redirectUrlProps = new Properties();
                redirectUrlProps.put("redirectedLookup", "true");
                GlobalVariables.getUifFormManager().removeSessionForm(form);
                return this.performRedirect(form, lookupUrl, redirectUrlProps);
            }
        }
        return super.start(lookupForm, result, request, response);
    }

    @Override
    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=cancel"})
    public ModelAndView cancel(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        LookupForm lookupForm = (LookupForm)form;
        Lookupable lookupable = lookupForm.getLookupable();
        if (lookupable == null) {
            LOG.error((Object)"Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        lookupable.initSuppressAction(lookupForm);
        Properties props = new Properties();
        props.put("methodToCall", "refresh");
        if (StringUtils.isNotBlank((String)lookupForm.getReturnFormKey())) {
            props.put("formKey", lookupForm.getReturnFormKey());
        }
        if (StringUtils.isNotBlank((String)lookupForm.getDocNum())) {
            props.put("docNum", lookupForm.getDocNum());
        }
        GlobalVariables.getUifFormManager().removeSessionForm(form);
        return this.performRedirect(lookupForm, lookupForm.getReturnLocation(), props);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=clearValues"})
    public ModelAndView clearValues(@ModelAttribute(value="KualiForm") LookupForm lookupForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        Lookupable lookupable = lookupForm.getLookupable();
        if (lookupable == null) {
            LOG.error((Object)"Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        lookupable.initSuppressAction(lookupForm);
        lookupForm.setLookupCriteria(lookupable.performClear(lookupForm, lookupForm.getLookupCriteria()));
        return this.getUIFModelAndView(lookupForm);
    }

    @RequestMapping(params={"methodToCall=search"})
    public ModelAndView search(@ModelAttribute(value="KualiForm") LookupForm lookupForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        Lookupable lookupable = lookupForm.getLookupable();
        if (lookupable == null) {
            LOG.error((Object)"Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        lookupable.initSuppressAction(lookupForm);
        Map<String, String> searchCriteria = LookupUtils.preprocessDateFields(lookupForm.getLookupCriteria());
        boolean searchValid = lookupable.validateSearchParameters(lookupForm, searchCriteria);
        if (searchValid) {
            Collection<?> displayList = lookupable.performSearch(lookupForm, searchCriteria, true);
            if (displayList instanceof CollectionIncomplete) {
                request.setAttribute("reqSearchResultsActualSize", (Object)((CollectionIncomplete)displayList).getActualSizeIfTruncated());
            } else {
                request.setAttribute("reqSearchResultsActualSize", (Object)new Integer(displayList.size()));
            }
            lookupForm.setLookupResults(displayList);
        }
        return this.getUIFModelAndView(lookupForm);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=returnSelected"})
    public String returnSelected(@ModelAttribute(value="KualiForm") LookupForm lookupForm, BindingResult result, HttpServletRequest request, HttpServletResponse response, RedirectAttributes redirectAttributes) {
        Properties parameters = new Properties();
        String selectedLineValues = "";
        Set<String> selectedLines = lookupForm.getSelectedCollectionLines().get("lookupResults");
        if (selectedLines != null) {
            for (String selectedLine : selectedLines) {
                selectedLineValues = selectedLineValues + selectedLine + ",";
            }
            selectedLineValues = StringUtils.removeEnd((String)selectedLineValues, (String)",");
        }
        parameters.put("selectedLineValues", selectedLineValues);
        parameters.putAll(lookupForm.getInitialRequestParameters());
        String redirectUrl = UrlFactory.parameterizeUrl((String)lookupForm.getReturnLocation(), (Properties)parameters);
        boolean lookupCameFromDifferentServer = this.areDifferentDomains(lookupForm.getReturnLocation(), lookupForm.getRequestUrl());
        if (redirectUrl.length() > 2048 && !lookupCameFromDifferentServer) {
            redirectAttributes.addFlashAttribute("selectedLineValues", (Object)selectedLineValues);
        }
        if (redirectUrl.length() > 2048 && lookupCameFromDifferentServer) {
            HashMap parms = (HashMap)lookupForm.getInitialRequestParameters();
            parms.remove("returnFormKey");
            redirectAttributes.mergeAttributes((Map)parms);
            redirectAttributes.addAttribute("messageToDisplay", (Object)"lookup.results.exceeds.mv.return.limit");
            String formKeyParam = request.getParameter("formKey");
            redirectAttributes.addAttribute("formKey", (Object)formKeyParam);
            return "redirect:" + lookupForm.getRequestUrl();
        }
        if (redirectUrl.length() < 2048) {
            redirectAttributes.addAttribute("selectedLineValues", (Object)selectedLineValues);
        }
        redirectAttributes.addAttribute("methodToCall", (Object)"refresh");
        if (StringUtils.isNotBlank((String)lookupForm.getReturnFormKey())) {
            redirectAttributes.addAttribute("formKey", (Object)lookupForm.getReturnFormKey());
        }
        redirectAttributes.addAttribute("refreshCaller", (Object)lookupForm.getView().getId());
        redirectAttributes.addAttribute("refreshCallerType", (Object)"MULTI_VALUE_LOOKUP");
        redirectAttributes.addAttribute("refreshDataObjectClass", (Object)lookupForm.getDataObjectClassName());
        if (StringUtils.isNotBlank((String)lookupForm.getDocNum())) {
            redirectAttributes.addAttribute("docNum", (Object)lookupForm.getDocNum());
        }
        if (StringUtils.isNotBlank((String)lookupForm.getLookupCollectionName())) {
            redirectAttributes.addAttribute("lookupCollectionName", (Object)lookupForm.getLookupCollectionName());
        }
        if (StringUtils.isNotBlank((String)lookupForm.getReferencesToRefresh())) {
            redirectAttributes.addAttribute("referencesToRefresh", (Object)lookupForm.getReferencesToRefresh());
        }
        GlobalVariables.getUifFormManager().removeSessionForm(lookupForm);
        return "redirect:" + lookupForm.getReturnLocation();
    }

    private boolean areDifferentDomains(String firstDomain, String secondDomain) {
        try {
            URL urlOne = new URL(firstDomain.toLowerCase());
            URL urlTwo = new URL(secondDomain.toLowerCase());
            if (urlOne.getHost().equals(urlTwo.getHost())) {
                LOG.debug((Object)("Hosts " + urlOne.getHost() + " of domains " + firstDomain + " and " + secondDomain + " were determined to be equal"));
                return false;
            }
            LOG.debug((Object)("Hosts " + urlOne.getHost() + " of domains " + firstDomain + " and " + secondDomain + " are not equal"));
            return true;
        }
        catch (MalformedURLException mue) {
            LOG.error((Object)("Unable to successfully compare domains " + firstDomain + " and " + secondDomain));
            return true;
        }
    }
}

