/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.service.ViewService;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.form.UifFormManager;
import org.springframework.web.servlet.ModelAndView;

public class UifControllerHelper {
    private static final Logger LOG = Logger.getLogger(UifControllerHelper.class);

    public static String getViewIdFromRequest(HttpServletRequest request) {
        String viewId = request.getParameter("viewId");
        if (StringUtils.isBlank((String)viewId)) {
            String viewTypeName = request.getParameter("viewTypeName");
            UifConstants.ViewType viewType = null;
            if (StringUtils.isNotBlank((String)viewTypeName)) {
                viewType = UifConstants.ViewType.valueOf(viewTypeName);
            }
            if (viewType != null) {
                Map<String, String> parameterMap = KRADUtils.translateRequestParameterMap(request.getParameterMap());
                viewId = UifControllerHelper.getViewService().getViewIdForViewType(viewType, parameterMap);
            }
        }
        if (StringUtils.isNotBlank((String)viewId)) {
            request.setAttribute("viewId", (Object)viewId);
        }
        return viewId;
    }

    public static ModelAndView getUIFModelAndView(UifFormBase form, String pageId) {
        if (StringUtils.isNotBlank((String)pageId)) {
            form.setPageId(pageId);
        }
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.addObject("KualiForm", (Object)form);
        modelAndView.setViewName("/krad/WEB-INF/ftl/uifRender");
        return modelAndView;
    }

    public static void postControllerHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (modelAndView == null) {
            return;
        }
        Object model = modelAndView.getModelMap().get((Object)"KualiForm");
        if (!(model instanceof UifFormBase)) {
            return;
        }
        UifFormBase form = (UifFormBase)model;
        if (!form.isRequestRedirected()) {
            String changeProperties;
            if (!form.isJsonRequest() && !form.isOriginalComponentRequest()) {
                UifControllerHelper.prepareViewForRendering(request, form);
            }
            Component component = null;
            if (StringUtils.isNotBlank((String)form.getUpdateComponentId())) {
                component = form.getPostedView().getViewIndex().getComponentById(form.getUpdateComponentId());
            } else if (form.isUpdatePageRequest()) {
                component = form.getView().getCurrentPage();
            }
            if (form.isOriginalComponentRequest()) {
                UifControllerHelper.updateViewTemplates(component, form);
            }
            if (StringUtils.isNotBlank((String)(changeProperties = request.getParameter("changeProperties"))) && component != null) {
                HashMap changePropertiesMap = (HashMap)new ObjectMapper().readValue(changeProperties, HashMap.class);
                for (String changePropertyPath : changePropertiesMap.keySet()) {
                    Object value = changePropertiesMap.get(changePropertyPath);
                    ObjectPropertyUtils.setPropertyValue(component, changePropertyPath, value);
                }
            }
            if (component != null) {
                modelAndView.addObject("Component", (Object)component);
            }
        }
        modelAndView.addObject("request", (Object)request);
        modelAndView.addObject("UserSession", request.getSession().getAttribute("UserSession"));
        Map properties = CoreApiServiceLocator.getKualiConfigurationService().getAllProperties();
        modelAndView.addObject("ConfigProperties", (Object)properties);
    }

    protected static void updateViewTemplates(Component currentComponent, UifFormBase form) {
        List<Component> components = ComponentUtils.getAllNestedComponents(currentComponent);
        components.add(currentComponent);
        for (Component component : components) {
            LayoutManager layoutManager;
            if (!component.isSelfRendered() && StringUtils.isNotBlank((String)component.getTemplate()) && !form.getPostedView().getViewTemplates().contains(component.getTemplate())) {
                form.getPostedView().getViewTemplates().add(component.getTemplate());
            }
            if (!(component instanceof Container) || (layoutManager = ((Container)component).getLayoutManager()) == null || form.getPostedView().getViewTemplates().contains(layoutManager.getTemplate())) continue;
            form.getPostedView().getViewTemplates().add(layoutManager.getTemplate());
        }
    }

    public static void prepareViewForRendering(HttpServletRequest request, UifFormBase form) {
        if (form.isUpdateComponentRequest() || form.isUpdateDialogRequest()) {
            String refreshComponentId = form.getUpdateComponentId();
            View postedView = form.getPostedView();
            boolean boxLayoutHorizontalItem = false;
            boolean boxLayoutVerticalItem = false;
            if (form.isUpdateComponentRequest()) {
                Component postedComponent = ComponentUtils.findNestedComponentById(postedView, refreshComponentId);
                if (postedComponent != null && postedComponent.getCssClasses() != null && postedComponent.getCssClasses().contains("uif-boxLayoutHorizontalItem")) {
                    boxLayoutHorizontalItem = true;
                } else if (postedComponent != null && postedComponent.getCssClasses() != null && postedComponent.getCssClasses().contains("uif-boxLayoutVerticalItem")) {
                    boxLayoutVerticalItem = true;
                }
            }
            Component comp = ComponentFactory.getNewInstanceForRefresh(form.getPostedView(), refreshComponentId);
            postedView.getViewHelperService().performComponentLifecycle(postedView, form, comp, refreshComponentId);
            if (boxLayoutHorizontalItem) {
                comp.addStyleClass("uif-boxLayoutHorizontalItem");
            } else if (boxLayoutVerticalItem) {
                comp.addStyleClass("uif-boxLayoutVerticalItem");
            }
            postedView.getCurrentPage().getValidationMessages().generateMessages(false, postedView, form, postedView.getCurrentPage());
        } else {
            View view = form.getView();
            if (StringUtils.isNotBlank((String)form.getPageId())) {
                view.setCurrentPageId(form.getPageId());
            }
            Map<String, String> parameterMap = KRADUtils.translateRequestParameterMap(request.getParameterMap());
            parameterMap.putAll(form.getViewRequestParameters());
            UifControllerHelper.getViewService().buildView(view, form, parameterMap);
        }
    }

    public static void removeUnusedBreadcrumbs(UifFormManager uifFormManager, String formKey, String lastFormKey) {
        if (StringUtils.isBlank((String)formKey) || StringUtils.isBlank((String)lastFormKey) || StringUtils.equals((String)formKey, (String)lastFormKey)) {
            return;
        }
        UifFormBase previousForm = uifFormManager.getSessionForm(lastFormKey);
        if (previousForm == null) {
            return;
        }
        uifFormManager.removeSessionFormByKey(lastFormKey);
    }

    protected static ViewService getViewService() {
        return KRADServiceLocatorWeb.getViewService();
    }
}

