/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.controller.helper;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.uif.util.ColumnSort;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.MultiColumnComparator;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.web.form.UifFormBase;

public class DataTablesPagingHelper {
    private int totalCollectionSize;
    private Integer filteredCollectionSize;
    private TableLayoutManager tableLayoutManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPagingRequest(View view, String tableId, UifFormBase form, DataTablesInputs dataTablesInputs) {
        form.setRequestJsonTemplate("dataTablesJson.ftl");
        if (view != null) {
            form.setUpdateComponentId(tableId);
            List oldColumnSorts = (List)form.getExtensionData().get(tableId + "_columnSorts");
            CollectionGroup newCollectionGroup = null;
            List modelCollection = null;
            List<ColumnSort> newColumnSorts = null;
            View view2 = view;
            synchronized (view2) {
                CollectionGroup oldCollectionGroup = (CollectionGroup)view.getViewIndex().getComponentById(tableId);
                newColumnSorts = this.buildColumnSorts(view, dataTablesInputs, oldCollectionGroup);
                modelCollection = (List)ObjectPropertyUtils.getPropertyValue(form, oldCollectionGroup.getBindingInfo().getBindingPath());
                this.applyTableJsonSort(modelCollection, oldColumnSorts, newColumnSorts, oldCollectionGroup, view);
                newCollectionGroup = (CollectionGroup)ComponentFactory.getNewInstanceForRefresh(form.getPostedView(), tableId);
                newCollectionGroup.setUseServerPaging(true);
                newCollectionGroup.setDisplayStart(dataTablesInputs.iDisplayStart);
                newCollectionGroup.setDisplayLength(dataTablesInputs.iDisplayLength);
                view.getViewHelperService().performComponentLifecycle(view, form, newCollectionGroup, oldCollectionGroup.getId());
            }
            this.tableLayoutManager = (TableLayoutManager)newCollectionGroup.getLayoutManager();
            this.filteredCollectionSize = newCollectionGroup.getFilteredCollectionSize();
            this.totalCollectionSize = modelCollection.size();
            form.getExtensionData().put(tableId + "_columnSorts", newColumnSorts);
        }
    }

    private List<ColumnSort> buildColumnSorts(View view, DataTablesInputs dataTablesInputs, CollectionGroup collectionGroup) {
        int[] sortCols = dataTablesInputs.iSortCol_;
        boolean[] sortable = dataTablesInputs.bSortable_;
        String[] sortDir = dataTablesInputs.sSortDir_;
        String aoColumnDefsValue = (String)view.getViewIndex().getPostContextEntry(collectionGroup.getId(), "aoColumnDefs");
        JsonArray jsonColumnDefs = null;
        if (!StringUtils.isEmpty((String)aoColumnDefsValue)) {
            aoColumnDefsValue = aoColumnDefsValue.replaceAll("function\\([^)]*\\)\\s*\\{[^}]*\\}", "\"REDACTED\"");
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(aoColumnDefsValue));
            jsonColumnDefs = jsonReader.readArray();
        }
        ArrayList<ColumnSort> columnSorts = new ArrayList<ColumnSort>(sortCols.length);
        for (int sortColsIndex = 0; sortColsIndex < sortCols.length; ++sortColsIndex) {
            int sortCol = sortCols[sortColsIndex];
            if (!sortable[sortCol]) continue;
            String sortType = this.getSortType(jsonColumnDefs, sortCol);
            ColumnSort.Direction sortDirection = ColumnSort.Direction.valueOf(sortDir[sortColsIndex].toUpperCase());
            columnSorts.add(new ColumnSort(sortCol, sortDirection, sortType));
        }
        return columnSorts;
    }

    private String getSortType(JsonArray jsonColumnDefs, int sortCol) {
        JsonObject column;
        String sortType = "string";
        if (jsonColumnDefs != null && (column = jsonColumnDefs.getJsonObject(sortCol)).containsKey((Object)"sType")) {
            sortType = column.getString("sType");
        }
        return sortType;
    }

    protected void applyTableJsonSort(List<Object> modelCollection, List<ColumnSort> oldColumnSorts, List<ColumnSort> newColumnSorts, CollectionGroup collectionGroup, View view) {
        boolean isSortOrderChanged;
        boolean isCollectionEmpty = CollectionUtils.isEmpty(modelCollection);
        boolean isSortingSpecified = !CollectionUtils.isEmpty(newColumnSorts);
        boolean bl = isSortOrderChanged = newColumnSorts != oldColumnSorts && !((Object)newColumnSorts).equals(oldColumnSorts);
        if (!isCollectionEmpty && isSortingSpecified && isSortOrderChanged) {
            int i;
            Integer[] sortIndices = new Integer[modelCollection.size()];
            for (int i2 = 0; i2 < sortIndices.length; ++i2) {
                sortIndices[i2] = i2;
            }
            Arrays.sort(sortIndices, new MultiColumnComparator(modelCollection, collectionGroup, newColumnSorts, view));
            Object[] sorted = new Object[sortIndices.length];
            for (i = 0; i < sortIndices.length; ++i) {
                sorted[i] = modelCollection.get(sortIndices[i]);
            }
            for (i = 0; i < sorted.length; ++i) {
                modelCollection.set(i, sorted[i]);
            }
        }
    }

    public int getTotalCollectionSize() {
        return this.totalCollectionSize;
    }

    public Integer getFilteredCollectionSize() {
        return this.filteredCollectionSize;
    }

    public TableLayoutManager getTableLayoutManager() {
        return this.tableLayoutManager;
    }

    public static class DataTablesInputs {
        private static final String DISPLAY_START = "iDisplayStart";
        private static final String DISPLAY_LENGTH = "iDisplayLength";
        private static final String COLUMNS = "iColumns";
        private static final String REGEX = "bRegex";
        private static final String REGEX_PREFIX = "bRegex_";
        private static final String SORTABLE_PREFIX = "bSortable_";
        private static final String SORTING_COLS = "iSortingCols";
        private static final String SORT_COL_PREFIX = "iSortCol_";
        private static final String SORT_DIR_PREFIX = "sSortDir_";
        private static final String DATA_PROP_PREFIX = "mDataProp_";
        private static final String ECHO = "sEcho";
        private final int iDisplayStart;
        private final int iDisplayLength;
        private final int iColumns;
        private final int iSortingCols;
        private final int sEcho;
        private final boolean bRegex;
        private final boolean[] bRegex_;
        private final boolean[] bSortable_;
        private final String[] sSortDir_;
        private final String[] mDataProp_;
        private final int[] iSortCol_;

        public DataTablesInputs(HttpServletRequest request) {
            int i;
            String s = request.getParameter(DISPLAY_START);
            this.iDisplayStart = s == null ? 0 : Integer.parseInt(s);
            s = request.getParameter(DISPLAY_LENGTH);
            this.iDisplayLength = s == null ? 0 : Integer.parseInt(s);
            s = request.getParameter(COLUMNS);
            this.iColumns = s == null ? 0 : Integer.parseInt(s);
            s = request.getParameter(REGEX);
            this.bRegex = s == null ? false : new Boolean(s);
            this.bRegex_ = new boolean[this.iColumns];
            this.bSortable_ = new boolean[this.iColumns];
            for (i = 0; i < this.iColumns; ++i) {
                s = request.getParameter(REGEX_PREFIX + i);
                this.bRegex_[i] = s == null ? false : new Boolean(s);
                s = request.getParameter(SORTABLE_PREFIX + i);
                this.bSortable_[i] = s == null ? false : new Boolean(s);
            }
            s = request.getParameter(SORTING_COLS);
            this.iSortingCols = s == null ? 0 : Integer.parseInt(s);
            this.iSortCol_ = new int[this.iSortingCols];
            this.sSortDir_ = new String[this.iSortingCols];
            for (i = 0; i < this.iSortingCols; ++i) {
                s = request.getParameter(SORT_COL_PREFIX + i);
                this.iSortCol_[i] = s == null ? 0 : Integer.parseInt(s);
                this.sSortDir_[i] = request.getParameter(SORT_DIR_PREFIX + i);
            }
            this.mDataProp_ = new String[this.iColumns];
            for (i = 0; i < this.iColumns; ++i) {
                this.mDataProp_[i] = request.getParameter(DATA_PROP_PREFIX + i);
            }
            s = request.getParameter(ECHO);
            this.sEcho = s == null ? 0 : Integer.parseInt(s);
        }

        public String toString() {
            int i;
            StringBuilder sb = new StringBuilder(super.toString());
            sb.append("\n\tiDisplayStart = ");
            sb.append(this.iDisplayStart);
            sb.append("\n\tiDisplayLength = ");
            sb.append(this.iDisplayLength);
            sb.append("\n\tiColumns = ");
            sb.append(this.iColumns);
            sb.append("\n\tbRegex = ");
            sb.append(this.bRegex);
            for (i = 0; i < this.iColumns; ++i) {
                sb.append("\n\t").append(REGEX_PREFIX).append(i).append(" = ");
                sb.append(this.bRegex_[i]);
                sb.append("\n\t").append(SORTABLE_PREFIX).append(i).append(" = ");
                sb.append(this.bSortable_[i]);
            }
            sb.append("\n\t").append(SORTING_COLS);
            sb.append(this.iSortingCols);
            for (i = 0; i < this.iSortingCols; ++i) {
                sb.append("\n\t").append(SORT_COL_PREFIX).append(i).append(" = ");
                sb.append(this.iSortCol_[i]);
                sb.append("\n\t").append(SORT_DIR_PREFIX).append(i).append(" = ");
                sb.append(this.sSortDir_[i]);
            }
            for (i = 0; i < this.iColumns; ++i) {
                sb.append("\n\t").append(DATA_PROP_PREFIX).append(i).append(" = ");
                sb.append(this.mDataProp_[i]);
            }
            sb.append("\n\tsEcho = ");
            sb.append(this.sEcho);
            return sb.toString();
        }
    }
}

