/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.kuali.rice.krad.uif.util.BreadcrumbItem;
import org.kuali.rice.krad.uif.util.UrlInfo;

public class HistoryFlow
implements Serializable {
    protected Stack<UrlInfo> flowUrls = new Stack();
    protected String flowReturnPoint;
    protected String flowStartPoint;
    protected String flowKey;
    protected BreadcrumbItem currentViewItem;
    protected List<BreadcrumbItem> pastItems;

    public HistoryFlow(String flowKey) {
        this.flowKey = flowKey;
    }

    public Stack<UrlInfo> getFlowUrls() {
        return this.flowUrls;
    }

    public void setFlowUrls(Stack<UrlInfo> flowUrls) {
        this.flowUrls = flowUrls;
    }

    public String getFlowReturnPoint() {
        return this.flowReturnPoint;
    }

    public void setFlowReturnPoint(String flowReturnPoint) {
        this.flowReturnPoint = flowReturnPoint;
    }

    public String getFlowStartPoint() {
        return this.flowStartPoint;
    }

    public void setFlowStartPoint(String flowStartPoint) {
        this.flowStartPoint = flowStartPoint;
    }

    public String getFlowKey() {
        return this.flowKey;
    }

    public void setFlowKey(String flowKey) {
        this.flowKey = flowKey;
    }

    public void push(String url) {
        UrlInfo urlInfo = new UrlInfo();
        urlInfo.setHref(url);
        this.flowUrls.push(urlInfo);
    }

    public void push(UrlInfo urlInfo) {
        this.flowUrls.push(urlInfo);
    }

    public void update(String url) {
        UrlInfo urlInfo = new UrlInfo();
        urlInfo.setHref(url);
        if (this.flowUrls.empty()) {
            this.flowUrls.push(urlInfo);
        } else {
            this.flowUrls.pop();
            this.flowUrls.push(urlInfo);
        }
    }

    public void update(UrlInfo urlInfo) {
        if (this.flowUrls.empty()) {
            this.flowUrls.push(urlInfo);
        } else {
            this.flowUrls.pop();
            this.flowUrls.push(urlInfo);
        }
    }

    public String getCurrentLocation() {
        if (this.flowUrls != null && !this.flowUrls.isEmpty()) {
            return this.flowUrls.peek().getHref();
        }
        return null;
    }

    public void clear() {
        this.flowUrls.clear();
        this.pastItems.clear();
        this.currentViewItem = null;
        this.flowReturnPoint = null;
    }

    public void continueFlow(HistoryFlow prevFlow) {
        if (prevFlow != null) {
            this.flowReturnPoint = prevFlow.getCurrentLocation();
            this.setFlowUrls(prevFlow.getFlowUrls());
            if (this.getFlowUrls() != null && !this.getFlowUrls().isEmpty()) {
                this.flowStartPoint = ((UrlInfo)this.getFlowUrls().firstElement()).getHref();
            }
            this.pastItems = new ArrayList<BreadcrumbItem>();
            if (prevFlow.getPastItems() != null) {
                this.pastItems.addAll(prevFlow.getPastItems());
            }
            if (prevFlow.getCurrentViewItem() != null) {
                this.pastItems.add(prevFlow.getCurrentViewItem());
            }
        }
    }

    public BreadcrumbItem getCurrentViewItem() {
        return this.currentViewItem;
    }

    public void setCurrentViewItem(BreadcrumbItem currentViewItem) {
        this.currentViewItem = currentViewItem;
    }

    public List<BreadcrumbItem> getPastItems() {
        return this.pastItems;
    }

    public void setPastItems(List<BreadcrumbItem> pastItems) {
        this.pastItems = pastItems;
    }
}

