/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.BaseAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.capability.CaseConstrainable;
import org.kuali.rice.krad.datadictionary.validation.capability.Constrainable;
import org.kuali.rice.krad.datadictionary.validation.capability.MustOccurConstrainable;
import org.kuali.rice.krad.datadictionary.validation.capability.PrerequisiteConstrainable;
import org.kuali.rice.krad.datadictionary.validation.capability.SimpleConstrainable;
import org.kuali.rice.krad.datadictionary.validation.capability.ValidCharactersConstrainable;
import org.kuali.rice.krad.datadictionary.validation.constraint.CaseConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.MustOccurConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.PrerequisiteConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.SimpleConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.ViewModel;

public class ViewAttributeValueReader
extends BaseAttributeValueReader {
    private ViewModel form;
    private List<Constrainable> inputFields = new ArrayList<Constrainable>();
    private Map<String, InputFieldConstrainableInfo> inputFieldMap = new HashMap<String, InputFieldConstrainableInfo>();

    public ViewAttributeValueReader(ViewModel form) {
        this.form = form;
        ViewPostMetadata viewPostMetadata = form.getViewPostMetadata();
        for (String id : viewPostMetadata.getInputFieldIds()) {
            Object simpleConstraint;
            Object mustOccurConstraints;
            Object prerequisiteConstraints;
            Object caseConstraint;
            Object validCharactersConstraint;
            Object name;
            InputFieldConstrainableInfo info = new InputFieldConstrainableInfo(this);
            Object label = viewPostMetadata.getComponentPostData(id, "label");
            if (label != null) {
                info.setLabel((String)label);
            }
            if ((name = viewPostMetadata.getComponentPostData(id, "path")) != null) {
                info.setName((String)name);
            }
            if ((validCharactersConstraint = viewPostMetadata.getComponentPostData(id, "validCharacterConstraint")) != null) {
                info.setValidCharactersConstraint((ValidCharactersConstraint)validCharactersConstraint);
            }
            if ((caseConstraint = viewPostMetadata.getComponentPostData(id, "caseConstraint")) != null) {
                info.setCaseConstraint((CaseConstraint)caseConstraint);
            }
            if ((prerequisiteConstraints = viewPostMetadata.getComponentPostData(id, "prerequisiteConstraints")) != null) {
                info.setPrerequisiteConstraints((List)prerequisiteConstraints);
            }
            if ((mustOccurConstraints = viewPostMetadata.getComponentPostData(id, "mustOccurConstraints")) != null) {
                info.setMustOccurConstraints((List)mustOccurConstraints);
            }
            if ((simpleConstraint = viewPostMetadata.getComponentPostData(id, "simpleConstraint")) != null) {
                info.setSimpleConstraint((SimpleConstraint)simpleConstraint);
            }
            this.inputFields.add(info);
            this.inputFieldMap.put(info.getName(), info);
        }
    }

    @Override
    public Constrainable getDefinition(String attributeName) {
        InputFieldConstrainableInfo field = this.inputFieldMap.get(attributeName);
        if (field != null) {
            return field;
        }
        return null;
    }

    @Override
    public List<Constrainable> getDefinitions() {
        return this.inputFields;
    }

    @Override
    public String getLabel(String attributeName) {
        InputFieldConstrainableInfo field = this.inputFieldMap.get(attributeName);
        if (field != null) {
            return field.getLabel();
        }
        return "";
    }

    @Override
    public Object getObject() {
        return this.form;
    }

    @Override
    public Constrainable getEntry() {
        return null;
    }

    @Override
    public String getPath() {
        return this.attributeName;
    }

    @Override
    public Class<?> getType(String attributeName) {
        Object fieldValue = ObjectPropertyUtils.getPropertyValue(this.form, attributeName);
        return fieldValue.getClass();
    }

    @Override
    public boolean isReadable() {
        return this.attributeName == null || !this.attributeName.contains("newCollectionLines");
    }

    @Override
    public <X> X getValue() throws AttributeValidationException {
        X fieldValue = null;
        if (StringUtils.isNotBlank((String)this.attributeName)) {
            fieldValue = (X)ObjectPropertyUtils.getPropertyValue(this.form, this.attributeName);
        }
        return fieldValue;
    }

    @Override
    public <X> X getValue(String attributeName) throws AttributeValidationException {
        X fieldValue = null;
        if (StringUtils.isNotBlank((String)attributeName)) {
            fieldValue = (X)ObjectPropertyUtils.getPropertyValue(this.form, this.attributeName);
        }
        return fieldValue;
    }

    @Override
    public AttributeValueReader clone() {
        ViewAttributeValueReader clone = new ViewAttributeValueReader(this.form);
        clone.setAttributeName(this.attributeName);
        return clone;
    }

    public class InputFieldConstrainableInfo
    implements SimpleConstrainable,
    CaseConstrainable,
    PrerequisiteConstrainable,
    MustOccurConstrainable,
    ValidCharactersConstrainable {
        private String label;
        private String name;
        private ValidCharactersConstraint validCharactersConstraint;
        private CaseConstraint caseConstraint;
        private List<PrerequisiteConstraint> prerequisiteConstraints;
        private List<MustOccurConstraint> mustOccurConstraints;
        private SimpleConstraint simpleConstraint;

        public InputFieldConstrainableInfo(ViewAttributeValueReader this$0) {
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public ValidCharactersConstraint getValidCharactersConstraint() {
            return this.validCharactersConstraint;
        }

        public void setValidCharactersConstraint(ValidCharactersConstraint validCharactersConstraint) {
            this.validCharactersConstraint = validCharactersConstraint;
        }

        @Override
        public CaseConstraint getCaseConstraint() {
            return this.caseConstraint;
        }

        public void setCaseConstraint(CaseConstraint caseConstraint) {
            this.caseConstraint = caseConstraint;
        }

        @Override
        public List<PrerequisiteConstraint> getPrerequisiteConstraints() {
            return this.prerequisiteConstraints;
        }

        public void setPrerequisiteConstraints(List<PrerequisiteConstraint> prerequisiteConstraints) {
            this.prerequisiteConstraints = prerequisiteConstraints;
        }

        @Override
        public List<MustOccurConstraint> getMustOccurConstraints() {
            return this.mustOccurConstraints;
        }

        public void setMustOccurConstraints(List<MustOccurConstraint> mustOccurConstraints) {
            this.mustOccurConstraints = mustOccurConstraints;
        }

        @Override
        public SimpleConstraint getSimpleConstraint() {
            return this.simpleConstraint;
        }

        public void setSimpleConstraint(SimpleConstraint simpleConstraint) {
            this.simpleConstraint = simpleConstraint;
        }
    }
}

