/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleRestriction;
import org.kuali.rice.krad.uif.util.CopyUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.RecycleUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADConstants;

public final class ViewLifecycleUtils {
    private static final String COMPONENT_CONTEXT_PREFIX = "#component.";
    private static final String PARENT_CONTEXT_PREFIX = "#parent.";
    private static final Map<Class<?>, ElementMetadata> METADATA_CACHE = Collections.synchronizedMap(new WeakHashMap(2048));

    public static Set<String> getLifecycleRestrictedProperties(LifecycleElement element, String viewPhase) {
        Set<String> restrictedPropertyNames = ViewLifecycleUtils.getMetadata(element.getClass()).lifecycleRestrictedProperties.get(viewPhase);
        if (restrictedPropertyNames == null) {
            return Collections.emptySet();
        }
        return restrictedPropertyNames;
    }

    public static String getNextLifecyclePhase(LifecycleElement element) {
        if (element == null) {
            return "INITIALIZE";
        }
        String viewStatus = element.getViewStatus();
        if (viewStatus == null || "X".equals(viewStatus) || "C".equals(viewStatus)) {
            return "INITIALIZE";
        }
        if ("I".equals(viewStatus)) {
            return "APPLY_MODEL";
        }
        if ("M".equals(viewStatus)) {
            return "FINALIZE";
        }
        if ("F".equals(viewStatus) || "R".equals(viewStatus)) {
            return "RENDER";
        }
        ViewLifecycle.reportIllegalState("Invalid view status " + viewStatus);
        return "INITIALIZE";
    }

    public static Map<String, LifecycleElement> getElementsForLifecycle(LifecycleElement element) {
        return ViewLifecycleUtils.getElementsForLifecycle(element, ViewLifecycleUtils.getNextLifecyclePhase(element));
    }

    private static Map<String, LifecycleElement> addElementToLifecycleMap(Map<String, LifecycleElement> map, String propertyName, LifecycleElement nestedElement) {
        if (nestedElement == null) {
            return map;
        }
        Map returnMap = map;
        if (returnMap == Collections.EMPTY_MAP) {
            returnMap = RecycleUtils.getInstance(LinkedHashMap.class);
        }
        returnMap.put(propertyName, CopyUtils.unwrap(nestedElement));
        return returnMap;
    }

    public static Map<String, LifecycleElement> getElementsForLifecycle(LifecycleElement element, String viewPhase) {
        if (element == null) {
            return Collections.emptyMap();
        }
        Set<String> nestedElementProperties = ObjectPropertyUtils.getReadablePropertyNamesByType(element, LifecycleElement.class);
        Set<String> nestedElementCollectionProperties = ObjectPropertyUtils.getReadablePropertyNamesByCollectionType(element, LifecycleElement.class);
        if (nestedElementProperties.isEmpty() && nestedElementCollectionProperties.isEmpty()) {
            return Collections.emptyMap();
        }
        Set<String> restrictedPropertyNames = ViewLifecycleUtils.getLifecycleRestrictedProperties(element, viewPhase);
        Map<String, String> conditionalPropertyRestrictions = ViewLifecycleUtils.getMetadata(element.getClass()).conditionalPropertyRestrictions;
        Map<String, LifecycleElement> elements = Collections.emptyMap();
        for (String propertyName : nestedElementProperties) {
            boolean conditionResult;
            if (conditionalPropertyRestrictions.containsKey(propertyName) && ViewLifecycle.isActive() && !"PRE_PROCESS".equals(viewPhase) && !(conditionResult = ViewLifecycleUtils.evaluateLifecycleCondition(conditionalPropertyRestrictions.get(propertyName))) || restrictedPropertyNames.contains(propertyName)) continue;
            Object propertyValue = ObjectPropertyUtils.getPropertyValue(element, propertyName);
            elements = ViewLifecycleUtils.addElementToLifecycleMap(elements, propertyName, (LifecycleElement)propertyValue);
        }
        for (String propertyName : nestedElementCollectionProperties) {
            boolean conditionResult;
            if (conditionalPropertyRestrictions.containsKey(propertyName) && ViewLifecycle.isActive() && !"PRE_PROCESS".equals(viewPhase) && !(conditionResult = ViewLifecycleUtils.evaluateLifecycleCondition(conditionalPropertyRestrictions.get(propertyName))) || restrictedPropertyNames.contains(propertyName)) continue;
            Object nestedElementCollection = ObjectPropertyUtils.getPropertyValue(element, propertyName);
            if (element.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(nestedElementCollection); ++i) {
                    elements = ViewLifecycleUtils.addElementToLifecycleMap(elements, propertyName + "[" + i + "]", (LifecycleElement)Array.get(nestedElementCollection, i));
                }
                continue;
            }
            if (nestedElementCollection instanceof List) {
                for (int i = 0; i < ((List)nestedElementCollection).size(); ++i) {
                    elements = ViewLifecycleUtils.addElementToLifecycleMap(elements, propertyName + "[" + i + "]", (LifecycleElement)((List)nestedElementCollection).get(i));
                }
                continue;
            }
            if (!(nestedElementCollection instanceof Map)) continue;
            for (Map.Entry entry : ((Map)nestedElementCollection).entrySet()) {
                elements = ViewLifecycleUtils.addElementToLifecycleMap(elements, propertyName + "[" + String.valueOf(entry.getKey()) + "]", (LifecycleElement)entry.getValue());
            }
        }
        return elements == Collections.EMPTY_MAP ? elements : Collections.unmodifiableMap(elements);
    }

    private static boolean evaluateLifecycleCondition(String condition) {
        ExpressionEvaluator expressionEvaluator = KRADServiceLocatorWeb.getExpressionEvaluatorFactory().createExpressionEvaluator();
        expressionEvaluator.initializeEvaluationContext(ViewLifecycle.getModel());
        HashMap<String, Object> context = new HashMap<String, Object>();
        Map properties = CoreApiServiceLocator.getKualiConfigurationService().getAllProperties();
        context.put("ConfigProperties", properties);
        context.put("Constants", KRADConstants.class);
        context.put("UifConstants", UifConstants.class);
        context.put("userSession", GlobalVariables.getUserSession());
        Boolean result = (Boolean)expressionEvaluator.evaluateExpression(context, condition);
        return result;
    }

    public static void recycleElementMap(Map<?, ?> elementMap) {
        if (elementMap instanceof LinkedHashMap) {
            elementMap.clear();
            RecycleUtils.recycle(elementMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends LifecycleElement> List<T> getElementsOfTypeDeep(Collection<? extends LifecycleElement> items, Class<T> elementType) {
        if (items == null) {
            return Collections.emptyList();
        }
        List elements = Collections.emptyList();
        Queue elementQueue = RecycleUtils.getInstance(LinkedList.class);
        elementQueue.addAll(items);
        try {
            while (!elementQueue.isEmpty()) {
                LifecycleElement currentElement = (LifecycleElement)elementQueue.poll();
                if (currentElement == null) continue;
                if (elementType.isInstance(currentElement)) {
                    if (elements.isEmpty()) {
                        elements = new ArrayList();
                    }
                    elements.add((LifecycleElement)elementType.cast(currentElement));
                }
                elementQueue.addAll(ViewLifecycleUtils.getElementsForLifecycle(currentElement).values());
            }
        }
        finally {
            elementQueue.clear();
            RecycleUtils.recycle(elementQueue);
        }
        return elements;
    }

    public static <T extends LifecycleElement> List<T> getElementsOfTypeDeep(LifecycleElement element, Class<T> elementType) {
        return ViewLifecycleUtils.getElementsOfTypeDeep(Collections.singletonList(element), elementType);
    }

    public static <T extends LifecycleElement> List<T> getElementsOfTypeShallow(LifecycleElement element, Class<T> elementType) {
        if (element == null) {
            return Collections.emptyList();
        }
        List<Object> typeElements = ViewLifecycleUtils.getNestedElementsOfTypeShallow(element, elementType);
        if (elementType.isInstance(element)) {
            if (typeElements.isEmpty()) {
                typeElements = Collections.singletonList((LifecycleElement)elementType.cast(element));
            } else {
                typeElements.add(0, (LifecycleElement)elementType.cast(element));
            }
        }
        return typeElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends LifecycleElement> List<T> getNestedElementsOfTypeShallow(LifecycleElement element, Class<T> elementType) {
        if (element == null) {
            return Collections.emptyList();
        }
        List elements = Collections.emptyList();
        Queue elementQueue = RecycleUtils.getInstance(LinkedList.class);
        try {
            elementQueue.add(element);
            while (!elementQueue.isEmpty()) {
                LifecycleElement currentElement = (LifecycleElement)elementQueue.poll();
                if (currentElement == null) continue;
                if (elementType.isInstance(currentElement) && currentElement != element) {
                    if (elements.isEmpty()) {
                        elements = new ArrayList();
                    }
                    elements.add((LifecycleElement)elementType.cast(currentElement));
                }
                for (LifecycleElement nestedElement : ViewLifecycleUtils.getElementsForLifecycle(currentElement).values()) {
                    if (nestedElement instanceof Component) continue;
                    elementQueue.offer(nestedElement);
                }
            }
        }
        finally {
            elementQueue.clear();
            RecycleUtils.recycle(elementQueue);
        }
        return elements;
    }

    private ViewLifecycleUtils() {
    }

    private static ElementMetadata getMetadata(Class<?> elementClass) {
        ElementMetadata metadata = METADATA_CACHE.get(elementClass);
        if (metadata == null) {
            metadata = new ElementMetadata(elementClass);
            METADATA_CACHE.put(elementClass, metadata);
        }
        return metadata;
    }

    public static boolean isExcluded(Component component) {
        String excludeUnless = component.getExcludeUnless();
        if (StringUtils.isNotBlank((String)excludeUnless) && !ViewLifecycleUtils.resolvePropertyPath(excludeUnless, component)) {
            return true;
        }
        return ViewLifecycleUtils.resolvePropertyPath(component.getExcludeIf(), component);
    }

    private static boolean resolvePropertyPath(String path, Component component) {
        Object root;
        if (StringUtils.isBlank((String)path)) {
            return false;
        }
        if (path.startsWith(COMPONENT_CONTEXT_PREFIX)) {
            root = component;
            path = path.substring(COMPONENT_CONTEXT_PREFIX.length());
        } else if (path.startsWith(PARENT_CONTEXT_PREFIX)) {
            root = ViewLifecycle.getPhase().getParent();
            path = path.substring(PARENT_CONTEXT_PREFIX.length());
        } else if (path.charAt(0) == '#') {
            Map<String, Object> context = ViewLifecycle.getView().getPreModelContext();
            int iod = path.indexOf(46);
            if (iod == -1) {
                return Boolean.TRUE.equals(context.get(path.substring(1)));
            }
            String contextVariable = path.substring(1, iod);
            root = context.get(contextVariable);
            path = path.substring(iod + 1);
        } else {
            root = ViewLifecycle.getModel();
        }
        return Boolean.TRUE.equals(ObjectPropertyUtils.getPropertyValue(root, path));
    }

    private static class ElementMetadata {
        private final Map<String, Set<String>> lifecycleRestrictedProperties;
        private final Map<String, String> conditionalPropertyRestrictions;

        private ElementMetadata(Class<?> elementClass) {
            Set<String> restrictedPropertyNames = ObjectPropertyUtils.getReadablePropertyNamesByAnnotationType(elementClass, ViewLifecycleRestriction.class);
            if (restrictedPropertyNames.isEmpty()) {
                this.lifecycleRestrictedProperties = Collections.emptyMap();
                this.conditionalPropertyRestrictions = Collections.emptyMap();
                return;
            }
            HashMap<String, Set<String>> mutableLifecycleRestrictedProperties = new HashMap<String, Set<String>>();
            mutableLifecycleRestrictedProperties.put("FINALIZE", new HashSet<String>(restrictedPropertyNames));
            mutableLifecycleRestrictedProperties.put("APPLY_MODEL", new HashSet<String>(restrictedPropertyNames));
            mutableLifecycleRestrictedProperties.put("INITIALIZE", new HashSet<String>(restrictedPropertyNames));
            mutableLifecycleRestrictedProperties.put("PRE_PROCESS", new HashSet<String>(restrictedPropertyNames));
            HashMap<String, String> mutableConditionalLifecycleProperties = new HashMap<String, String>();
            for (String restrictedPropertyName : restrictedPropertyNames) {
                ViewLifecycleRestriction restriction = ObjectPropertyUtils.getReadMethod(elementClass, restrictedPropertyName).getAnnotation(ViewLifecycleRestriction.class);
                if (restriction.value().length > 0) {
                    this.removedRestrictionsForPrecedingPhases(mutableLifecycleRestrictedProperties, restrictedPropertyName, restriction.value()[0]);
                } else if (restriction.exclude().length > 0) {
                    this.removedRestrictionsForPhase(mutableLifecycleRestrictedProperties, restrictedPropertyName, "PRE_PROCESS");
                    this.removedRestrictionsForPhase(mutableLifecycleRestrictedProperties, restrictedPropertyName, "INITIALIZE");
                    this.removedRestrictionsForPhase(mutableLifecycleRestrictedProperties, restrictedPropertyName, "APPLY_MODEL");
                    this.removedRestrictionsForPhase(mutableLifecycleRestrictedProperties, restrictedPropertyName, "FINALIZE");
                }
                if (restriction.exclude().length > 0) {
                    for (String excludePhase : restriction.exclude()) {
                        Set restrictedProperties = (Set)mutableLifecycleRestrictedProperties.get(excludePhase);
                        restrictedProperties.add(restrictedPropertyName);
                    }
                }
                if (!StringUtils.isNotBlank((String)restriction.condition())) continue;
                mutableConditionalLifecycleProperties.put(restrictedPropertyName, restriction.condition());
            }
            this.lifecycleRestrictedProperties = Collections.unmodifiableMap(mutableLifecycleRestrictedProperties);
            this.conditionalPropertyRestrictions = Collections.unmodifiableMap(mutableConditionalLifecycleProperties);
        }

        private void removedRestrictionsForPrecedingPhases(Map<String, Set<String>> mutableLifecycleRestrictedProperties, String propertyName, String phase) {
            if (phase.equals("FINALIZE")) {
                this.removedRestrictionsForPhase(mutableLifecycleRestrictedProperties, propertyName, "FINALIZE");
                this.removedRestrictionsForPhase(mutableLifecycleRestrictedProperties, propertyName, "APPLY_MODEL");
                this.removedRestrictionsForPhase(mutableLifecycleRestrictedProperties, propertyName, "INITIALIZE");
                this.removedRestrictionsForPhase(mutableLifecycleRestrictedProperties, propertyName, "PRE_PROCESS");
            } else if (phase.equals("APPLY_MODEL")) {
                this.removedRestrictionsForPhase(mutableLifecycleRestrictedProperties, propertyName, "APPLY_MODEL");
                this.removedRestrictionsForPhase(mutableLifecycleRestrictedProperties, propertyName, "INITIALIZE");
                this.removedRestrictionsForPhase(mutableLifecycleRestrictedProperties, propertyName, "PRE_PROCESS");
            } else if (phase.equals("INITIALIZE")) {
                this.removedRestrictionsForPhase(mutableLifecycleRestrictedProperties, propertyName, "INITIALIZE");
                this.removedRestrictionsForPhase(mutableLifecycleRestrictedProperties, propertyName, "PRE_PROCESS");
            } else if (phase.equals("PRE_PROCESS")) {
                this.removedRestrictionsForPhase(mutableLifecycleRestrictedProperties, propertyName, "PRE_PROCESS");
            }
        }

        private void removedRestrictionsForPhase(Map<String, Set<String>> mutableLifecycleRestrictedProperties, String propertyName, String phase) {
            Set<String> restrictedProperties = mutableLifecycleRestrictedProperties.get(phase);
            restrictedProperties.remove(propertyName);
        }
    }
}

