/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util.documentserializer;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.krad.util.documentserializer.PropertyType;

public class SerializationState {
    private List<SerializationPropertyElement> pathElements = new ArrayList<SerializationPropertyElement>();

    public SerializationState() {
    }

    public SerializationState(SerializationState stateToCopy) {
        this();
        this.pathElements.addAll(stateToCopy.pathElements);
    }

    public int numPropertyElements() {
        return this.pathElements.size();
    }

    public void addSerializedProperty(String elementName, PropertyType propertyType) {
        SerializationPropertyElement serializationPropertyElement = new SerializationPropertyElement(this, elementName, propertyType);
        this.pathElements.add(serializationPropertyElement);
    }

    public void removeSerializedProperty() {
        this.pathElements.remove(this.pathElements.size() - 1);
    }

    public String getElementName(int propertyIndex) {
        return this.pathElements.get(propertyIndex).getElementName();
    }

    public PropertyType getPropertyType(int propertyIndex) {
        return this.pathElements.get(propertyIndex).getPropertyType();
    }

    protected class SerializationPropertyElement {
        private String elementName;
        private PropertyType propertyType;

        public SerializationPropertyElement(SerializationState this$0, String elementName, PropertyType propertyType) {
            this.elementName = elementName;
            this.propertyType = propertyType;
        }

        public String getElementName() {
            return this.elementName;
        }

        public PropertyType getPropertyType() {
            return this.propertyType;
        }
    }
}

