/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.service.impl;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.io.SerializationUtils;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBaseAdapter;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.DataObjectWrapper;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.inquiry.Inquirable;
import org.kuali.rice.krad.messages.MessageService;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.PropertyReplacer;
import org.kuali.rice.krad.uif.component.RequestParameter;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.service.ViewDictionaryService;
import org.kuali.rice.krad.uif.service.ViewHelperService;
import org.kuali.rice.krad.uif.util.BooleanMap;
import org.kuali.rice.krad.uif.util.CopyUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.RecycleUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.ExpressionEvaluatorFactory;
import org.kuali.rice.krad.uif.view.RequestAuthorizationCache;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewAuthorizer;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.uif.view.ViewPresentationController;
import org.kuali.rice.krad.uif.widget.Inquiry;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.GrowlMessage;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.valuefinder.ValueFinder;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.impl.CollectionControllerServiceImpl;
import org.springframework.beans.PropertyAccessorUtils;

public class ViewHelperServiceImpl
implements ViewHelperService,
Serializable {
    private static final long serialVersionUID = 1772618197133239852L;
    private static final Logger LOG = LogManager.getLogger(ViewHelperServiceImpl.class);
    private transient ConfigurationService configurationService;
    private transient DataDictionaryService dataDictionaryService;
    private transient LegacyDataAdapter legacyDataAdapter;
    private transient DataObjectService dataObjectService;
    private transient ViewDictionaryService viewDictionaryService;
    private transient ExpressionEvaluatorFactory expressionEvaluatorFactory;

    @Override
    public void addCustomContainerComponents(ViewModel model, Container container) {
    }

    @Override
    public void buildInquiryLink(Object dataObject, String propertyName, Inquiry inquiry) {
        Inquirable inquirable = this.getViewDictionaryService().getInquirable(dataObject.getClass(), inquiry.getViewName());
        if (inquirable != null) {
            inquirable.buildInquirableLink(dataObject, propertyName, inquiry);
        } else {
            inquiry.setRender(false);
        }
    }

    @Override
    public void performCustomApplyModel(LifecycleElement element, Object model) {
    }

    @Override
    public void performCustomFinalize(LifecycleElement element, Object model, LifecycleElement parent) {
    }

    @Override
    public void performCustomInitialization(LifecycleElement element) {
    }

    @Override
    public void performCustomViewFinalize(Object model) {
    }

    @Override
    public void performCustomViewInitialization(Object model) {
    }

    @Override
    public void processAfterAddLine(ViewModel model, Object lineObject, String collectionId, String collectionPath, boolean isValidLine) {
    }

    @Override
    public void processAfterDeleteLine(ViewModel model, String collectionId, String collectionPath, int lineIndex) {
    }

    @Override
    public void processAfterSaveLine(ViewModel model, Object lineObject, String collectionId, String collectionPath) {
    }

    @Override
    public void processBeforeAddLine(ViewModel model, Object addLine, String collectionId, String collectionPath) {
    }

    @Override
    public void processBeforeSaveLine(ViewModel model, Object lineObject, String collectionId, String collectionPath) {
    }

    @Override
    public void processBeforeEditLine(ViewModel model, Object lineObject, String collectionId, String collectionPath) {
    }

    @Override
    public void processAfterEditLine(ViewModel model, Object lineObject, String collectionId, String collectionPath) {
    }

    @Override
    public void processCollectionAddBlankLine(ViewModel model, String collectionId, String collectionPath) {
        Collection collection;
        if (!(model instanceof ViewModel)) {
            return;
        }
        ViewModel viewModel = model;
        if (collectionId == null) {
            this.logAndThrowRuntime("Unable to get collection group component for Id: " + collectionPath + " path: " + collectionPath);
        }
        if ((collection = (Collection)ObjectPropertyUtils.getPropertyValue(model, collectionPath)) == null) {
            this.logAndThrowRuntime("Unable to get collection property from model for path: " + collectionPath);
        }
        Class collectionObjectClass = (Class)viewModel.getViewPostMetadata().getComponentPostData(collectionId, "collectionObjectClass");
        Object newLine = KRADUtils.createNewObjectFromClass(collectionObjectClass);
        ArrayList lineDataObjects = new ArrayList();
        lineDataObjects.add(newLine);
        viewModel.getViewPostMetadata().getAddedCollectionObjects().put(collectionId, lineDataObjects);
        this.processAndAddLineObject(viewModel, newLine, collectionId, collectionPath);
    }

    @Override
    public void processCollectionAddLine(ViewModel model, String collectionId, String collectionPath) {
        BindingInfo addLineBindingInfo = (BindingInfo)model.getViewPostMetadata().getComponentPostData(collectionId, "addLineBindingInfo");
        Object addLine = ObjectPropertyUtils.getPropertyValue(model, addLineBindingInfo.getBindingPath());
        if (addLine == null) {
            this.logAndThrowRuntime("Add line instance not found for path: " + addLineBindingInfo.getBindingPath());
        }
        this.processAndAddLineObject(model, addLine, collectionId, collectionPath);
    }

    @Override
    public void processAndAddLineObject(ViewModel viewModel, Object newLine, String collectionId, String collectionPath) {
        String addLinePlacement = (String)viewModel.getViewPostMetadata().getComponentPostData(collectionId, "addLinePlacement");
        Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue(viewModel, collectionPath);
        if (collection == null) {
            this.logAndThrowRuntime("Unable to get collection property from model for path: " + collectionPath);
        }
        this.processBeforeAddLine(viewModel, newLine, collectionId, collectionPath);
        boolean isValidLine = this.performAddLineValidation(viewModel, newLine, collectionId, collectionPath);
        if (isValidLine) {
            ArrayList lineDataObjects = new ArrayList();
            viewModel.getViewPostMetadata().getAddedCollectionObjects().put(collectionId, lineDataObjects);
            int addedIndex = this.addLine(collection, newLine, addLinePlacement.equals("TOP"));
            boolean linkToAddedCollection = this.linkAddedLine(viewModel, collectionPath, addedIndex);
            if (viewModel instanceof UifFormBase && linkToAddedCollection) {
                KRADServiceLocatorWeb.getLegacyDataAdapter().refreshAllNonUpdatingReferences(newLine);
                ((UifFormBase)viewModel).getAddedCollectionItems().add(newLine);
            }
            this.processAfterAddLine(viewModel, newLine, collectionId, collectionPath, isValidLine);
        }
    }

    @Override
    public void processCollectionDeleteLine(ViewModel model, String collectionId, String collectionPath, int lineIndex) {
        Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue(model, collectionPath);
        if (collection == null) {
            this.logAndThrowRuntime("Unable to get collection property from model for path: " + collectionPath);
        }
        if (collection instanceof List) {
            Object deleteLine = ((List)collection).get(lineIndex);
            boolean isValid = this.performDeleteLineValidation(model, collectionId, collectionPath, deleteLine);
            if (isValid) {
                ((List)collection).remove(lineIndex);
                String collectionLabel = (String)model.getViewPostMetadata().getComponentPostData(collectionId, "collectionLabel");
                GlobalVariables.getMessageMap().putInfoForSectionId(collectionId, "message.collection.line.deleted", new String[]{collectionLabel});
                this.processAfterDeleteLine(model, collectionId, collectionPath, lineIndex);
            }
        } else {
            this.logAndThrowRuntime("Only List collection implementations are supported for the delete by index method");
        }
    }

    @Override
    public void processCollectionRetrieveEditLineDialog(ViewModel model, String collectionId, String collectionPath, int selectedLineIndex) {
        String objectPath = collectionPath + "[" + selectedLineIndex + "]";
        Object dataObject = ObjectPropertyUtils.getPropertyValue(model, objectPath);
        if (dataObject == null) {
            this.logAndThrowRuntime("Unable to get collection property from model for path: " + objectPath);
        }
        if (((UifFormBase)model).getDialogDataObject() == null) {
            ((UifFormBase)model).setDialogDataObject(SerializationUtils.deepCopy((Serializable)((Serializable)dataObject)));
        }
    }

    @Override
    public void processCollectionEditLine(ViewModel model, CollectionControllerServiceImpl.CollectionActionParameters parameterData) {
        String collectionId = parameterData.getSelectedCollectionId();
        String collectionPath = parameterData.getSelectedCollectionPath();
        int selectedLineIndex = parameterData.getSelectedLineIndex();
        Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue(model, collectionPath);
        if (collection == null) {
            this.logAndThrowRuntime("Unable to get collection property from model for path: " + collectionPath);
        }
        if (collection instanceof List) {
            Object editLine = ((List)collection).get(selectedLineIndex);
            Object dialogDataObject = ((UifFormBase)model).getDialogDataObject();
            if (dialogDataObject != null) {
                editLine = SerializationUtils.deepCopy((Serializable)((Serializable)dialogDataObject));
                ((UifFormBase)model).setDialogDataObject(null);
            }
            this.processBeforeEditLine(model, editLine, collectionId, collectionPath);
            ((List)collection).remove(selectedLineIndex);
            ((List)collection).add(selectedLineIndex, editLine);
            this.processAfterEditLine(model, editLine, collectionId, collectionPath);
        } else {
            this.logAndThrowRuntime("Only List collection implementations are supported for the edit by index method");
        }
    }

    @Override
    public void processCollectionCloseEditLineDialog(ViewModel model, String collectionId, String collectionPath, int selectedLineIndex) {
        String objectPath = collectionPath + "[" + selectedLineIndex + "]";
        Object dataObject = ObjectPropertyUtils.getPropertyValue(model, objectPath);
        if (dataObject == null) {
            this.logAndThrowRuntime("Unable to get collection property from model for path: " + objectPath);
        }
        ((UifFormBase)model).setDialogDataObject(null);
    }

    @Override
    public void processCollectionSaveLine(ViewModel model, CollectionControllerServiceImpl.CollectionActionParameters parameterData) {
        String collectionId = parameterData.getSelectedCollectionId();
        String collectionPath = parameterData.getSelectedCollectionPath();
        int selectedLineIndex = parameterData.getSelectedLineIndex();
        Map<String, String[]> parameters = parameterData.getParameters();
        ViewPostMetadata viewPostMetadata = model.getViewPostMetadata();
        BindingInfo addLineBindingInfo = (BindingInfo)viewPostMetadata.getComponentPostData(collectionId, "bindingInfo");
        List collection = (List)ObjectPropertyUtils.getPropertyValue(model, addLineBindingInfo.getBindingPath());
        Object saveLine = this.extractNewValuesAndAssign(collectionPath, selectedLineIndex, parameters, collection);
        this.processBeforeSaveLine(model, saveLine, collectionId, collectionPath);
        boolean isValidLine = this.performAddLineValidation(model, saveLine, collectionId, collectionPath);
        if (isValidLine) {
            collection.set(selectedLineIndex, saveLine);
            KRADServiceLocatorWeb.getLegacyDataAdapter().refreshAllNonUpdatingReferences(saveLine);
            this.processAfterSaveLine(model, saveLine, collectionId, collectionPath);
        }
    }

    protected Object extractNewValuesAndAssign(String collectionPath, int selectedLineIndex, Map<String, String[]> parameters, List<Object> collection) {
        String[] fieldList = new String[]{"field1", "field2", "field3", "field4", "field5", "field6"};
        Object saveLine = collection.get(selectedLineIndex);
        for (String field : fieldList) {
            String index = String.format("%s[%s].%s", collectionPath, selectedLineIndex, field);
            String fieldValue = this.extractSingleValue(parameters.get(index));
            this.setValue(saveLine, field, fieldValue);
        }
        return saveLine;
    }

    private void setValue(Object object, String fieldName, Object value) {
        try {
            Class<?> clazz = object.getClass();
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (Exception e) {
            LOG.error("Unable to access private variable " + fieldName + " in object " + String.valueOf(object.getClass()) + ". " + e.getMessage());
        }
    }

    protected String extractSingleValue(String[] data) {
        if (data == null) {
            return null;
        }
        if (data.length < 1) {
            return null;
        }
        return data[0];
    }

    @Override
    public void processMultipleValueLookupResults(ViewModel model, String collectionId, String collectionPath, String multiValueReturnFields, String lookupResultValues) {
        if (StringUtils.isBlank((String)lookupResultValues) || !(model instanceof ViewModel)) {
            return;
        }
        ViewModel viewModel = model;
        if (StringUtils.isBlank((String)collectionId)) {
            throw new RuntimeException("Id is not set for this collection lookup: " + collectionId + ", path: " + collectionPath);
        }
        Class collectionObjectClass = (Class)viewModel.getViewPostMetadata().getComponentPostData(collectionId, "collectionObjectClass");
        Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue(model, collectionPath);
        if (collection == null) {
            Class<?> collectionClass = ObjectPropertyUtils.getPropertyType(model, collectionPath);
            collection = (Collection)KRADUtils.createNewObjectFromClass(collectionClass);
            ObjectPropertyUtils.setPropertyValue(model, collectionPath, collection);
        }
        Map fieldConversions = (Map)viewModel.getViewPostMetadata().getComponentPostData(collectionId, "collectionLookup.fieldConversions");
        Map<String, String> returnedFieldConversions = this.filterByReturnedFieldConversions(multiValueReturnFields, fieldConversions);
        ArrayList<String> toFieldNamesColl = new ArrayList<String>(returnedFieldConversions.values());
        Collections.sort(toFieldNamesColl);
        String[] toFieldNames = new String[toFieldNamesColl.size()];
        toFieldNamesColl.toArray(toFieldNames);
        String[] lineValues = StringUtils.split((String)lookupResultValues, (String)",");
        ArrayList<ExternalizableBusinessObject> lineDataObjects = new ArrayList<ExternalizableBusinessObject>();
        for (String lineValue : lineValues) {
            ExternalizableBusinessObject lineDataObject = null;
            ModuleService moduleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(collectionObjectClass);
            lineDataObject = moduleService != null && moduleService.isExternalizable(collectionObjectClass) ? moduleService.createNewObjectFromExternalizableClass(collectionObjectClass.asSubclass(ExternalizableBusinessObject.class)) : (ExternalizableBusinessObject)KRADUtils.createNewObjectFromClass(collectionObjectClass);
            String[] fieldValues = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)lineValue, (String)":");
            if (fieldValues.length != toFieldNames.length) {
                throw new RuntimeException("Value count passed back from multi-value lookup does not match field conversion count");
            }
            for (int i = 0; i < fieldValues.length; ++i) {
                String fieldName = toFieldNames[i];
                ObjectPropertyUtils.setPropertyValue(lineDataObject, fieldName, fieldValues[i]);
            }
            lineDataObjects.add(lineDataObject);
            this.processAndAddLineObject(viewModel, lineDataObject, collectionId, collectionPath);
        }
        viewModel.getViewPostMetadata().getAddedCollectionObjects().put(collectionId, lineDataObjects);
    }

    protected int addLine(Collection<Object> collection, Object addLine, boolean insertFirst) {
        int index = -1;
        if (insertFirst && collection instanceof List) {
            ((List)collection).add(0, addLine);
            index = 0;
        } else {
            boolean added = collection.add(addLine);
            if (added) {
                index = collection.size() - 1;
            }
        }
        return index;
    }

    protected boolean linkAddedLine(Object model, String collectionPath, int addedIndex) {
        int lastSepIndex = PropertyAccessorUtils.getLastNestedPropertySeparatorIndex((String)collectionPath);
        if (lastSepIndex != -1) {
            String collectionParentPath = collectionPath.substring(0, lastSepIndex);
            Object parent = ObjectPropertyUtils.getPropertyValue(model, collectionParentPath);
            if (parent != null && this.getDataObjectService().supports(parent.getClass())) {
                DataObjectWrapper wrappedParent = this.getDataObjectService().wrap(parent);
                String collectionName = collectionPath.substring(lastSepIndex + 1);
                wrappedParent.linkChanges((Set)Sets.newHashSet((Object[])new String[]{collectionName + "[" + addedIndex + "]"}));
            }
            if (collectionParentPath.equalsIgnoreCase("dialogDataObject")) {
                ((UifFormBase)model).setDialogDataObject(parent);
                return false;
            }
        }
        return true;
    }

    protected boolean performAddLineValidation(ViewModel viewModel, Object newLine, String collectionId, String collectionPath) {
        boolean isValid = true;
        Collection collectionItems = (Collection)ObjectPropertyUtils.getPropertyValue(viewModel, collectionPath);
        if (viewModel.getViewPostMetadata().getComponentPostData(collectionId, "duplicateLinePropertyNames") == null) {
            return isValid;
        }
        List duplicateLinePropertyNames = (List)viewModel.getViewPostMetadata().getComponentPostData(collectionId, "duplicateLinePropertyNames");
        String collectionLabel = null;
        if (viewModel.getViewPostMetadata().getComponentPostData(collectionId, "collectionLabel") != null) {
            collectionLabel = (String)viewModel.getViewPostMetadata().getComponentPostData(collectionId, "collectionLabel");
        }
        String duplicateLineLabelString = null;
        if (viewModel.getViewPostMetadata().getComponentPostData(collectionId, "duplicateLineLabelString") != null) {
            duplicateLineLabelString = (String)viewModel.getViewPostMetadata().getComponentPostData(collectionId, "duplicateLineLabelString");
        }
        if (this.containsDuplicateLine(newLine, collectionItems, duplicateLinePropertyNames)) {
            isValid = false;
            String propertyId = "newCollectionLines['" + collectionPath + "']." + (String)duplicateLinePropertyNames.get(0);
            GlobalVariables.getMessageMap().putError(propertyId, "error.duplicate.element", new String[]{collectionLabel, duplicateLineLabelString});
        }
        return isValid;
    }

    protected Map<String, String> filterByReturnedFieldConversions(String multiValueReturnFields, Map<String, String> fieldConversions) {
        HashMap<String, String> returnedFieldConversions = new HashMap<String, String>();
        returnedFieldConversions.putAll(fieldConversions);
        String[] returnedFieldsStrArr = StringUtils.split((String)multiValueReturnFields, (String)",");
        if (returnedFieldsStrArr != null && returnedFieldsStrArr.length > 0) {
            returnedFieldConversions.clear();
            for (String fieldConversion : returnedFieldsStrArr) {
                if (!fieldConversions.containsKey(fieldConversion)) continue;
                returnedFieldConversions.put(fieldConversion, fieldConversions.get(fieldConversion));
            }
        }
        return returnedFieldConversions;
    }

    protected boolean containsDuplicateLine(Object addLine, Collection<Object> collectionItems, List<String> duplicateLinePropertyNames) {
        if (collectionItems.isEmpty() || duplicateLinePropertyNames.isEmpty()) {
            return false;
        }
        for (Object collectionItem : collectionItems) {
            if (!this.isDuplicateLine(addLine, collectionItem, duplicateLinePropertyNames)) continue;
            return true;
        }
        return false;
    }

    protected boolean isDuplicateLine(Object addLine, Object collectionItem, List<String> duplicateLinePropertyNames) {
        if (duplicateLinePropertyNames.isEmpty()) {
            return false;
        }
        for (String duplicateLinePropertyName : duplicateLinePropertyNames) {
            Object duplicateLinePropertyValue;
            Object addLinePropertyValue = ObjectPropertyUtils.getPropertyValue(addLine, duplicateLinePropertyName);
            if (ObjectUtils.equals(addLinePropertyValue, duplicateLinePropertyValue = ObjectPropertyUtils.getPropertyValue(collectionItem, duplicateLinePropertyName))) continue;
            return false;
        }
        return true;
    }

    protected boolean performDeleteLineValidation(ViewModel model, String collectionId, String collectionPath, Object deleteLine) {
        return true;
    }

    @Override
    public void applyDefaultValuesForCollectionLine(CollectionGroup collectionGroup, Object line) {
        List<DataField> dataFields = ViewLifecycleUtils.getElementsOfTypeDeep(collectionGroup.getAddLineItems(), DataField.class);
        for (DataField dataField : dataFields) {
            Object bindingPath = "";
            if (StringUtils.isNotBlank((String)dataField.getBindingInfo().getBindByNamePrefix())) {
                bindingPath = dataField.getBindingInfo().getBindByNamePrefix() + ".";
            }
            bindingPath = (String)bindingPath + dataField.getBindingInfo().getBindingName();
            this.populateDefaultValueForField(line, dataField, (String)bindingPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyDefaultValues(Component component) {
        if (component == null) {
            return;
        }
        View view = ViewLifecycle.getView();
        Object model = ViewLifecycle.getModel();
        Queue elementQueue = RecycleUtils.getInstance(LinkedList.class);
        elementQueue.offer(component);
        try {
            while (!elementQueue.isEmpty()) {
                LifecycleElement currentElement = (LifecycleElement)elementQueue.poll();
                if (currentElement instanceof DataField) {
                    DataField dataField = (DataField)currentElement;
                    dataField.getBindingInfo().setDefaults(view, dataField.getPropertyName());
                    this.populateDefaultValueForField(model, dataField, dataField.getBindingInfo().getBindingPath());
                }
                elementQueue.addAll(ViewLifecycleUtils.getElementsForLifecycle(currentElement).values());
            }
        }
        finally {
            elementQueue.clear();
            RecycleUtils.recycle(elementQueue);
        }
    }

    @Override
    public void populateViewFromRequestParameters(Map<String, String> parameters) {
        View view = ViewLifecycle.getView();
        HashMap<String, HashSet<PropertyReplacer>> viewPropertyReplacers = new HashMap<String, HashSet<PropertyReplacer>>();
        List<PropertyReplacer> propertyReplacerSource = view.getPropertyReplacers();
        if (propertyReplacerSource != null) {
            for (PropertyReplacer replacer : propertyReplacerSource) {
                String replacerPropertyName = replacer.getPropertyName();
                HashSet<PropertyReplacer> propertyReplacers = (HashSet<PropertyReplacer>)viewPropertyReplacers.get(replacerPropertyName);
                if (propertyReplacers == null) {
                    propertyReplacers = new HashSet<PropertyReplacer>();
                    viewPropertyReplacers.put(replacerPropertyName, propertyReplacers);
                }
                propertyReplacers.add(replacer);
            }
        }
        Map<String, Annotation> annotatedFields = CopyUtils.getFieldsWithAnnotation(view.getClass(), RequestParameter.class);
        HashMap<String, String> viewRequestParameters = new HashMap<String, String>();
        for (String fieldToPopulate : annotatedFields.keySet()) {
            String fieldValue;
            RequestParameter requestParameter = (RequestParameter)annotatedFields.get(fieldToPopulate);
            String requestParameterName = requestParameter.parameterName();
            if (StringUtils.isBlank((String)requestParameterName)) {
                requestParameterName = fieldToPopulate;
            }
            if (!parameters.containsKey(requestParameterName) || !StringUtils.isNotBlank((String)(fieldValue = parameters.get(requestParameterName)))) continue;
            viewRequestParameters.put(requestParameterName, fieldValue);
            ObjectPropertyUtils.setPropertyValue(view, fieldToPopulate, fieldValue);
            if (view.getPropertyExpressions().containsKey(fieldToPopulate)) {
                view.getPropertyExpressions().remove(fieldToPopulate);
            }
            if (!viewPropertyReplacers.containsKey(fieldToPopulate)) continue;
            Set propertyReplacers = (Set)viewPropertyReplacers.get(fieldToPopulate);
            for (PropertyReplacer replacer : propertyReplacers) {
                view.getPropertyReplacers().remove(replacer);
            }
        }
        view.setViewRequestParameters(viewRequestParameters);
    }

    @Override
    public String buildGrowlScript() {
        View view = ViewLifecycle.getView();
        Object growlScript = "";
        MessageService messageService = KRADServiceLocatorWeb.getMessageService();
        MessageMap messageMap = GlobalVariables.getMessageMap();
        for (GrowlMessage growl : messageMap.getGrowlMessages()) {
            if (view.isGrowlMessagingEnabled()) {
                String message = messageService.getMessageText(growl.getNamespaceCode(), growl.getComponentCode(), growl.getMessageKey());
                if (!StringUtils.isNotBlank((String)message)) continue;
                if (growl.getMessageParameters() != null) {
                    message = message.replace("'", "''");
                    message = MessageFormat.format(message, growl.getMessageParameters());
                }
                message = message.replace("'", "\\'");
                String title = growl.getTitle();
                if (StringUtils.isNotBlank((String)growl.getTitleKey())) {
                    title = messageService.getMessageText(growl.getNamespaceCode(), growl.getComponentCode(), growl.getTitleKey());
                }
                title = title.replace("'", "\\'");
                growlScript = (String)growlScript + "showGrowl('" + message + "', '" + title + "', '" + growl.getTheme() + "');";
                continue;
            }
            ErrorMessage infoMessage = new ErrorMessage(growl.getMessageKey(), growl.getMessageParameters());
            infoMessage.setNamespaceCode(growl.getNamespaceCode());
            infoMessage.setComponentCode(growl.getComponentCode());
            messageMap.putInfoForSectionId("GLOBAL_INFO", infoMessage);
        }
        return growlScript;
    }

    @Override
    public void populateDefaultValueForField(Object object, DataField dataField, String bindingPath) {
        try {
            if (!ObjectPropertyUtils.isReadableProperty(object, bindingPath) || !ObjectPropertyUtils.isWritableProperty(object, bindingPath)) {
                return;
            }
        }
        catch (RuntimeException e) {
            LOG.warn("No property with binding path '" + bindingPath + "' is readable on '" + String.valueOf(object) + "'" + e.getMessage());
            return;
        }
        if (ObjectPropertyUtils.getPropertyValue(object, bindingPath) != null) {
            return;
        }
        Object defaultValue = this.getDefaultValueForField(object, dataField);
        if (defaultValue != null) {
            ObjectPropertyUtils.setPropertyValue(object, bindingPath, defaultValue);
        }
    }

    @Override
    public Object getDefaultValueForField(Object object, DataField dataField) {
        View view = ViewLifecycle.getView();
        Object defaultValue = null;
        if (!(dataField.getDefaultValue() == null || dataField.getDefaultValue() instanceof String && StringUtils.isBlank((String)((String)dataField.getDefaultValue())))) {
            defaultValue = dataField.getDefaultValue();
        } else if (dataField.getExpressionGraph() != null && dataField.getExpressionGraph().containsKey("defaultValue")) {
            defaultValue = dataField.getExpressionGraph().get("defaultValue");
        } else if (dataField.getDefaultValueFinderClass() != null) {
            ValueFinder defaultValueFinder = KRADUtils.createNewObjectFromClass(dataField.getDefaultValueFinderClass());
            defaultValue = defaultValueFinder.getValue();
        } else if (dataField.getExpressionGraph() != null && dataField.getExpressionGraph().containsKey("defaultValues")) {
            defaultValue = dataField.getExpressionGraph().get("defaultValues");
        } else if (dataField.getDefaultValues() != null) {
            defaultValue = dataField.getDefaultValues();
        }
        ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
        if (defaultValue != null && defaultValue instanceof String && expressionEvaluator.containsElPlaceholder((String)defaultValue)) {
            HashMap<String, Object> context = new HashMap<String, Object>(view.getPreModelContext());
            context.putAll(dataField.getContext());
            defaultValue = expressionEvaluator.replaceBindingPrefixes(view, object, (String)defaultValue);
            defaultValue = expressionEvaluator.evaluateExpressionTemplate(context, (String)defaultValue);
        }
        return defaultValue;
    }

    @Override
    public void refreshReference(Object parentObject, String referenceObjectName) {
        if (!(parentObject instanceof PersistableBusinessObjectBaseAdapter)) {
            KRADServiceLocator.getDataObjectService().wrap(parentObject).fetchRelationship(referenceObjectName);
        } else {
            LegacyDataAdapter legacyDataAdapter = KRADServiceLocatorWeb.getLegacyDataAdapter();
            DataDictionaryService dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
            if (legacyDataAdapter.hasReference(parentObject.getClass(), referenceObjectName) || legacyDataAdapter.hasCollection(parentObject.getClass(), referenceObjectName)) {
                legacyDataAdapter.retrieveReferenceObject(parentObject, referenceObjectName);
            } else if (dataDictionaryService.hasRelationship(parentObject.getClass().getName(), referenceObjectName)) {
                Object referenceObject = KradDataServiceLocator.getDataObjectService().wrap(parentObject).getPropertyValue(referenceObjectName);
                if (!(referenceObject instanceof PersistableBusinessObjectBaseAdapter)) {
                    LOG.warn("Could not refresh reference " + referenceObjectName + " off class " + parentObject.getClass().getName() + ". Class not of type PersistableBusinessObject");
                    return;
                }
                if ((referenceObject = legacyDataAdapter.retrieve(referenceObject)) == null) {
                    LOG.warn("Could not refresh reference " + referenceObjectName + " off class " + parentObject.getClass().getName() + ".");
                    return;
                }
                try {
                    KRADUtils.setObjectProperty(parentObject, referenceObjectName, referenceObject);
                }
                catch (Exception e) {
                    LOG.error("Unable to refresh persistable business object: " + referenceObjectName + "\n" + e.getMessage());
                    throw new RuntimeException("Unable to refresh persistable business object: " + referenceObjectName + "\n" + e.getMessage(), e);
                }
            } else {
                LOG.warn("Could not refresh reference " + referenceObjectName + " off class " + parentObject.getClass().getName() + ".");
            }
        }
    }

    @Override
    public void refreshReferences(String referencesToRefresh) {
        Object model = ViewLifecycle.getModel();
        for (String reference : StringUtils.split((String)referencesToRefresh, (String)",")) {
            if (StringUtils.isBlank((String)reference)) continue;
            if (PropertyAccessorUtils.isNestedOrIndexedProperty((String)reference)) {
                String parentPath = KRADUtils.getNestedAttributePrefix(reference);
                Object parentObject = ObjectPropertyUtils.getPropertyValue(model, parentPath);
                String referenceObjectName = KRADUtils.getNestedAttributePrimitive(reference);
                if (parentObject == null) {
                    LOG.warn("Unable to refresh references for " + referencesToRefresh + ". Object not found in model. Nothing refreshed.");
                    continue;
                }
                this.refreshReference(parentObject, referenceObjectName);
                continue;
            }
            this.refreshReference(model, reference);
        }
    }

    @Override
    public void retrieveEditModesAndActionFlags() {
        RequestAuthorizationCache requestAuthorizationCache;
        View view = ViewLifecycle.getView();
        UifFormBase model = (UifFormBase)ViewLifecycle.getModel();
        ViewPresentationController presentationController = view.getPresentationController();
        ViewAuthorizer authorizer = view.getAuthorizer();
        try {
            requestAuthorizationCache = view.getRequestAuthorizationCacheClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create instance of request authorization cache class", e);
        }
        presentationController.setRequestAuthorizationCache(requestAuthorizationCache);
        authorizer.setRequestAuthorizationCache(requestAuthorizationCache);
        Set<String> actionFlags = presentationController.getActionFlags(view, model);
        Set<String> editModes = presentationController.getEditModes(view, model);
        if (GlobalVariables.getUserSession() != null) {
            Person user = GlobalVariables.getUserSession().getPerson();
            actionFlags = authorizer.getActionFlags(view, model, user, actionFlags);
            editModes = authorizer.getEditModes(view, model, user, editModes);
        }
        view.setActionFlags(new BooleanMap(actionFlags));
        view.setEditModes(new BooleanMap(editModes));
    }

    @Override
    public void setViewContext() {
        View view = ViewLifecycle.getView();
        view.pushAllToContext(view.getPreModelContext());
        for (Map.Entry<String, String> variableExpression : view.getExpressionVariables().entrySet()) {
            String variableName = variableExpression.getKey();
            Object value = ViewLifecycle.getExpressionEvaluator().evaluateExpression(view.getContext(), variableExpression.getValue());
            view.pushObjectToContext(variableName, value);
        }
    }

    @Override
    public void setElementContext(LifecycleElement element, LifecycleElement parent) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        View view = ViewLifecycle.getView();
        Map<String, Object> viewContext = view.getContext();
        if (viewContext != null) {
            context.putAll(viewContext);
        }
        context.put("component", element instanceof Component ? element : parent);
        if (parent != null) {
            context.put("parent", parent);
        }
        if (element instanceof LayoutManager) {
            context.put("manager", element);
        }
        element.pushAllToContext(context);
    }

    public String getCurrentPersonContactId() {
        return GlobalVariables.getUserSession() == null ? "guest" : StringEscapeUtils.escapeEcmaScript((String)GlobalVariables.getUserSession().getPerson().getEmailAddressUnmasked());
    }

    protected ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = CoreApiServiceLocator.getKualiConfigurationService();
        }
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    protected DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    protected ViewDictionaryService getViewDictionaryService() {
        if (this.viewDictionaryService == null) {
            this.viewDictionaryService = KRADServiceLocatorWeb.getViewDictionaryService();
        }
        return this.viewDictionaryService;
    }

    public void setViewDictionaryService(ViewDictionaryService viewDictionaryService) {
        this.viewDictionaryService = viewDictionaryService;
    }

    @Override
    public ExpressionEvaluatorFactory getExpressionEvaluatorFactory() {
        if (this.expressionEvaluatorFactory == null) {
            this.expressionEvaluatorFactory = KRADServiceLocatorWeb.getExpressionEvaluatorFactory();
        }
        return this.expressionEvaluatorFactory;
    }

    public void setExpressionEvaluatorFactory(ExpressionEvaluatorFactory expressionEvaluatorFactory) {
        this.expressionEvaluatorFactory = expressionEvaluatorFactory;
    }

    protected LegacyDataAdapter getLegacyDataAdapter() {
        if (this.legacyDataAdapter == null) {
            this.legacyDataAdapter = KRADServiceLocatorWeb.getLegacyDataAdapter();
        }
        return this.legacyDataAdapter;
    }

    protected DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KRADServiceLocator.getDataObjectService();
        }
        return this.dataObjectService;
    }

    protected void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }

    protected void logAndThrowRuntime(String message) {
        LOG.error(message);
        throw new RuntimeException(message);
    }
}

