/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.impl;

import org.kuali.rice.krad.datadictionary.FieldOverride;

import java.util.List;

/**
 * A Field Override used to delete elements from a Data Dictionary bean.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class FieldOverrideForListElementDeleteImpl extends FieldOverrideForListElementBase implements FieldOverride {

    @Override
    public Object performFieldOverride(Object bean, Object property) {
        List oldList = (List) property;

        int deletePos = getElementPositionInList(this.getElement(), oldList);

        if (deletePos < 0) {
            throw new RuntimeException(
                    "Element to be deleted could not be found:bean=" + bean + ", property=" + property);
        } else {
            oldList.remove(deletePos);
        }
        return oldList;
    }
}
