/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.mask;

import java.io.Serializable;

/**
 * Defines interface for a class that mask data values
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface MaskFormatter extends Serializable {

    /**
     * Takes in the real data value and returns a masked string.
     *
     * @param value - data value
     * @return String - masked value
     */
    public String maskValue(Object value);

}
