/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation.capability;

import org.kuali.rice.krad.datadictionary.validation.constraint.CollectionSizeConstraint;

/**
 * Validation capability to constrain a value of type collection to a specific minimum and maximum
 * number of elements.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @since 1.1
 */
public interface CollectionSizeConstrainable extends Constrainable, CollectionSizeConstraint {

    // To match up with legacy code for length and range constraints, collection size constraints are themselves imposed
    // on the definition, making the capability a sub-interface of the constraint

}
