/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.service;

import org.kuali.rice.krad.exception.KualiExceptionIncident;

import java.util.Map;

/**
 * This is used for sending report of an incident
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public interface KualiExceptionIncidentService extends KualiFeedbackService {

    /**
     * This method send email to the defined mailing list using the exception incident
     * instance.
     *
     * @param exceptionIncident
     * @throws Exception
     */
    public void report(KualiExceptionIncident exceptionIncident) throws Exception;

    /**
     * This method create an instance of the KualiExceptionIncident from its factory.
     *
     * @param exception
     * @param properties Additional information when the exception is thrown
     * <p>example:
     * <ul>
     * <li>Document id</li>
     * <li>User email</li>
     * <li>User name</li>
     * <li>Component name</li>
     * </ul>
     * @return incident report
     */
    public KualiExceptionIncident getExceptionIncident(
            Exception exception, Map<String, String> properties);

    /**
     * This method create an instance of the KualiExceptionIncident from its factory.
     * This method is used when the thrown exception is not available. It's an implicit
     * initialization.
     *
     * @param properties The list of name-value pairs containing the thrown exception
     * information
     * @return incident report
     */
    public KualiExceptionIncident getExceptionIncident(Map<String, String> properties);
}
