/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle;

import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.View;

/**
 * Interface that must be implemented by components that wish to be notified of a lifecycle event.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface LifecycleEventListener {

    /**
     * Invoked on a component listener when an event occurs for the given event component.
     *
     * @param lifecycleEvent event that occurred
     * @param view view instance the lifecycle is being processed for
     * @param model object containing the model data
     * @param eventElement element instance the event occurred on/for
     */
    void processEvent(ViewLifecycle.LifecycleEvent lifecycleEvent, View view, Object model,
            LifecycleElement eventElement);
    
}
