/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle.finalize;

import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.util.LifecycleElement;

/**
 * If the data field has a configured property editor registers the editor with the view
 * post metadata.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @see org.kuali.rice.krad.uif.field.DataField#getPropertyEditor()
 */
public class RegisterPropertyEditorTask extends ViewLifecycleTaskBase<DataField> {

    public RegisterPropertyEditorTask() {
        super(DataField.class);
    }

    @Override
    protected void performLifecycleTask() {
        LifecycleElement element = getElementState().getElement();

        if (!(element instanceof DataField)) {
            return;
        }

        DataField dataField = (DataField) element;

        if ((dataField.getPropertyEditor() == null) || !dataField.isRender()) {
            return;
        }

        ViewPostMetadata viewPostMetadata = ViewLifecycle.getViewPostMetadata();
        if (dataField.hasSecureValue()) {
            viewPostMetadata.addSecureFieldPropertyEditor(dataField.getBindingInfo().getBindingPath(),
                    dataField.getPropertyEditor());
        } else {
            viewPostMetadata.addFieldPropertyEditor(dataField.getBindingInfo().getBindingPath(),
                    dataField.getPropertyEditor());
        }
    }
}
