/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBeanBase;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;

/**
 * A container that holds all of the {@link WorkflowAttributeDefinition} for a document for both document searches
 * and routing that depends on the values that exist on the document.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "workflowAttributes")
public class WorkflowAttributes extends UifDictionaryBeanBase {
    private static final long serialVersionUID = 6435015497886060280L;

    private List<SearchingTypeDefinition> searchingTypeDefinitions;
    private Map<String, RoutingTypeDefinition> routingTypeDefinitions;

    public WorkflowAttributes() {
        searchingTypeDefinitions = new ArrayList<SearchingTypeDefinition>();
        routingTypeDefinitions = new HashMap<String, RoutingTypeDefinition>();
    }

    /**
     * @return the searchingTypeDefinitions
     */
    @BeanTagAttribute(name = "searchingTypeDefinitions", type = BeanTagAttribute.AttributeType.LISTBEAN)
    public List<SearchingTypeDefinition> getSearchingTypeDefinitions() {
        return this.searchingTypeDefinitions;
    }

    /**
     * @param searchingTypeDefinitions the searchingTypeDefinitions to set
     */
    public void setSearchingTypeDefinitions(List<SearchingTypeDefinition> searchingTypeDefinitions) {
        this.searchingTypeDefinitions = searchingTypeDefinitions;
    }

    @BeanTagAttribute(name = "routingTypeDefinitions", type = BeanTagAttribute.AttributeType.MAPBEAN)
    public Map<String, RoutingTypeDefinition> getRoutingTypeDefinitions() {
        return this.routingTypeDefinitions;
    }

    public void setRoutingTypeDefinitions(Map<String, RoutingTypeDefinition> routingTypeDefinitions) {
        this.routingTypeDefinitions = routingTypeDefinitions;
    }

    @Override
    public void dataDictionaryPostProcessing() {
        for (SearchingTypeDefinition definition : searchingTypeDefinitions) {
            definition.dataDictionaryPostProcessing();
        }
        for (RoutingTypeDefinition definition : routingTypeDefinitions.values()) {
            definition.dataDictionaryPostProcessing();
        }
    }

    public void completeValidation(Class<?> rootBusinessObjectClass, Class<?> otherBusinessObjectClass, ValidationTrace tracer) {
        for (SearchingTypeDefinition definition : searchingTypeDefinitions) {
            definition.completeValidation(rootBusinessObjectClass, otherBusinessObjectClass,tracer);
        }
        for (RoutingTypeDefinition definition : routingTypeDefinitions.values()) {
            definition.completeValidation(rootBusinessObjectClass, otherBusinessObjectClass,tracer);
        }
    }

}
