/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.maintenance;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * Provides contract for the data object of the bulk update maintenance document.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface BulkUpdateMaintenanceDataObject extends Serializable {

    /**
     * Returns the list of fields of the maintenance documents to be updated along with the new value.
     *
     * @return map where the key is the maintenance document field to be updated and the value is the new value of the
     *         field
     */
    Map<String, ?> getUpdateFieldValues();

    /**
     * Returns the list of data objects of the maintenance documents that are to be updated.
     *
     * @return list of data objects to be updated
     */
    List<?> getTargetUpdateDataObjects();
}
