/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary;

import org.kuali.rice.krad.uif.util.CopyUtils;

/**
 * Marks KRAD framework objects that support deep copying.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface Copyable extends Cloneable {

    /**
     * Override {@link Object#clone()} to assign the public modifier.
     * @return {@link Object#clone()}
     * @throws CloneNotSupportedException If {@link Cloneable} is not implemented. This should not
     *         be possible when using this interface.
     * 
     * @see CopyUtils#isUseClone() When cloning is enabled, {@link #clone} is used for shallow copy
     *      operations.
     * @see Cloneable
     * @see Object#clone()
     */
    Object clone() throws CloneNotSupportedException;

}
