/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.util;

/**
 * An object that represents a simple suggestion with a label, value, and href.  For use with simple LocationSuggest
 * widget result methods.  This class is also available for extension.
 */
public class SimpleLocationSuggestObject extends SimpleSuggestObject{
    private String href;

    /**
     * Create SimpleLocationSuggestObject
     *
     * @param label the label to show for the suggestion
     * @param value the value to insert when the label is selected
     * @param href the href(url) to navigate to
     */
    public SimpleLocationSuggestObject(String label, String value, String href) {
        super(label, value);
        this.href = href;
    }

    /**
     * The href to navigate to for this suggestion
     *
     * @return the href(url)
     */
    public String getHref() {
        return href;
    }

    /**
     * Set the href
     *
     * @param href
     */
    public void setHref(String href) {
        this.href = href;
    }
}
