/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.widget;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;

/**
 * The breadcrumb widget contains various settings for setting up
 * Breadcrumb/History support on the view
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "breadcrumbs", parent = "Uif-Breadcrumbs")
public class Breadcrumbs extends WidgetBase {
    private static final long serialVersionUID = -2864287914665842251L;

    private boolean displayBreadcrumbsWhenOne;
    private boolean usePathBasedBreadcrumbs;

    public Breadcrumbs() {
        super();
    }

    /**
     * If false, breadcrumbs will not be displayed if only one breadcrumb is
     * going to be shown, this improves visual clarity of the page
     *
     * @return the displayBreadcrumbsWhenOne
     */
    @BeanTagAttribute
    public boolean isDisplayBreadcrumbsWhenOne() {
        return this.displayBreadcrumbsWhenOne;
    }

    /**
     * Set displayBreadcrumbsWhenOne
     *
     * @param displayBreadcrumbsWhenOne the displayBreadcrumbsWhenOne to set
     */
    public void setDisplayBreadcrumbsWhenOne(boolean displayBreadcrumbsWhenOne) {
        this.displayBreadcrumbsWhenOne = displayBreadcrumbsWhenOne;
    }

    /**
     * If set to true, the breadcrumbs on the View will always be path-based (history backed)
     *
     * @return true if using path based breadcrumbs, false otherwise
     */
    @BeanTagAttribute
    public boolean isUsePathBasedBreadcrumbs() {
        return usePathBasedBreadcrumbs;
    }

    /**
     * Set usePathBasedBreadcrumbs to true to use path-based breadcrumbs
     *
     * @param usePathBasedBreadcrumbs
     */
    public void setUsePathBasedBreadcrumbs(boolean usePathBasedBreadcrumbs) {
        this.usePathBasedBreadcrumbs = usePathBasedBreadcrumbs;
    }
}
