/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.util.documentserializer;

import org.kuali.rice.krad.document.Document;

/**
 * Specifies an implementation used during document workflow XML serialization that
 * will be able to determine whether a specific property is serializable
 *
 */
public interface PropertySerializabilityEvaluator {

    /**
     * Initializes the evaluator so that calls to {@link #isPropertySerializable(SerializationState, Object, String, Object)} and
     * {@link #determinePropertyType(Object)} will function properly
     *
     * @param document the document instance
     */
    public void initializeEvaluatorForDocument(Document document);

    public void initializeEvaluatorForDataObject(Object businessObject);

    /**
     * Determines whether a child property of an object is serializable.
     *
     * @param state Information about the properties that have been serialized so far
     * @param containingObject The object containing the reference to childPropertyValue
     * @param childPropertyName The name property to determine whether to serialize, relative to containingObject (i.e. not a nested attribute)
     * @param childPropertyValue If serializable, this property would be serialized by the serializer service.
     * @return
     */
    public boolean isPropertySerializable(SerializationState state, Object containingObject, String childPropertyName, Object childPropertyValue);

    /**
     * Determines the type of a object
     *
     * @param object
     * @return
     */
    public PropertyType determinePropertyType(Object object);
}
