/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.uif.field.LinkField;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.util.UrlFactory;

@BeanTag(name="roleLinkField", parent="Uif-RoleLinkField")
public class RoleLinkField
extends LinkField {
    private static final long serialVersionUID = -7175947391547723712L;
    private static final Logger LOG = LogManager.getLogger(RoleLinkField.class);
    private String roleId;
    private String roleName;
    private String roleNamespaceCode;
    private String dataObjectClassName;
    private String baseInquiryUrl;
    private boolean namespaceInLinkText;
    private boolean disableLink;
    private Map<String, String> additionalInquiryParameters;

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (StringUtils.isNotBlank((String)this.roleId)) {
            this.setHref(this.buildInquiryUrl());
            this.setLinkText(this.getRoleNameByRoleId(this.roleId));
        } else {
            if (StringUtils.isNotBlank((String)this.roleName) && StringUtils.isNotBlank((String)this.roleNamespaceCode)) {
                this.setHref(this.buildInquiryUrl());
                this.setLinkText(this.getRoleNameByNamespaceAndName(this.roleNamespaceCode, this.roleName));
            }
            if (StringUtils.isBlank((String)this.roleName) && StringUtils.isNotBlank((String)this.roleNamespaceCode)) {
                this.setDisableLink(true);
                if (this.isNamespaceInLinkText()) {
                    this.setLinkText(this.roleNamespaceCode);
                }
            }
            if (StringUtils.isNotBlank((String)this.roleName) && StringUtils.isBlank((String)this.roleNamespaceCode)) {
                this.setDisableLink(true);
                this.setLinkText(this.roleName);
            }
        }
        if (StringUtils.isBlank((String)this.getHref())) {
            this.setDisableLink(true);
        }
        if (StringUtils.isBlank((String)this.getLinkText())) {
            this.setLinkText("&nbsp;");
        }
    }

    protected String buildInquiryUrl() {
        Class<?> inquiryObjectClass;
        try {
            inquiryObjectClass = Class.forName(this.getDataObjectClassName());
        }
        catch (ClassNotFoundException e) {
            LOG.error("Unable to get class for: " + this.getDataObjectClassName());
            throw new RuntimeException(e);
        }
        Properties urlParameters = new Properties();
        urlParameters.setProperty("dataObjectClassName", inquiryObjectClass.getName());
        urlParameters.setProperty("methodToCall", "start");
        if (StringUtils.isNotBlank((String)this.roleId)) {
            urlParameters.setProperty("id", this.roleId);
        } else if (StringUtils.isNotBlank((String)this.roleName)) {
            urlParameters.setProperty("name", this.roleName);
            urlParameters.setProperty("namespaceCode", this.roleNamespaceCode);
        }
        for (Map.Entry<String, String> inquiryParameter : this.additionalInquiryParameters.entrySet()) {
            urlParameters.setProperty(inquiryParameter.getKey(), inquiryParameter.getValue());
        }
        ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(inquiryObjectClass);
        String inquiryUrl = responsibleModuleService != null && responsibleModuleService.isExternalizable(inquiryObjectClass) ? responsibleModuleService.getExternalizableDataObjectInquiryUrl(inquiryObjectClass, urlParameters) : UrlFactory.parameterizeUrl((String)this.getBaseInquiryUrl(), (Properties)urlParameters);
        return inquiryUrl;
    }

    protected String getRoleNameByRoleId(String roleId) {
        Role role = KimApiServiceLocator.getRoleService().getRole(roleId);
        if (role == null) {
            this.setDisableLink(true);
            return roleId;
        }
        if (this.isNamespaceInLinkText()) {
            return role.getNamespaceCode() + " " + role.getName();
        }
        return role.getName();
    }

    protected String getRoleNameByNamespaceAndName(String namespaceCode, String roleName) {
        Role role = KimApiServiceLocator.getRoleService().getRoleByNamespaceCodeAndName(namespaceCode, roleName);
        if (role == null) {
            this.setDisableLink(true);
            if (this.isNamespaceInLinkText()) {
                return this.roleNamespaceCode + " " + this.roleName;
            }
            return this.roleName;
        }
        if (this.isNamespaceInLinkText()) {
            return role.getNamespaceCode() + " " + role.getName();
        }
        return role.getName();
    }

    @BeanTagAttribute
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @BeanTagAttribute
    public String getRoleNamespaceCode() {
        return this.roleNamespaceCode;
    }

    public void setRoleNamespaceCode(String roleNamespaceCode) {
        this.roleNamespaceCode = roleNamespaceCode;
    }

    @BeanTagAttribute
    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    @BeanTagAttribute
    public String getDataObjectClassName() {
        return this.dataObjectClassName;
    }

    public void setDataObjectClassName(String dataObjectClassName) {
        this.dataObjectClassName = dataObjectClassName;
    }

    @BeanTagAttribute
    public String getBaseInquiryUrl() {
        return this.baseInquiryUrl;
    }

    public void setBaseInquiryUrl(String baseInquiryUrl) {
        this.baseInquiryUrl = baseInquiryUrl;
    }

    @BeanTagAttribute
    public boolean isNamespaceInLinkText() {
        return this.namespaceInLinkText;
    }

    public void setNamespaceInLinkText(boolean namespaceInLinkText) {
        this.namespaceInLinkText = namespaceInLinkText;
    }

    @BeanTagAttribute
    public boolean isDisableLink() {
        return this.disableLink;
    }

    public void setDisableLink(boolean disableLink) {
        this.disableLink = disableLink;
    }

    @BeanTagAttribute
    public Map<String, String> getAdditionalInquiryParameters() {
        return this.additionalInquiryParameters;
    }

    public void setAdditionalInquiryParameters(Map<String, String> additionalInquiryParameters) {
        this.additionalInquiryParameters = additionalInquiryParameters;
    }
}

