/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle.initialize;

import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBean;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;

/**
 * Populate property values on the component from the expression graph.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class PopulateComponentFromExpressionGraphTask extends ViewLifecycleTaskBase<UifDictionaryBean> {

    public PopulateComponentFromExpressionGraphTask() {
        super(UifDictionaryBean.class);
    }

    @Override
    protected void performLifecycleTask() {
        // the component can have an expression graph for which the expressions need pulled to
        // the list the expression service will evaluate
        ViewLifecycle.getExpressionEvaluator().populatePropertyExpressionsFromGraph(
                (UifDictionaryBean) getElementState().getElement(), true);
    }

}
