/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.type;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.krms.api.repository.type.KrmsTypeAttributeContract;
import org.w3c.dom.Element;

@XmlRootElement(name="krmsTypeAttribute")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="KrmsTypeAttributeType", propOrder={"id", "typeId", "attributeDefinitionId", "sequenceNumber", "active", "versionNumber", "_futureElements"})
public final class KrmsTypeAttribute
extends AbstractDataTransferObject
implements KrmsTypeAttributeContract {
    private static final long serialVersionUID = -304265575559412478L;
    @XmlElement(name="id", required=false)
    private String id;
    @XmlElement(name="typeId", required=true)
    private String typeId;
    @XmlElement(name="attributeDefinitionId", required=true)
    private String attributeDefinitionId;
    @XmlElement(name="sequenceNumber", required=true)
    private Integer sequenceNumber;
    @XmlElement(name="active", required=false)
    private boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private KrmsTypeAttribute() {
        this.id = null;
        this.typeId = null;
        this.attributeDefinitionId = null;
        this.sequenceNumber = null;
        this.active = true;
        this.versionNumber = null;
    }

    private KrmsTypeAttribute(Builder builder) {
        this.id = builder.getId();
        this.typeId = builder.getTypeId();
        this.attributeDefinitionId = builder.getAttributeDefinitionId();
        this.sequenceNumber = builder.getSequenceNumber();
        this.active = builder.isActive();
        this.versionNumber = builder.getVersionNumber();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getTypeId() {
        return this.typeId;
    }

    @Override
    public String getAttributeDefinitionId() {
        return this.attributeDefinitionId;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public boolean isActive() {
        return this.active;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static class Builder
    implements KrmsTypeAttributeContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = 2729964674427296346L;
        private String id;
        private String typeId;
        private String attributeDefinitionId;
        private Integer sequenceNumber;
        private boolean active;
        private Long versionNumber;

        private Builder(String typeId, String attributeDefinitionId, Integer sequenceNumber) {
            this.setTypeId(typeId);
            this.setAttributeDefinitionId(attributeDefinitionId);
            this.setSequenceNumber(sequenceNumber);
            this.setActive(true);
        }

        public static Builder create(String typeId, String attributeDefinitionId, Integer sequenceNumber) {
            return new Builder(typeId, attributeDefinitionId, sequenceNumber);
        }

        public static Builder create(KrmsTypeAttributeContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract is null");
            }
            Builder builder = new Builder(contract.getTypeId(), contract.getAttributeDefinitionId(), contract.getSequenceNumber());
            builder.setId(contract.getId());
            builder.setVersionNumber(contract.getVersionNumber());
            return builder;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setTypeId(String typeId) {
            if (null != typeId && StringUtils.isBlank((String)typeId)) {
                throw new IllegalArgumentException("typeId must be null or non-blank");
            }
            this.typeId = typeId;
        }

        public void setAttributeDefinitionId(String attributeDefinitionId) {
            if (StringUtils.isBlank((String)attributeDefinitionId)) {
                throw new IllegalArgumentException("the attribute definition id is blank");
            }
            this.attributeDefinitionId = attributeDefinitionId;
        }

        public void setSequenceNumber(Integer sequenceNumber) {
            if (sequenceNumber == null) {
                throw new IllegalArgumentException("the sequence number is null");
            }
            this.sequenceNumber = sequenceNumber;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getTypeId() {
            return this.typeId;
        }

        @Override
        public String getAttributeDefinitionId() {
            return this.attributeDefinitionId;
        }

        @Override
        public Integer getSequenceNumber() {
            return this.sequenceNumber;
        }

        public boolean isActive() {
            return this.active;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public KrmsTypeAttribute build() {
            return new KrmsTypeAttribute(this);
        }
    }

    public static class Elements {
        static final String ID = "id";
        static final String TYPE_ID = "typeId";
        static final String ATTR_DEFN_ID = "attributeDefinitionId";
        public static final String SEQ_NO = "sequenceNumber";
        static final String ACTIVE = "active";
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "krmsTypeAttribute";
        static final String TYPE_NAME = "KrmsTypeAttributeType";

        Constants() {
        }
    }
}

