/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine;

import org.kuali.rice.krms.api.engine.ExecutionEnvironment;

/**
 * An Action executes on a given {@link org.kuali.rice.krms.api.engine.ExecutionEnvironment}
 *
 * @see org.kuali.rice.krms.api.repository.action.ActionDefinitionContract
 * @see org.kuali.rice.krms.api.repository.action.ActionDefinition
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface Action {

    /**
     * Execute on a given {@link org.kuali.rice.krms.api.engine.ExecutionEnvironment}.
     * @param environment {@link org.kuali.rice.krms.api.engine.ExecutionEnvironment} to execute.
     */
	public void execute(ExecutionEnvironment environment);

	/**
	 * The engine may be run in a simulation mode and in this case,
	 * most actions should not be executed.  However, if part or all of 
	 * an action needs to be run in order for proper rule evaluation to 
	 * proceed, it should be called herein.
     * @param environment {@link org.kuali.rice.krms.api.engine.ExecutionEnvironment} to simulate execution on.
	 */
	public void executeSimulation(ExecutionEnvironment environment);
}
