/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine.result;

import java.util.EventListener;

import org.kuali.rice.krms.api.engine.ResultEvent;

/**
 * Interface for receiving {@link ResultEvent}s.
 * @see ResultEvent
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface ResultListener extends EventListener {
    /**
     * Handle the given {@link ResultEvent}.
     * @param resultEvent {@link ResultEvent} to handle.
     */
	public void handleEvent(ResultEvent resultEvent);
}
