/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.type;

import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.framework.engine.Action;

/**
 * Interface defining the loading of an {@link Action} from a {@link ActionDefinition}
 *
 * @see Action
 * @see ActionDefinition
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public interface ActionTypeService extends RemotableAttributeOwner {

    /**
     * Load the {@link Action} given the {@link ActionDefinition}
     * @param actionDefinition {@link ActionDefinition} to create the {@link Action} from
     * @return {@link Action} created from the given {@link ActionDefinition}
     */
	public Action loadAction(ActionDefinition actionDefinition);

}
