/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine;

import java.util.List;

/**
 * A {@link BasicRule} that executes its {@link Action} when evaluation is false.
 */
public class FalseTriggeredRule extends BasicRule {

    /**
     * @param proposition
     * @param actions
     */
	public FalseTriggeredRule(Proposition proposition, List<Action> actions) {
		super(proposition, actions);
	}

	@Override
	protected boolean shouldExecuteAction(boolean ruleExecutionResult) {
		return !ruleExecutionResult;
	}

}
