/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine.result;

import org.kuali.rice.krms.api.engine.ResultEvent;

/**
 * An implementation of {@link ResultListener} which adds the {@link ResultEvent} to the {@link EngineResults} of that
 * event's environment
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class EngineResultListener implements ResultListener {

    /**
     * Constructor
     */
	public EngineResultListener(){}

    @Override
	public void handleEvent (ResultEvent event){
			event.getEnvironment().getEngineResults().addResult(event);
	}
	
}
