/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.type;

import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.framework.engine.Action;

/**
 * Interface defining the loading of a {@link ValidationAction} from a {@link ActionDefinition}
 *
 * @see ValidationAction
 * @see ActionDefinition
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public interface ValidationActionTypeService extends RemotableAttributeOwner, ActionTypeService {

    /**
     * VALIDATIONS_ACTION_ATTRIBUTE
     */
    static public final String VALIDATIONS_ACTION_ATTRIBUTE = "validations";

    /**
     * VALIDATIONS_ACTION_TYPE_CODE_ATTRIBUTE Database krms_attr_defn_t NM value
     */
    static public final String VALIDATIONS_ACTION_TYPE_CODE_ATTRIBUTE = "actionTypeCode"; // Database krms_attr_defn_t NM value

    /**
     * VALIDATIONS_ACTION_MESSAGE_ATTRIBUTE Database krms_attr_defn_t NM value
     */
    static public final String VALIDATIONS_ACTION_MESSAGE_ATTRIBUTE = "actionMessage"; // Database krms_attr_defn_t NM value

    @Override
	public Action loadAction(ActionDefinition actionDefinition);

    /**
     * Set the {@link ValidationActionService}.
     *
     * @param mockValidationService the {@link ValidationActionService} to use.
     * @throws org.kuali.rice.core.api.exception.RiceIllegalArgumentException if the given Validation Service is null
     */
    void setValidationService(ValidationActionService mockValidationService);
}
