/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.kuali.rice.krad.data.CopyOption;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinitionContract;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.impl.repository.AgendaAttributeBo;
import org.kuali.rice.krms.impl.repository.AgendaItemBo;
import org.kuali.rice.krms.impl.repository.ContextBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.RepositoryBoIncrementer;
import org.kuali.rice.krms.impl.repository.RuleBo;

@Entity
@Table(name="KRMS_AGENDA_T")
public class AgendaBo
implements AgendaDefinitionContract,
Serializable,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    private static final long serialVersionUID = 1L;
    public static final String AGENDA_SEQ_NAME = "KRMS_AGENDA_S";
    static final RepositoryBoIncrementer agendaIdIncrementer = new RepositoryBoIncrementer("KRMS_AGENDA_S");
    @PortableSequenceGenerator(name="KRMS_AGENDA_S")
    @GeneratedValue(generator="KRMS_AGENDA_S")
    @Id
    @Column(name="AGENDA_ID")
    private String id;
    @Column(name="NM")
    private String name;
    @Column(name="TYP_ID")
    private String typeId;
    @Column(name="CNTXT_ID")
    private String contextId;
    @Column(name="ACTV")
    @Convert(converter=BooleanYNConverter.class)
    private boolean active = true;
    @Column(name="INIT_AGENDA_ITM_ID", insertable=false, updatable=false)
    private String firstItemId;
    @ManyToOne(targetEntity=AgendaItemBo.class, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="INIT_AGENDA_ITM_ID")
    private AgendaItemBo firstItem;
    @Column(name="VER_NBR")
    @Version
    private Long versionNumber;
    @OneToMany(orphanRemoval=true, mappedBy="agenda", targetEntity=AgendaAttributeBo.class, cascade={CascadeType.REFRESH, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="AGENDA_ID", referencedColumnName="AGENDA_ID", insertable=true, updatable=true)
    private Set<AgendaAttributeBo> attributeBos;
    @OneToMany(orphanRemoval=true, targetEntity=AgendaItemBo.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="AGENDA_ID", referencedColumnName="AGENDA_ID", insertable=false, updatable=false)
    private List<AgendaItemBo> items = new ArrayList<AgendaItemBo>();
    @ManyToOne(targetEntity=ContextBo.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="CNTXT_ID", referencedColumnName="CNTXT_ID", insertable=false, updatable=false)
    private ContextBo context;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;

    public AgendaBo getAgenda() {
        return this;
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (this._persistence_get_attributeBos() != null) {
            for (AgendaAttributeBo attr : this._persistence_get_attributeBos()) {
                attributes.put(attr.getAttributeDefinition().getName(), attr.getValue());
            }
        }
        return attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this._persistence_set_attributeBos(new HashSet());
        if (!StringUtils.isBlank((String)this._persistence_get_typeId())) {
            List<KrmsAttributeDefinition> attributeDefinitions = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService().findAttributeDefinitionsByType(this.getTypeId());
            HashMap<String, KrmsAttributeDefinition> attributeDefinitionsByName = new HashMap<String, KrmsAttributeDefinition>();
            if (attributeDefinitions != null) {
                for (KrmsAttributeDefinition krmsAttributeDefinition : attributeDefinitions) {
                    attributeDefinitionsByName.put(krmsAttributeDefinition.getName(), krmsAttributeDefinition);
                }
            }
            for (Map.Entry entry : attributes.entrySet()) {
                KrmsAttributeDefinition attributeDefinition = (KrmsAttributeDefinition)attributeDefinitionsByName.get(entry.getKey());
                AgendaAttributeBo attributeBo = new AgendaAttributeBo();
                attributeBo.setAgenda(this);
                attributeBo.setValue((String)entry.getValue());
                attributeBo.setAttributeDefinition(KrmsAttributeDefinitionBo.from(attributeDefinition));
                this._persistence_get_attributeBos().add(attributeBo);
            }
        }
    }

    public AgendaBo copyAgenda(String newAgendaName, String dateTimeStamp) {
        List<AgendaItemBo> agendaItems = this.getItems();
        AgendaBo copiedAgenda = (AgendaBo)KradDataServiceLocator.getDataObjectService().copyInstance((Object)this, new CopyOption[]{CopyOption.RESET_PK_FIELDS, CopyOption.RESET_OBJECT_ID});
        copiedAgenda.setName(newAgendaName);
        copiedAgenda.setId(agendaIdIncrementer.getNewId());
        String initAgendaItemId = this.getFirstItemId();
        ArrayList<AgendaItemBo> copiedAgendaItems = new ArrayList<AgendaItemBo>();
        HashMap<String, RuleBo> oldRuleIdToNew = new HashMap<String, RuleBo>();
        HashMap<String, AgendaItemBo> oldAgendaItemIdToNew = new HashMap<String, AgendaItemBo>();
        for (AgendaItemBo agendaItem : agendaItems) {
            if (oldAgendaItemIdToNew.containsKey(agendaItem.getId())) continue;
            AgendaItemBo copiedAgendaItem = agendaItem.copyAgendaItem(copiedAgenda, oldRuleIdToNew, oldAgendaItemIdToNew, copiedAgendaItems, dateTimeStamp);
            if (initAgendaItemId != null && initAgendaItemId.equals(agendaItem.getId())) {
                copiedAgenda.setFirstItemId(copiedAgendaItem.getId());
                copiedAgenda.setFirstItem(copiedAgendaItem);
            }
            copiedAgendaItems.add(copiedAgendaItem);
            oldAgendaItemIdToNew.put(agendaItem.getId(), copiedAgendaItem);
        }
        copiedAgenda.setItems(copiedAgendaItems);
        return copiedAgenda;
    }

    public static AgendaDefinition to(AgendaBo bo) {
        if (bo == null) {
            return null;
        }
        return AgendaDefinition.Builder.create((AgendaDefinitionContract)bo).build();
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public String getTypeId() {
        return this._persistence_get_typeId();
    }

    public void setTypeId(String typeId) {
        this._persistence_set_typeId(typeId);
    }

    public String getContextId() {
        return this._persistence_get_contextId();
    }

    public void setContextId(String contextId) {
        this._persistence_set_contextId(contextId);
    }

    public boolean getActive() {
        return this._persistence_get_active();
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public String getFirstItemId() {
        return this._persistence_get_firstItemId();
    }

    public void setFirstItemId(String firstItemId) {
        this._persistence_set_firstItemId(firstItemId);
    }

    public AgendaItemBo getFirstItem() {
        return this._persistence_get_firstItem();
    }

    public void setFirstItem(AgendaItemBo firstItem) {
        this._persistence_set_firstItem(firstItem);
        if (firstItem != null) {
            this._persistence_set_firstItemId(firstItem.getId());
        }
    }

    public Set<AgendaAttributeBo> getAttributeBos() {
        return this._persistence_get_attributeBos();
    }

    public void setAttributeBos(Set<AgendaAttributeBo> attributeBos) {
        this._persistence_set_attributeBos(attributeBos);
    }

    public List<AgendaItemBo> getItems() {
        return this._persistence_get_items();
    }

    public void setItems(List<AgendaItemBo> items) {
        this._persistence_set_items(items);
    }

    public ContextBo getContext() {
        return this._persistence_get_context();
    }

    public void setContext(ContextBo context) {
        this._persistence_set_context(context);
    }

    public Long getVersionNumber() {
        return this._persistence_get_versionNumber();
    }

    public void setVersionNumber(Long versionNumber) {
        this._persistence_set_versionNumber(versionNumber);
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AgendaBo();
    }

    public Object _persistence_get(String string) {
        if (string == "id") {
            return this.id;
        }
        if (string == "attributeBos") {
            return this.attributeBos;
        }
        if (string == "contextId") {
            return this.contextId;
        }
        if (string == "items") {
            return this.items;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "context") {
            return this.context;
        }
        if (string == "firstItemId") {
            return this.firstItemId;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "firstItem") {
            return this.firstItem;
        }
        if (string == "typeId") {
            return this.typeId;
        }
        if (string == "versionNumber") {
            return this.versionNumber;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "attributeBos") {
            this.attributeBos = (Set)object;
            return;
        }
        if (string == "contextId") {
            this.contextId = (String)object;
            return;
        }
        if (string == "items") {
            this.items = (List)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "context") {
            this.context = (ContextBo)object;
            return;
        }
        if (string == "firstItemId") {
            this.firstItemId = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "firstItem") {
            this.firstItem = (AgendaItemBo)object;
            return;
        }
        if (string == "typeId") {
            this.typeId = (String)object;
            return;
        }
        if (string == "versionNumber") {
            this.versionNumber = (Long)object;
            return;
        }
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public Set _persistence_get_attributeBos() {
        this._persistence_checkFetched("attributeBos");
        return this.attributeBos;
    }

    public void _persistence_set_attributeBos(Set set) {
        this._persistence_checkFetchedForSet("attributeBos");
        this._persistence_propertyChange("attributeBos", this.attributeBos, set);
        this.attributeBos = set;
    }

    public String _persistence_get_contextId() {
        this._persistence_checkFetched("contextId");
        return this.contextId;
    }

    public void _persistence_set_contextId(String string) {
        this._persistence_checkFetchedForSet("contextId");
        this._persistence_propertyChange("contextId", this.contextId, string);
        this.contextId = string;
    }

    public List _persistence_get_items() {
        this._persistence_checkFetched("items");
        return this.items;
    }

    public void _persistence_set_items(List list) {
        this._persistence_checkFetchedForSet("items");
        this._persistence_propertyChange("items", this.items, list);
        this.items = list;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", this.name, string);
        this.name = string;
    }

    public ContextBo _persistence_get_context() {
        this._persistence_checkFetched("context");
        return this.context;
    }

    public void _persistence_set_context(ContextBo contextBo) {
        this._persistence_checkFetchedForSet("context");
        this._persistence_propertyChange("context", this.context, contextBo);
        this.context = contextBo;
    }

    public String _persistence_get_firstItemId() {
        this._persistence_checkFetched("firstItemId");
        return this.firstItemId;
    }

    public void _persistence_set_firstItemId(String string) {
        this._persistence_checkFetchedForSet("firstItemId");
        this._persistence_propertyChange("firstItemId", this.firstItemId, string);
        this.firstItemId = string;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public AgendaItemBo _persistence_get_firstItem() {
        this._persistence_checkFetched("firstItem");
        return this.firstItem;
    }

    public void _persistence_set_firstItem(AgendaItemBo agendaItemBo) {
        this._persistence_checkFetchedForSet("firstItem");
        this._persistence_propertyChange("firstItem", this.firstItem, agendaItemBo);
        this.firstItem = agendaItemBo;
    }

    public String _persistence_get_typeId() {
        this._persistence_checkFetched("typeId");
        return this.typeId;
    }

    public void _persistence_set_typeId(String string) {
        this._persistence_checkFetchedForSet("typeId");
        this._persistence_propertyChange("typeId", this.typeId, string);
        this.typeId = string;
    }

    public Long _persistence_get_versionNumber() {
        this._persistence_checkFetched("versionNumber");
        return this.versionNumber;
    }

    public void _persistence_set_versionNumber(Long l) {
        this._persistence_checkFetchedForSet("versionNumber");
        this._persistence_propertyChange("versionNumber", this.versionNumber, l);
        this.versionNumber = l;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }
}

