/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.krms.api.repository.NaturalLanguageTree;
import org.kuali.rice.krms.api.repository.RuleManagementService;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.action.ActionDefinitionContract;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinitionContract;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinitionContract;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeDefinition;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.context.ContextDefinitionContract;
import org.kuali.rice.krms.api.repository.context.ContextSelectionCriteria;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplate;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplateContract;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplaterContract;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageUsage;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageUsageContract;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinitionContract;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameter;
import org.kuali.rice.krms.api.repository.reference.ReferenceObjectBinding;
import org.kuali.rice.krms.api.repository.reference.ReferenceObjectBindingContract;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinitionContract;
import org.kuali.rice.krms.api.repository.term.TermDefinition;
import org.kuali.rice.krms.api.repository.term.TermRepositoryService;
import org.kuali.rice.krms.impl.repository.TranslationUtility;
import org.kuali.rice.krms.impl.repository.language.SimpleNaturalLanguageTemplater;
import org.kuali.rice.krms.impl.repository.mock.CriteriaMatcherInMemory;

public class RuleManagementServiceMockImpl
implements RuleManagementService {
    private Map<String, ReferenceObjectBinding> referenceObjectBindingMap = new LinkedHashMap<String, ReferenceObjectBinding>();
    private Map<String, ContextDefinition> contextMap = new LinkedHashMap<String, ContextDefinition>();
    private Map<String, AgendaDefinition> agendaMap = new LinkedHashMap<String, AgendaDefinition>();
    private Map<String, AgendaItemDefinition> agendaItemMap = new LinkedHashMap<String, AgendaItemDefinition>();
    private Map<String, RuleDefinition> ruleMap = new LinkedHashMap<String, RuleDefinition>();
    private Map<String, ActionDefinition> actionMap = new LinkedHashMap<String, ActionDefinition>();
    private Map<String, PropositionDefinition> propositionMap = new LinkedHashMap<String, PropositionDefinition>();
    private Map<String, NaturalLanguageUsage> naturalLanguageUsageMap = new LinkedHashMap<String, NaturalLanguageUsage>();
    private Map<String, NaturalLanguageTemplate> naturalLanguageTemplateMap = new LinkedHashMap<String, NaturalLanguageTemplate>();
    private NaturalLanguageTemplaterContract templater = new SimpleNaturalLanguageTemplater();
    private TermRepositoryService termRepositoryService;

    public NaturalLanguageTemplaterContract getTemplater() {
        return this.templater;
    }

    public void setTemplater(NaturalLanguageTemplaterContract templater) {
        this.templater = templater;
    }

    public TermRepositoryService getTermRepositoryService() {
        return this.termRepositoryService;
    }

    public void setTermRepositoryService(TermRepositoryService termRepositoryService) {
        this.termRepositoryService = termRepositoryService;
    }

    public void clear() {
        this.referenceObjectBindingMap.clear();
        this.contextMap.clear();
        this.agendaMap.clear();
        this.agendaItemMap.clear();
        this.ruleMap.clear();
        this.actionMap.clear();
        this.propositionMap.clear();
        this.naturalLanguageUsageMap.clear();
        this.naturalLanguageTemplateMap.clear();
    }

    public ReferenceObjectBinding createReferenceObjectBinding(ReferenceObjectBinding referenceObjectDefinition) throws RiceIllegalArgumentException {
        ReferenceObjectBinding orig = this.getReferenceObjectBinding(referenceObjectDefinition.getId());
        if (orig != null) {
            throw new RiceIllegalArgumentException(referenceObjectDefinition.getId());
        }
        ReferenceObjectBinding.Builder copy = ReferenceObjectBinding.Builder.create((ReferenceObjectBindingContract)referenceObjectDefinition);
        if (copy.getId() == null) {
            copy.setId(UUID.randomUUID().toString());
        }
        referenceObjectDefinition = copy.build();
        this.referenceObjectBindingMap.put(referenceObjectDefinition.getId(), referenceObjectDefinition);
        return referenceObjectDefinition;
    }

    public ReferenceObjectBinding getReferenceObjectBinding(String id) throws RiceIllegalArgumentException {
        if (!this.referenceObjectBindingMap.containsKey(id)) {
            throw new RiceIllegalArgumentException(id);
        }
        return this.referenceObjectBindingMap.get(id);
    }

    public List<ReferenceObjectBinding> getReferenceObjectBindings(List<String> ids) throws RiceIllegalArgumentException {
        ArrayList<ReferenceObjectBinding> list = new ArrayList<ReferenceObjectBinding>();
        for (String id : ids) {
            list.add(this.getReferenceObjectBinding(id));
        }
        return list;
    }

    public List<ReferenceObjectBinding> findReferenceObjectBindingsByReferenceDiscriminatorType(String referenceObjectReferenceDiscriminatorType) throws RiceIllegalArgumentException {
        ArrayList<ReferenceObjectBinding> list = new ArrayList<ReferenceObjectBinding>();
        for (ReferenceObjectBinding info : this.referenceObjectBindingMap.values()) {
            if (!info.getReferenceDiscriminatorType().equals(referenceObjectReferenceDiscriminatorType)) continue;
            list.add(info);
        }
        return list;
    }

    public List<ReferenceObjectBinding> findReferenceObjectBindingsByReferenceObject(String referenceObjectReferenceDiscriminatorType, String referenceObjectId) throws RiceIllegalArgumentException {
        ArrayList<ReferenceObjectBinding> list = new ArrayList<ReferenceObjectBinding>();
        for (ReferenceObjectBinding info : this.referenceObjectBindingMap.values()) {
            if (!info.getReferenceDiscriminatorType().equals(referenceObjectReferenceDiscriminatorType)) continue;
            list.add(info);
        }
        return list;
    }

    public List<ReferenceObjectBinding> findReferenceObjectBindingsByKrmsDiscriminatorType(String referenceObjectKrmsDiscriminatorType) throws RiceIllegalArgumentException {
        ArrayList<ReferenceObjectBinding> list = new ArrayList<ReferenceObjectBinding>();
        for (ReferenceObjectBinding info : this.referenceObjectBindingMap.values()) {
            if (!info.getKrmsDiscriminatorType().equals(referenceObjectKrmsDiscriminatorType)) continue;
            list.add(info);
        }
        return list;
    }

    public List<ReferenceObjectBinding> findReferenceObjectBindingsByKrmsObject(String krmsObjectId) throws RiceIllegalArgumentException {
        ArrayList<ReferenceObjectBinding> list = new ArrayList<ReferenceObjectBinding>();
        for (ReferenceObjectBinding info : this.referenceObjectBindingMap.values()) {
            if (!info.getKrmsObjectId().equals(krmsObjectId)) continue;
            list.add(info);
        }
        return list;
    }

    public void updateReferenceObjectBinding(ReferenceObjectBinding referenceObjectBindingDefinition) throws RiceIllegalArgumentException {
        ReferenceObjectBinding.Builder copy = ReferenceObjectBinding.Builder.create((ReferenceObjectBindingContract)referenceObjectBindingDefinition);
        ReferenceObjectBinding old = this.getReferenceObjectBinding(referenceObjectBindingDefinition.getId());
        if (!old.getVersionNumber().equals(copy.getVersionNumber())) {
            throw new RiceIllegalStateException("" + old.getVersionNumber());
        }
        copy.setVersionNumber(Long.valueOf(copy.getVersionNumber() + 1L));
        referenceObjectBindingDefinition = copy.build();
        this.referenceObjectBindingMap.put(referenceObjectBindingDefinition.getId(), referenceObjectBindingDefinition);
    }

    public void deleteReferenceObjectBinding(String id) throws RiceIllegalArgumentException {
        if (this.referenceObjectBindingMap.remove(id) == null) {
            throw new RiceIllegalArgumentException(id);
        }
    }

    public List<String> findReferenceObjectBindingIds(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        CriteriaMatcherInMemory<ReferenceObjectBinding> instance = new CriteriaMatcherInMemory<ReferenceObjectBinding>();
        instance.setCriteria(queryByCriteria);
        Collection<ReferenceObjectBinding> selected = instance.findMatching(this.referenceObjectBindingMap.values());
        ArrayList<String> list = new ArrayList<String>();
        for (ReferenceObjectBinding sel : selected) {
            list.add(sel.getId());
        }
        return list;
    }

    public AgendaDefinition createAgenda(AgendaDefinition agendaDefinition) throws RiceIllegalArgumentException {
        AgendaDefinition orig;
        if (agendaDefinition.getId() != null && (orig = this.getAgenda(agendaDefinition.getId())) != null) {
            throw new RiceIllegalArgumentException(agendaDefinition.getId() + "." + agendaDefinition.getName());
        }
        AgendaDefinition existing = this.getAgendaByNameAndContextId(agendaDefinition.getName(), agendaDefinition.getContextId());
        if (existing == null) {
            throw new RiceIllegalArgumentException(agendaDefinition.getName() + " " + agendaDefinition.getContextId() + " already exists");
        }
        AgendaDefinition.Builder copy = AgendaDefinition.Builder.create((AgendaDefinitionContract)agendaDefinition);
        if (copy.getId() == null) {
            copy.setId(UUID.randomUUID().toString());
        }
        copy.setVersionNumber(Long.valueOf(0L));
        agendaDefinition = copy.build();
        this.agendaMap.put(agendaDefinition.getId(), agendaDefinition);
        return agendaDefinition;
    }

    public AgendaDefinition findCreateAgenda(AgendaDefinition agendaDefinition) throws RiceIllegalArgumentException {
        AgendaDefinition agenda = this.getAgendaByNameAndContextId(agendaDefinition.getName(), agendaDefinition.getContextId());
        if (agenda != null) {
            return agenda;
        }
        return this.createAgenda(agendaDefinition);
    }

    public AgendaDefinition getAgendaByNameAndContextId(String name, String contextId) {
        for (AgendaDefinition info : this.agendaMap.values()) {
            if (!info.getContextId().equals(contextId) || !info.getName().equals(name)) continue;
            return info;
        }
        return null;
    }

    public AgendaDefinition getAgenda(String id) throws RiceIllegalArgumentException {
        if (!this.agendaMap.containsKey(id)) {
            throw new RiceIllegalArgumentException(id);
        }
        return this.agendaMap.get(id);
    }

    public List<AgendaDefinition> getAgendasByType(String typeId) throws RiceIllegalArgumentException {
        ArrayList<AgendaDefinition> list = new ArrayList<AgendaDefinition>();
        for (AgendaDefinition info : this.agendaMap.values()) {
            if (!typeId.equals(info.getTypeId())) continue;
            list.add(info);
        }
        return list;
    }

    public List<AgendaDefinition> getAgendasByContext(String contextId) throws RiceIllegalArgumentException {
        ArrayList<AgendaDefinition> list = new ArrayList<AgendaDefinition>();
        for (AgendaDefinition info : this.agendaMap.values()) {
            if (!info.getContextId().equals(contextId)) continue;
            list.add(info);
        }
        return list;
    }

    public List<AgendaDefinition> getAgendasByTypeAndContext(String typeId, String contextId) throws RiceIllegalArgumentException {
        ArrayList<AgendaDefinition> list = new ArrayList<AgendaDefinition>();
        for (AgendaDefinition info : this.agendaMap.values()) {
            if (!info.getContextId().equals(contextId) || !info.getTypeId().equals(typeId)) continue;
            list.add(info);
        }
        return list;
    }

    public void updateAgenda(AgendaDefinition agendaDefinition) throws RiceIllegalArgumentException {
        AgendaDefinition.Builder copy = AgendaDefinition.Builder.create((AgendaDefinitionContract)agendaDefinition);
        AgendaDefinition old = this.getAgenda(agendaDefinition.getId());
        if (!old.getVersionNumber().equals(copy.getVersionNumber())) {
            throw new RiceIllegalStateException("" + old.getVersionNumber());
        }
        copy.setVersionNumber(Long.valueOf(copy.getVersionNumber() + 1L));
        agendaDefinition = copy.build();
        this.agendaMap.put(agendaDefinition.getId(), agendaDefinition);
    }

    public void deleteAgenda(String id) throws RiceIllegalArgumentException {
        if (this.agendaMap.remove(id) == null) {
            throw new RiceIllegalArgumentException(id);
        }
    }

    public AgendaItemDefinition createAgendaItem(AgendaItemDefinition agendaItemDefinition) throws RiceIllegalArgumentException {
        AgendaItemDefinition.Builder copy = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemDefinition);
        if (copy.getId() == null) {
            copy.setId(UUID.randomUUID().toString());
        }
        agendaItemDefinition = copy.build();
        this.agendaItemMap.put(agendaItemDefinition.getId(), agendaItemDefinition);
        return agendaItemDefinition;
    }

    public AgendaItemDefinition getAgendaItem(String id) throws RiceIllegalArgumentException {
        if (!this.agendaItemMap.containsKey(id)) {
            throw new RiceIllegalArgumentException(id);
        }
        return this.agendaItemMap.get(id);
    }

    public List<AgendaItemDefinition> getAgendaItemsByType(String typeId) throws RiceIllegalArgumentException {
        List<AgendaDefinition> agendas = this.getAgendasByType(typeId);
        ArrayList<AgendaItemDefinition> list = new ArrayList<AgendaItemDefinition>();
        for (AgendaDefinition agenda : agendas) {
            for (AgendaItemDefinition info : this.agendaItemMap.values()) {
                if (!agenda.getId().equals(info.getAgendaId())) continue;
                list.add(info);
            }
        }
        return list;
    }

    public List<AgendaItemDefinition> getAgendaItemsByContext(String contextId) throws RiceIllegalArgumentException {
        List<AgendaDefinition> agendas = this.getAgendasByContext(contextId);
        ArrayList<AgendaItemDefinition> list = new ArrayList<AgendaItemDefinition>();
        for (AgendaDefinition agenda : agendas) {
            for (AgendaItemDefinition info : this.agendaItemMap.values()) {
                if (!agenda.getId().equals(info.getAgendaId())) continue;
                list.add(info);
            }
        }
        return list;
    }

    public List<AgendaItemDefinition> getAgendaItemsByTypeAndContext(String typeId, String contextId) throws RiceIllegalArgumentException {
        List<AgendaDefinition> agendas = this.getAgendasByContext(contextId);
        ArrayList<AgendaItemDefinition> list = new ArrayList<AgendaItemDefinition>();
        for (AgendaDefinition agenda : agendas) {
            if (!agenda.getTypeId().equals(typeId)) continue;
            for (AgendaItemDefinition info : this.agendaItemMap.values()) {
                if (!agenda.getId().equals(info.getAgendaId())) continue;
                list.add(info);
            }
        }
        return list;
    }

    public void updateAgendaItem(AgendaItemDefinition agendaItemDefinition) throws RiceIllegalArgumentException {
        AgendaItemDefinition.Builder copy = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemDefinition);
        AgendaItemDefinition old = this.getAgendaItem(agendaItemDefinition.getId());
        if (!old.getVersionNumber().equals(copy.getVersionNumber())) {
            throw new RiceIllegalStateException("" + old.getVersionNumber());
        }
        copy.setVersionNumber(Long.valueOf(copy.getVersionNumber() + 1L));
        agendaItemDefinition = copy.build();
        this.agendaItemMap.put(agendaItemDefinition.getId(), agendaItemDefinition);
    }

    public void deleteAgendaItem(String id) throws RiceIllegalArgumentException {
        if (this.agendaItemMap.remove(id) == null) {
            throw new RiceIllegalArgumentException(id);
        }
    }

    public RuleDefinition getRuleByNameAndNamespace(String name, String namespace) {
        for (RuleDefinition rule : this.ruleMap.values()) {
            if (!rule.getName().equals(name) || !rule.getNamespace().equals(namespace)) continue;
            return rule;
        }
        return null;
    }

    public RuleDefinition createRule(RuleDefinition ruleDefinition) throws RiceIllegalArgumentException {
        RuleDefinition orig;
        if (ruleDefinition.getId() != null && (orig = this.getRule(ruleDefinition.getId())) != null) {
            throw new RiceIllegalArgumentException(ruleDefinition.getId());
        }
        RuleDefinition.Builder copy = RuleDefinition.Builder.create((RuleDefinitionContract)ruleDefinition);
        if (copy.getId() == null) {
            copy.setId(UUID.randomUUID().toString());
        }
        ruleDefinition = copy.build();
        this.ruleMap.put(ruleDefinition.getId(), ruleDefinition);
        return ruleDefinition;
    }

    public RuleDefinition getRule(String ruleId) {
        if (!this.ruleMap.containsKey(ruleId)) {
            throw new RiceIllegalArgumentException(ruleId);
        }
        return this.ruleMap.get(ruleId);
    }

    public List<RuleDefinition> getRules(List<String> ruleIds) {
        ArrayList<RuleDefinition> list = new ArrayList<RuleDefinition>();
        for (String id : ruleIds) {
            list.add(this.getRule(id));
        }
        return list;
    }

    public void updateRule(RuleDefinition ruleDefinition) throws RiceIllegalArgumentException {
        RuleDefinition.Builder copy = RuleDefinition.Builder.create((RuleDefinitionContract)ruleDefinition);
        RuleDefinition old = this.getRule(ruleDefinition.getId());
        if (!old.getVersionNumber().equals(copy.getVersionNumber())) {
            throw new RiceIllegalStateException("" + old.getVersionNumber());
        }
        copy.setVersionNumber(Long.valueOf(copy.getVersionNumber() + 1L));
        ruleDefinition = copy.build();
        this.ruleMap.put(ruleDefinition.getId(), ruleDefinition);
    }

    public void deleteRule(String id) throws RiceIllegalArgumentException {
        if (this.ruleMap.remove(id) == null) {
            throw new RiceIllegalArgumentException(id);
        }
    }

    public ActionDefinition createAction(ActionDefinition actionDefinition) throws RiceIllegalArgumentException {
        ActionDefinition orig = this.getAction(actionDefinition.getId());
        if (orig != null) {
            throw new RiceIllegalArgumentException(actionDefinition.getId());
        }
        ActionDefinition.Builder copy = ActionDefinition.Builder.create((ActionDefinitionContract)actionDefinition);
        if (copy.getId() == null) {
            copy.setId(UUID.randomUUID().toString());
        }
        actionDefinition = copy.build();
        this.actionMap.put(actionDefinition.getId(), actionDefinition);
        return actionDefinition;
    }

    public ActionDefinition getAction(String actionId) {
        if (!this.actionMap.containsKey(actionId)) {
            throw new RiceIllegalArgumentException(actionId);
        }
        return this.actionMap.get(actionId);
    }

    public List<ActionDefinition> getActions(List<String> actionIds) {
        ArrayList<ActionDefinition> list = new ArrayList<ActionDefinition>();
        for (String id : actionIds) {
            list.add(this.getAction(id));
        }
        return list;
    }

    public void updateAction(ActionDefinition actionDefinition) throws RiceIllegalArgumentException {
        ActionDefinition.Builder copy = ActionDefinition.Builder.create((ActionDefinitionContract)actionDefinition);
        ActionDefinition old = this.getAction(actionDefinition.getId());
        if (!old.getVersionNumber().equals(copy.getVersionNumber())) {
            throw new RiceIllegalStateException("" + old.getVersionNumber());
        }
        copy.setVersionNumber(Long.valueOf(copy.getVersionNumber() + 1L));
        actionDefinition = copy.build();
        this.actionMap.put(actionDefinition.getId(), actionDefinition);
    }

    public void deleteAction(String id) throws RiceIllegalArgumentException {
        if (this.actionMap.remove(id) == null) {
            throw new RiceIllegalArgumentException(id);
        }
    }

    public PropositionDefinition createProposition(PropositionDefinition propositionDefinition) throws RiceIllegalArgumentException {
        PropositionDefinition orig;
        if (propositionDefinition.getId() != null && (orig = this.getProposition(propositionDefinition.getId())) != null) {
            throw new RiceIllegalArgumentException(propositionDefinition.getId());
        }
        PropositionDefinition.Builder copy = PropositionDefinition.Builder.create((PropositionDefinitionContract)propositionDefinition);
        if (copy.getId() == null) {
            copy.setId(UUID.randomUUID().toString());
        }
        for (PropositionParameter.Builder paramBldr : copy.getParameters()) {
            if (paramBldr.getId() == null) {
                paramBldr.setId(UUID.randomUUID().toString());
            }
            if (paramBldr.getPropId() == null) {
                paramBldr.setPropId(copy.getId());
            }
            if (paramBldr.getTermValue() == null) continue;
            TermDefinition termValue = paramBldr.getTermValue();
            if (termValue.getId() == null) {
                termValue = this.termRepositoryService.createTerm(termValue);
                paramBldr.setTermValue(termValue);
            }
            if (paramBldr.getValue() != null) continue;
            paramBldr.setValue(termValue.getId());
        }
        propositionDefinition = copy.build();
        this.propositionMap.put(propositionDefinition.getId(), propositionDefinition);
        return propositionDefinition;
    }

    public PropositionDefinition getProposition(String id) throws RiceIllegalArgumentException {
        if (!this.propositionMap.containsKey(id)) {
            throw new RiceIllegalArgumentException(id);
        }
        return this.propositionMap.get(id);
    }

    public Set<PropositionDefinition> getPropositionsByType(String typeId) throws RiceIllegalArgumentException {
        LinkedHashSet<PropositionDefinition> set = new LinkedHashSet<PropositionDefinition>();
        for (PropositionDefinition info : this.propositionMap.values()) {
            if (!typeId.equals(info.getTypeId())) continue;
            set.add(info);
        }
        return set;
    }

    public Set<PropositionDefinition> getPropositionsByRule(String ruleId) throws RiceIllegalArgumentException {
        LinkedHashSet<PropositionDefinition> set = new LinkedHashSet<PropositionDefinition>();
        for (PropositionDefinition info : this.propositionMap.values()) {
            if (!info.getRuleId().equals(ruleId)) continue;
            set.add(info);
        }
        return set;
    }

    public void updateProposition(PropositionDefinition propositionDefinition) throws RiceIllegalArgumentException {
        if (this.propositionMap.containsKey(propositionDefinition.getId())) {
            throw new RiceIllegalArgumentException(propositionDefinition.getId() + "not found");
        }
        PropositionDefinition.Builder copy = PropositionDefinition.Builder.create((PropositionDefinitionContract)propositionDefinition);
        PropositionDefinition old = this.getProposition(propositionDefinition.getId());
        if (!old.getVersionNumber().equals(copy.getVersionNumber())) {
            throw new RiceIllegalStateException("" + old.getVersionNumber());
        }
        copy.setVersionNumber(Long.valueOf(copy.getVersionNumber() + 1L));
        for (PropositionParameter.Builder paramBldr : copy.getParameters()) {
            if (paramBldr.getId() == null) {
                paramBldr.setId(UUID.randomUUID().toString());
            }
            if (paramBldr.getPropId() == null) {
                paramBldr.setPropId(copy.getId());
            }
            if (paramBldr.getTermValue() == null) continue;
            TermDefinition termValue = paramBldr.getTermValue();
            if (termValue.getId() == null) {
                termValue = this.termRepositoryService.createTerm(termValue);
                paramBldr.setTermValue(termValue);
            }
            if (paramBldr.getValue() != null) continue;
            paramBldr.setValue(termValue.getId());
        }
        propositionDefinition = copy.build();
        this.propositionMap.put(propositionDefinition.getId(), propositionDefinition);
    }

    public void deleteProposition(String id) throws RiceIllegalArgumentException {
        if (this.propositionMap.remove(id) == null) {
            throw new RiceIllegalArgumentException(id);
        }
    }

    public NaturalLanguageUsage createNaturalLanguageUsage(NaturalLanguageUsage naturalLanguageUsage) throws RiceIllegalArgumentException {
        try {
            NaturalLanguageUsage orig = this.getNaturalLanguageUsage(naturalLanguageUsage.getId());
            if (orig != null) {
                throw new RiceIllegalArgumentException(naturalLanguageUsage.getId());
            }
        }
        catch (RiceIllegalArgumentException ex) {
            // empty catch block
        }
        NaturalLanguageUsage.Builder copy = NaturalLanguageUsage.Builder.create((NaturalLanguageUsageContract)naturalLanguageUsage);
        if (copy.getId() == null) {
            copy.setId(UUID.randomUUID().toString());
        }
        naturalLanguageUsage = copy.build();
        this.naturalLanguageUsageMap.put(naturalLanguageUsage.getId(), naturalLanguageUsage);
        return naturalLanguageUsage;
    }

    public NaturalLanguageUsage getNaturalLanguageUsage(String id) throws RiceIllegalArgumentException {
        if (!this.naturalLanguageUsageMap.containsKey(id)) {
            throw new RiceIllegalArgumentException(id);
        }
        return this.naturalLanguageUsageMap.get(id);
    }

    public void updateNaturalLanguageUsage(NaturalLanguageUsage naturalLanguageUsage) throws RiceIllegalArgumentException {
        NaturalLanguageUsage.Builder copy = NaturalLanguageUsage.Builder.create((NaturalLanguageUsageContract)naturalLanguageUsage);
        NaturalLanguageUsage old = this.getNaturalLanguageUsage(naturalLanguageUsage.getId());
        if (!old.getVersionNumber().equals(copy.getVersionNumber())) {
            throw new RiceIllegalStateException("" + old.getVersionNumber());
        }
        copy.setVersionNumber(Long.valueOf(copy.getVersionNumber() + 1L));
        naturalLanguageUsage = copy.build();
        this.naturalLanguageUsageMap.put(naturalLanguageUsage.getId(), naturalLanguageUsage);
    }

    public void deleteNaturalLanguageUsage(String naturalLanguageUsageId) throws RiceIllegalArgumentException {
        if (this.naturalLanguageUsageMap.remove(naturalLanguageUsageId) == null) {
            throw new RiceIllegalArgumentException(naturalLanguageUsageId);
        }
    }

    public String translateNaturalLanguageForObject(String naturalLanguageUsageId, String typeId, String krmsObjectId, String languageCode) throws RiceIllegalArgumentException {
        TranslationUtility util = new TranslationUtility(this, this.termRepositoryService, this.templater);
        return util.translateNaturalLanguageForObject(naturalLanguageUsageId, typeId, krmsObjectId, languageCode);
    }

    public String translateNaturalLanguageForProposition(String naturalLanguageUsageId, PropositionDefinition proposition, String languageCode) throws RiceIllegalArgumentException {
        TranslationUtility util = new TranslationUtility(this, this.termRepositoryService, this.templater);
        return util.translateNaturalLanguageForProposition(naturalLanguageUsageId, proposition, languageCode);
    }

    public NaturalLanguageTree translateNaturalLanguageTreeForProposition(String naturalLanguageUsageId, PropositionDefinition propositionDefinintion, String languageCode) throws RiceIllegalArgumentException {
        TranslationUtility util = new TranslationUtility(this, this.termRepositoryService, this.templater);
        return util.translateNaturalLanguageTreeForProposition(naturalLanguageUsageId, propositionDefinintion, languageCode);
    }

    public List<NaturalLanguageUsage> getNaturalLanguageUsagesByNamespace(String namespace) throws RiceIllegalArgumentException {
        ArrayList<NaturalLanguageUsage> list = new ArrayList<NaturalLanguageUsage>();
        for (NaturalLanguageUsage info : this.naturalLanguageUsageMap.values()) {
            if (!namespace.equals(info.getNamespace())) continue;
            list.add(info);
        }
        return list;
    }

    public NaturalLanguageUsage getNaturalLanguageUsageByNameAndNamespace(String name, String namespace) throws RiceIllegalArgumentException {
        for (NaturalLanguageUsage info : this.naturalLanguageUsageMap.values()) {
            if (!namespace.equals(info.getNamespace()) || !name.equals(info.getName())) continue;
            return info;
        }
        return null;
    }

    public ContextDefinition selectContext(ContextSelectionCriteria contextSelectionCriteria) throws RiceIllegalArgumentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AgendaTreeDefinition getAgendaTree(String agendaId) throws RiceIllegalArgumentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<AgendaTreeDefinition> getAgendaTrees(List<String> agendaIds) throws RiceIllegalArgumentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ContextDefinition createContext(ContextDefinition contextDefinition) throws RiceIllegalArgumentException {
        ContextDefinition orig = this.getContextByNameAndNamespace(contextDefinition.getName(), contextDefinition.getNamespace());
        if (orig != null) {
            throw new RiceIllegalArgumentException(contextDefinition.getNamespace() + "." + contextDefinition.getName());
        }
        ContextDefinition.Builder copy = ContextDefinition.Builder.create((ContextDefinitionContract)contextDefinition);
        if (copy.getId() == null) {
            copy.setId(UUID.randomUUID().toString());
        }
        contextDefinition = copy.build();
        this.contextMap.put(contextDefinition.getId(), contextDefinition);
        return contextDefinition;
    }

    public ContextDefinition findCreateContext(ContextDefinition contextDefinition) throws RiceIllegalArgumentException {
        ContextDefinition orig = this.getContextByNameAndNamespace(contextDefinition.getName(), contextDefinition.getNamespace());
        if (orig != null) {
            return orig;
        }
        return this.createContext(contextDefinition);
    }

    public void updateContext(ContextDefinition contextDefinition) throws RiceIllegalArgumentException {
        ContextDefinition.Builder copy = ContextDefinition.Builder.create((ContextDefinitionContract)contextDefinition);
        ContextDefinition old = this.getContext(contextDefinition.getId());
        if (!old.getVersionNumber().equals(copy.getVersionNumber())) {
            throw new RiceIllegalStateException("" + old.getVersionNumber());
        }
        copy.setVersionNumber(Long.valueOf(copy.getVersionNumber() + 1L));
        contextDefinition = copy.build();
        this.contextMap.put(contextDefinition.getId(), contextDefinition);
    }

    public void deleteContext(String id) throws RiceIllegalArgumentException {
        if (this.contextMap.remove(id) == null) {
            throw new RiceIllegalArgumentException(id);
        }
    }

    public ContextDefinition getContext(String id) throws RiceIllegalArgumentException {
        if (!this.contextMap.containsKey(id)) {
            throw new RiceIllegalArgumentException(id);
        }
        return this.contextMap.get(id);
    }

    public ContextDefinition getContextByNameAndNamespace(String name, String namespace) throws RiceIllegalArgumentException {
        if (name == null || name.trim().isEmpty()) {
            throw new RiceIllegalArgumentException("name is null or empty");
        }
        if (namespace == null || namespace.trim().isEmpty()) {
            throw new RiceIllegalArgumentException("name is null or empty");
        }
        for (ContextDefinition info : this.contextMap.values()) {
            if (!name.equals(info.getName()) || !namespace.equals(info.getNamespace())) continue;
            return ContextDefinition.Builder.create((ContextDefinitionContract)info).build();
        }
        return null;
    }

    public NaturalLanguageTemplate createNaturalLanguageTemplate(NaturalLanguageTemplate naturalLanguageTemplate) throws RiceIllegalArgumentException {
        try {
            NaturalLanguageTemplate orig = this.getNaturalLanguageTemplate(naturalLanguageTemplate.getId());
            if (orig != null) {
                throw new RiceIllegalArgumentException(naturalLanguageTemplate.getId());
            }
        }
        catch (RiceIllegalArgumentException ex) {
            // empty catch block
        }
        NaturalLanguageTemplate.Builder copy = NaturalLanguageTemplate.Builder.create((NaturalLanguageTemplateContract)naturalLanguageTemplate);
        if (copy.getId() == null) {
            copy.setId(UUID.randomUUID().toString());
        }
        naturalLanguageTemplate = copy.build();
        this.naturalLanguageTemplateMap.put(naturalLanguageTemplate.getId(), naturalLanguageTemplate);
        return naturalLanguageTemplate;
    }

    public NaturalLanguageTemplate getNaturalLanguageTemplate(String naturalLanguageTemplateId) throws RiceIllegalArgumentException {
        if (!this.naturalLanguageTemplateMap.containsKey(naturalLanguageTemplateId)) {
            throw new RiceIllegalArgumentException(naturalLanguageTemplateId);
        }
        return this.naturalLanguageTemplateMap.get(naturalLanguageTemplateId);
    }

    public void updateNaturalLanguageTemplate(NaturalLanguageTemplate naturalLanguageTemplate) throws RiceIllegalArgumentException {
        NaturalLanguageTemplate.Builder copy = NaturalLanguageTemplate.Builder.create((NaturalLanguageTemplateContract)naturalLanguageTemplate);
        NaturalLanguageTemplate old = this.getNaturalLanguageTemplate(naturalLanguageTemplate.getId());
        if (!old.getVersionNumber().equals(copy.getVersionNumber())) {
            throw new RiceIllegalStateException("" + old.getVersionNumber());
        }
        copy.setVersionNumber(Long.valueOf(copy.getVersionNumber() + 1L));
        naturalLanguageTemplate = copy.build();
        this.naturalLanguageTemplateMap.put(naturalLanguageTemplate.getId(), naturalLanguageTemplate);
    }

    public void deleteNaturalLanguageTemplate(String naturalLanguageTemplateId) throws RiceIllegalArgumentException {
        if (this.naturalLanguageTemplateMap.remove(naturalLanguageTemplateId) == null) {
            throw new RiceIllegalArgumentException(naturalLanguageTemplateId);
        }
    }

    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByLanguageCode(String languageCode) throws RiceIllegalArgumentException {
        ArrayList<NaturalLanguageTemplate> list = new ArrayList<NaturalLanguageTemplate>();
        for (NaturalLanguageTemplate nlt : this.naturalLanguageTemplateMap.values()) {
            if (!nlt.getLanguageCode().equals(languageCode)) continue;
            list.add(nlt);
        }
        return list;
    }

    public NaturalLanguageTemplate findNaturalLanguageTemplateByLanguageCodeTypeIdAndNluId(String languageCode, String typeId, String naturalLanguageUsageId) throws RiceIllegalArgumentException {
        for (NaturalLanguageTemplate nlt : this.naturalLanguageTemplateMap.values()) {
            if (!nlt.getLanguageCode().equals(languageCode) || !nlt.getTypeId().equals(typeId) || !nlt.getNaturalLanguageUsageId().equals(naturalLanguageUsageId)) continue;
            return nlt;
        }
        return null;
    }

    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByNaturalLanguageUsage(String naturalLanguageUsageId) throws RiceIllegalArgumentException {
        ArrayList<NaturalLanguageTemplate> list = new ArrayList<NaturalLanguageTemplate>();
        for (NaturalLanguageTemplate nlt : this.naturalLanguageTemplateMap.values()) {
            if (!nlt.getNaturalLanguageUsageId().equals(naturalLanguageUsageId)) continue;
            list.add(nlt);
        }
        return list;
    }

    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByType(String typeId) throws RiceIllegalArgumentException {
        ArrayList<NaturalLanguageTemplate> list = new ArrayList<NaturalLanguageTemplate>();
        for (NaturalLanguageTemplate nlt : this.naturalLanguageTemplateMap.values()) {
            if (!nlt.getTypeId().equals(typeId)) continue;
            list.add(nlt);
        }
        return list;
    }

    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByTemplate(String template) throws RiceIllegalArgumentException {
        ArrayList<NaturalLanguageTemplate> list = new ArrayList<NaturalLanguageTemplate>();
        for (NaturalLanguageTemplate nlt : this.naturalLanguageTemplateMap.values()) {
            if (!nlt.getTemplate().equals(template)) continue;
            list.add(nlt);
        }
        return list;
    }

    public List<String> findContextIds(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        CriteriaMatcherInMemory<ContextDefinition> instance = new CriteriaMatcherInMemory<ContextDefinition>();
        instance.setCriteria(queryByCriteria);
        Collection<ContextDefinition> selected = instance.findMatching(this.contextMap.values());
        ArrayList<String> list = new ArrayList<String>();
        for (ContextDefinition sel : selected) {
            list.add(sel.getId());
        }
        return list;
    }

    public List<String> findAgendaIds(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        CriteriaMatcherInMemory<AgendaDefinition> instance = new CriteriaMatcherInMemory<AgendaDefinition>();
        instance.setCriteria(queryByCriteria);
        Collection<AgendaDefinition> selected = instance.findMatching(this.agendaMap.values());
        ArrayList<String> list = new ArrayList<String>();
        for (AgendaDefinition sel : selected) {
            list.add(sel.getId());
        }
        return list;
    }

    public List<String> findRuleIds(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        CriteriaMatcherInMemory<RuleDefinition> instance = new CriteriaMatcherInMemory<RuleDefinition>();
        instance.setCriteria(queryByCriteria);
        Collection<RuleDefinition> selected = instance.findMatching(this.ruleMap.values());
        ArrayList<String> list = new ArrayList<String>();
        for (RuleDefinition sel : selected) {
            list.add(sel.getId());
        }
        return list;
    }

    public List<String> findActionIds(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        CriteriaMatcherInMemory<ActionDefinition> instance = new CriteriaMatcherInMemory<ActionDefinition>();
        instance.setCriteria(queryByCriteria);
        Collection<ActionDefinition> selected = instance.findMatching(this.actionMap.values());
        ArrayList<String> list = new ArrayList<String>();
        for (ActionDefinition sel : selected) {
            list.add(sel.getId());
        }
        return list;
    }

    public List<String> findPropositionIds(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        CriteriaMatcherInMemory<PropositionDefinition> instance = new CriteriaMatcherInMemory<PropositionDefinition>();
        instance.setCriteria(queryByCriteria);
        Collection<PropositionDefinition> selected = instance.findMatching(this.propositionMap.values());
        ArrayList<String> list = new ArrayList<String>();
        for (PropositionDefinition sel : selected) {
            list.add(sel.getId());
        }
        return list;
    }
}

