/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.web.form.MaintenanceDocumentForm;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.impl.repository.AgendaItemBo;
import org.kuali.rice.krms.impl.repository.CategoryBo;
import org.kuali.rice.krms.impl.repository.ContextValidTermBo;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.PropositionBo;
import org.kuali.rice.krms.impl.repository.TermBo;
import org.kuali.rice.krms.impl.repository.TermResolverBo;
import org.kuali.rice.krms.impl.repository.TermSpecificationBo;

public class ValidTermsForPropositionValuesFinder
extends UifKeyValuesFinderBase {
    public List<KeyValue> getKeyValues(ViewModel model) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        MaintenanceDocumentForm maintenanceForm = (MaintenanceDocumentForm)model;
        PropositionBo rootProposition = (PropositionBo)maintenanceForm.getDocument().getNewMaintainableObject().getDataObject();
        PropositionBo editModeProposition = this.findPropositionUnderEdit(rootProposition);
        String selectedCategoryId = editModeProposition != null ? editModeProposition.getCategoryId() : null;
        List<ContextValidTermBo> contextValidTerms = this.getContextValidTerms(rootProposition.getRuleId());
        ArrayList<String> termSpecIds = new ArrayList<String>();
        for (ContextValidTermBo validTerm : contextValidTerms) {
            termSpecIds.add(validTerm.getTermSpecificationId());
        }
        if (termSpecIds.size() > 0) {
            QueryResults terms = null;
            HashMap<String, ArrayList<String>> critMap = new HashMap<String, ArrayList<String>>();
            critMap.put("specificationId", termSpecIds);
            QueryByCriteria criteria = QueryByCriteria.Builder.forAttribute((String)"specificationId", termSpecIds).setOrderByAscending(new String[]{"description"}).build();
            terms = KRADServiceLocator.getDataObjectService().findMatching(TermBo.class, criteria);
            if (!CollectionUtils.isEmpty((Collection)terms.getResults())) {
                for (TermBo term : terms.getResults()) {
                    String selectName = term.getDescription();
                    if (StringUtils.isBlank((String)selectName) || "null".equals(selectName)) {
                        selectName = term.getSpecification().getName();
                    }
                    if (!StringUtils.isBlank((String)selectedCategoryId)) {
                        if (!this.isTermSpecificationInCategory(term.getSpecification(), selectedCategoryId)) continue;
                        keyValues.add((KeyValue)new ConcreteKeyValue(term.getId(), selectName));
                        continue;
                    }
                    keyValues.add((KeyValue)new ConcreteKeyValue(term.getId(), selectName));
                }
            }
            QueryByCriteria.Builder termResolverCritBuilder = QueryByCriteria.Builder.forAttribute((String)"outputId", termSpecIds);
            termResolverCritBuilder.setOrderByAscending(new String[]{"name"});
            QueryResults termResolvers = KRADServiceLocator.getDataObjectService().findMatching(TermResolverBo.class, termResolverCritBuilder.build());
            if (termResolvers.getResults() != null) {
                for (TermResolverBo termResolver : termResolvers.getResults()) {
                    if (CollectionUtils.isEmpty(termResolver.getParameterSpecifications())) continue;
                    TermSpecificationBo output = termResolver.getOutput();
                    if (!StringUtils.isBlank((String)selectedCategoryId) && !this.isTermSpecificationInCategory(output, selectedCategoryId)) continue;
                    keyValues.add((KeyValue)new ConcreteKeyValue("parameterized:" + output.getId(), output.getName() + "(" + StringUtils.repeat((String)"_", (String)",", (int)termResolver.getParameterSpecifications().size()) + ")"));
                }
            }
        }
        return keyValues;
    }

    private List<ContextValidTermBo> getContextValidTerms(String ruleId) {
        RuleDefinition rule = KrmsRepositoryServiceLocator.getRuleBoService().getRuleByRuleId(ruleId);
        QueryByCriteria agendaItemCriteria = QueryByCriteria.Builder.forAttribute((String)"ruleId", (Object)rule.getId()).build();
        QueryResults agendaItems = KRADServiceLocator.getDataObjectService().findMatching(AgendaItemBo.class, agendaItemCriteria);
        HashSet<String> agendaIds = new HashSet<String>();
        if (!CollectionUtils.isEmpty((Collection)agendaItems.getResults())) {
            for (AgendaItemBo agendaItem : agendaItems.getResults()) {
                agendaIds.add(agendaItem.getAgendaId());
            }
        }
        HashSet<String> contextIds = new HashSet<String>();
        for (String agendaId : agendaIds) {
            AgendaDefinition agenda = KrmsRepositoryServiceLocator.getAgendaBoService().getAgendaByAgendaId(agendaId);
            if (agenda == null) continue;
            contextIds.add(agenda.getContextId());
        }
        ArrayList<ContextValidTermBo> contextValidTerms = new ArrayList<ContextValidTermBo>();
        for (String contextId : contextIds) {
            QueryResults queryResults = KRADServiceLocator.getDataObjectService().findMatching(ContextValidTermBo.class, QueryByCriteria.Builder.forAttribute((String)"contextId", (Object)contextId).build());
            if (CollectionUtils.isEmpty((Collection)queryResults.getResults())) continue;
            contextValidTerms.addAll(queryResults.getResults());
        }
        return contextValidTerms;
    }

    private boolean isTermSpecificationInCategory(TermSpecificationBo termSpec, String categoryId) {
        if (termSpec.getCategories() != null) {
            for (CategoryBo category : termSpec.getCategories()) {
                if (!categoryId.equals(category.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private PropositionBo findPropositionUnderEdit(PropositionBo currentProposition) {
        PropositionBo result;
        block2: {
            PropositionBo child;
            block1: {
                result = null;
                if (!currentProposition.getEditMode()) break block1;
                result = currentProposition;
                break block2;
            }
            if (currentProposition.getCompoundComponents() == null) break block2;
            Iterator<PropositionBo> i$ = currentProposition.getCompoundComponents().iterator();
            while (i$.hasNext() && (result = this.findPropositionUnderEdit(child = i$.next())) == null) {
            }
        }
        return result;
    }
}

