/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.web.form.InquiryForm;
import org.kuali.rice.krad.web.form.MaintenanceDocumentForm;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.ui.AgendaEditor;

public class ActionTypeValuesFinder
extends UifKeyValuesFinderBase {
    public List<KeyValue> getKeyValues(ViewModel model) {
        AgendaEditor agendaEditor;
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        if (model instanceof InquiryForm) {
            InquiryForm inquiryForm = (InquiryForm)model;
            agendaEditor = (AgendaEditor)inquiryForm.getDataObject();
        } else {
            MaintenanceDocumentForm maintenanceForm = (MaintenanceDocumentForm)model;
            agendaEditor = (AgendaEditor)maintenanceForm.getDocument().getNewMaintainableObject().getDataObject();
        }
        if (agendaEditor.getAgenda() != null && StringUtils.isNotBlank((String)agendaEditor.getAgenda().getContextId())) {
            List actionTypes = this.getKrmsTypeRepositoryService().findAllActionTypesByContextId(agendaEditor.getAgenda().getContextId());
            for (KrmsTypeDefinition actionType : actionTypes) {
                keyValues.add((KeyValue)new ConcreteKeyValue(actionType.getId(), actionType.getName()));
            }
        }
        return keyValues;
    }

    public KrmsTypeRepositoryService getKrmsTypeRepositoryService() {
        return KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService();
    }
}

